/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.monitoring.prometheus.collectors;

import com.teamscale.core.analysis.configuration.index.model.ProjectConfiguration;
import com.teamscale.core.analysis.configuration.index.model.ProjectConfigurationUtils;
import com.teamscale.core.committree.CommitTreeIndex;
import com.teamscale.core.committree.ECommitTreeNodeState;
import com.teamscale.core.index.IndexLayer;
import com.teamscale.core.index.ProjectIndex;
import com.teamscale.core.log.LogIndexBase;
import com.teamscale.core.log.parse.ParseLogIndex;
import com.teamscale.core.log.service.GlobalServiceLogIndex;
import com.teamscale.core.log.service.ProjectServiceLogIndex;
import com.teamscale.core.log.worker.GlobalCriticalEventWorkerLogIndex;
import com.teamscale.core.log.worker.GlobalWorkerLogIndex;
import com.teamscale.core.log.worker.ProjectCriticalEventWorkerLogIndex;
import com.teamscale.core.log.worker.ProjectWorkerLogIndex;
import com.teamscale.core.metrics.directory.MetricDirectoryEntry;
import com.teamscale.core.metrics.directory.MetricDirectoryIndex;
import com.teamscale.core.metrics.schema.MetricDirectorySchema;
import com.teamscale.core.metrics.schema.MetricSchemaIndex;
import com.teamscale.core.runtime.api.progress.EAnalysisState;
import com.teamscale.core.runtime.impl.progress.ProjectAnalysisProgressIndex;
import com.teamscale.core.runtime.impl.rollback.PostponedRollbackIndex;
import com.teamscale.core.runtime.impl.scheduling.ProjectSchedulingFilter;
import com.teamscale.core.runtime.impl.worker.WorkerIndex;
import com.teamscale.index.external.status.ExternalAnalysisPartitionInfo;
import com.teamscale.index.external.status.ExternalAnalysisStatusIndex;
import com.teamscale.index.merge_request.MergeRequest;
import com.teamscale.index.merge_request.MergeRequestIndex;
import com.teamscale.index.merge_request.voting.VotingRecord;
import com.teamscale.index.merge_request.voting.VotingRecordIndex;
import com.teamscale.index.repository.git.common.VotingConnectorUtils;
import com.teamscale.index.repository.status.ProjectConnectorStatus;
import com.teamscale.index.repository.status.ProjectConnectorStatusIndex;
import com.teamscale.service.monitoring.prometheus.PrometheusMetricsUtils;
import com.teamscale.service.monitoring.prometheus.collectors.IndexCallbackMetricsProviderBase;
import io.prometheus.metrics.core.metrics.GaugeWithCallback;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.index.shared.ProjectInfo;
import org.conqat.engine.index.shared.PublicProjectId;
import org.conqat.engine.persistence.index.MetaIndex;
import org.conqat.engine.persistence.index.schema.GlobalStorageSystem;
import org.conqat.engine.persistence.index.schema.IndexSchema;
import org.conqat.engine.persistence.index.schema.ProjectStorageSystem;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.hist.HistoryAccessOption;
import org.conqat.lib.commons.collections.CounterSet;
import org.conqat.lib.commons.function.SupplierWithException;

public class ProjectMetricsCollector
extends IndexCallbackMetricsProviderBase {
    private static final String PROJECT_LABEL_NAME = "project";
    private static final Logger LOGGER = LogManager.getLogger();

    public ProjectMetricsCollector(IndexLayer indexLayer) {
        super(indexLayer);
        this.createCollectors();
    }

    private void createCollectors() {
        ((GaugeWithCallback.Builder)((GaugeWithCallback.Builder)((GaugeWithCallback.Builder)GaugeWithCallback.builder().name("project_content_files")).help("Number of files on the head of the default branch")).labelNames(new String[]{PROJECT_LABEL_NAME})).callback(cb -> this.doForAllProjects(ProjectMetricsCollector::collectProjectContentFileCount, (projectId, metricValue) -> cb.call(metricValue.doubleValue(), new String[]{projectId.projectId}))).register();
        ((GaugeWithCallback.Builder)((GaugeWithCallback.Builder)((GaugeWithCallback.Builder)GaugeWithCallback.builder().name("project_content_loc")).help("Lines of code on the head of the default branch")).labelNames(new String[]{PROJECT_LABEL_NAME})).callback(cb -> this.doForAllProjects(ProjectMetricsCollector::collectProjectContentLocCount, (projectId, metricValue) -> cb.call(metricValue.doubleValue(), new String[]{projectId.projectId}))).register();
        ((GaugeWithCallback.Builder)((GaugeWithCallback.Builder)((GaugeWithCallback.Builder)GaugeWithCallback.builder().name("project_parse_log")).help("Number of parse log entries")).labelNames(new String[]{PROJECT_LABEL_NAME})).callback(cb -> this.doForAllProjects(ProjectMetricsCollector::collectParseLogCount, (projectId, count) -> cb.call((double)count.intValue(), new String[]{projectId.projectId}))).register();
        ((GaugeWithCallback.Builder)((GaugeWithCallback.Builder)((GaugeWithCallback.Builder)GaugeWithCallback.builder().name("project_worker_log")).help("Number of worker log entries")).labelNames(new String[]{PROJECT_LABEL_NAME, "level"})).callback(cb -> {
            this.doForAllProjects(projectStorageSystem -> ProjectMetricsCollector.collectLogCount(projectStorageSystem, ProjectWorkerLogIndex.class), (projectId, data) -> ProjectMetricsCollector.consumeLogCount(projectId, (CounterSet<LogIndexBase.EIndexLogLevel>)data, cb));
            this.collectGlobalLogCount((GaugeWithCallback.Callback)cb, (Class)GlobalWorkerLogIndex.class);
        }).register();
        ((GaugeWithCallback.Builder)((GaugeWithCallback.Builder)((GaugeWithCallback.Builder)GaugeWithCallback.builder().name("project_service_log")).help("Number of service log entries")).labelNames(new String[]{PROJECT_LABEL_NAME, "level"})).callback(cb -> {
            this.doForAllProjects(projectStorageSystem -> ProjectMetricsCollector.collectLogCount(projectStorageSystem, ProjectServiceLogIndex.class), (projectId, data) -> ProjectMetricsCollector.consumeLogCount(projectId, (CounterSet<LogIndexBase.EIndexLogLevel>)data, cb));
            this.collectGlobalLogCount((GaugeWithCallback.Callback)cb, (Class)GlobalServiceLogIndex.class);
        }).register();
        ((GaugeWithCallback.Builder)((GaugeWithCallback.Builder)((GaugeWithCallback.Builder)GaugeWithCallback.builder().name("project_event_log")).help("Number of event log entries")).labelNames(new String[]{PROJECT_LABEL_NAME, "level"})).callback(cb -> {
            this.doForAllProjects(projectStorageSystem -> ProjectMetricsCollector.collectLogCount(projectStorageSystem, ProjectCriticalEventWorkerLogIndex.class), (projectId, data) -> ProjectMetricsCollector.consumeLogCount(projectId, (CounterSet<LogIndexBase.EIndexLogLevel>)data, cb));
            this.collectGlobalLogCount((GaugeWithCallback.Callback)cb, (Class)GlobalCriticalEventWorkerLogIndex.class);
        }).register();
        ((GaugeWithCallback.Builder)((GaugeWithCallback.Builder)((GaugeWithCallback.Builder)GaugeWithCallback.builder().name("project_commit_tree_status")).help("Number of commit tree nodes in given state")).labelNames(new String[]{PROJECT_LABEL_NAME, "state"})).callback(cb -> this.doForAllProjects(ProjectMetricsCollector::collectCommitTreeStatus, (projectId, data) -> ProjectMetricsCollector.consumeCommitTreeStatus(projectId, (CounterSet<ECommitTreeNodeState>)data, cb))).register();
        ((GaugeWithCallback.Builder)((GaugeWithCallback.Builder)((GaugeWithCallback.Builder)GaugeWithCallback.builder().name("project_connector_status")).help("Number of connectors in a malfunctioning state")).labelNames(new String[]{PROJECT_LABEL_NAME, "state"})).callback(cb -> this.doForAllProjects(ProjectMetricsCollector::collectProjectConnectorStatus, (projectId, data) -> ProjectMetricsCollector.consumeProjectConnectorStatus(projectId, (CounterSet<ProjectConnectorStatus.EConnectorStatus>)data, cb))).register();
        ((GaugeWithCallback.Builder)((GaugeWithCallback.Builder)((GaugeWithCallback.Builder)GaugeWithCallback.builder().name("project_analysis_status")).help("The analysis state of the project. " + PrometheusMetricsUtils.createCommentForEnumConversion(EAnalysisState.class))).labelNames(new String[]{PROJECT_LABEL_NAME})).callback(cb -> this.doForAllProjects(ProjectMetricsCollector::collectProjectAnalysisStatus, (projectId, num) -> cb.call((double)num.intValue(), new String[]{projectId.projectId}))).register();
        ((GaugeWithCallback.Builder)((GaugeWithCallback.Builder)((GaugeWithCallback.Builder)GaugeWithCallback.builder().name("project_postponed_rollbacks")).help("The count of currently postponed rollbacks in a project.")).labelNames(new String[]{PROJECT_LABEL_NAME})).callback(cb -> this.doForAllProjects(ProjectMetricsCollector::collectProjectPostponedRollbackCount, (projectId, num) -> cb.call((double)num.intValue(), new String[]{projectId.projectId}))).register();
        ((GaugeWithCallback.Builder)((GaugeWithCallback.Builder)((GaugeWithCallback.Builder)GaugeWithCallback.builder().name("project_paused")).help("Whether a project is paused (1) or not (0).")).labelNames(new String[]{PROJECT_LABEL_NAME, "is_voting_project"})).callback(this::collectProjectSchedulingState).register();
        ((GaugeWithCallback.Builder)((GaugeWithCallback.Builder)GaugeWithCallback.builder().name("projects")).help("Number of projects")).callback(cb -> ProjectMetricsCollector.wrapInStorageExceptionLogger(cb, (SupplierWithException<Double, StorageException>)((SupplierWithException)() -> {
            ProjectIndex projectIndex = this.indexLayer.openProjectIndex();
            return projectIndex.getAllProjectInfos().size();
        }))).register();
        ((GaugeWithCallback.Builder)((GaugeWithCallback.Builder)((GaugeWithCallback.Builder)GaugeWithCallback.builder().name("project_external_uploads")).help("Number of external uploads in a partition.")).labelNames(new String[]{PROJECT_LABEL_NAME, "partition", "status"})).callback(cb -> this.doForAllProjects(ProjectMetricsCollector::collectExternalUploadCount, (projectId, metrics) -> ProjectMetricsCollector.consumeExternalUploadCount(projectId, metrics, cb))).register();
        ((GaugeWithCallback.Builder)((GaugeWithCallback.Builder)((GaugeWithCallback.Builder)GaugeWithCallback.builder().name("project_merge_requests")).help("Number of merge requests per voting state.")).labelNames(new String[]{PROJECT_LABEL_NAME, "state"})).callback(cb -> this.doForAllProjects(ProjectMetricsCollector::collectMergeRequestCount, (projectId, metrics) -> ProjectMetricsCollector.consumeMergeRequestCount(projectId, (CounterSet<VotingRecord.EVotingState>)metrics, cb))).register();
    }

    private static void consumeLogCount(PublicProjectId projectId, CounterSet<LogIndexBase.EIndexLogLevel> data, GaugeWithCallback.Callback cb) {
        for (LogIndexBase.EIndexLogLevel level : LogIndexBase.EIndexLogLevel.values()) {
            cb.call((double)data.getValue((Object)level), new String[]{projectId.projectId, level.name().toLowerCase()});
        }
    }

    private static void consumeCommitTreeStatus(PublicProjectId projectId, CounterSet<ECommitTreeNodeState> data, GaugeWithCallback.Callback cb) {
        for (ECommitTreeNodeState state : ECommitTreeNodeState.values()) {
            cb.call((double)data.getValue((Object)state), new String[]{projectId.projectId, state.name().toLowerCase()});
        }
    }

    private static CounterSet<VotingRecord.EVotingState> collectMergeRequestCount(ProjectStorageSystem projectStorageSystem) throws StorageException {
        try {
            if (!projectStorageSystem.hasIndex(MergeRequestIndex.class)) {
                return CounterSet.empty();
            }
            MergeRequestIndex mergeRequestIndex = (MergeRequestIndex)projectStorageSystem.openProjectIndex(MergeRequestIndex.class, null);
            List allMergeRequests = mergeRequestIndex.getAllMergeRequests();
            List<MergeRequest> openMergeRequests = allMergeRequests.stream().filter(MergeRequest::isOpen).toList();
            VotingRecordIndex votingRecordIndex = (VotingRecordIndex)projectStorageSystem.openProjectIndex(VotingRecordIndex.class, null);
            return ((Optional)ProjectMetricsCollector.getParallelTaskExecutor().computeInParallelBatches(openMergeRequests, batch -> ProjectMetricsCollector.collectForMergeRequestBatch(batch, votingRecordIndex), Collectors.reducing((a, b) -> {
                a.add(b);
                return a;
            }))).orElseGet(CounterSet::new);
        }
        catch (InterruptedException | ExecutionException e) {
            LOGGER.error("Could not retrieve merge requests", (Throwable)e);
            return CounterSet.empty();
        }
    }

    private static void consumeMergeRequestCount(PublicProjectId projectId, CounterSet<VotingRecord.EVotingState> counts, GaugeWithCallback.Callback cb) {
        for (VotingRecord.EVotingState state : VotingRecord.EVotingState.values()) {
            cb.call((double)counts.getValue((Object)state), new String[]{projectId.projectId, state.name()});
        }
    }

    private static CounterSet<VotingRecord.EVotingState> collectForMergeRequestBatch(List<MergeRequest> batch, VotingRecordIndex votingRecordIndex) throws ExecutionException {
        CounterSet votingStateCounts = new CounterSet();
        for (MergeRequest openMergeRequest : batch) {
            try {
                VotingRecord latestVotingRecord = votingRecordIndex.getNewestRecordForBranch(openMergeRequest.getSourceBranch());
                votingStateCounts.inc((Object)latestVotingRecord.state);
            }
            catch (StorageException e) {
                throw new ExecutionException("Could not fetch latest voting record for merge request " + String.valueOf(openMergeRequest.identifier), e);
            }
        }
        return votingStateCounts;
    }

    private static Map<String, CounterSet<EPartitionUploadStatus>> collectExternalUploadCount(ProjectStorageSystem projectStorageSystem) throws StorageException {
        List partitionInfos = (List)((ExternalAnalysisStatusIndex)projectStorageSystem.openProjectIndex(ExternalAnalysisStatusIndex.class, null)).computeWithLock(ExternalAnalysisStatusIndex.LockedIndexAccess::getPartitionInfos);
        HashMap<String, CounterSet<EPartitionUploadStatus>> results = new HashMap<String, CounterSet<EPartitionUploadStatus>>();
        for (ExternalAnalysisPartitionInfo partitionInfo : partitionInfos) {
            CounterSet statusForPartition = new CounterSet();
            statusForPartition.inc((Object)EPartitionUploadStatus.ERROR, partitionInfo.getErrorCount());
            statusForPartition.inc((Object)EPartitionUploadStatus.PENDING, partitionInfo.getPendingCount());
            statusForPartition.inc((Object)EPartitionUploadStatus.SUCCESSFUL, partitionInfo.getUploadCount() - partitionInfo.getErrorCount() - partitionInfo.getPendingCount());
            results.put(partitionInfo.getName(), (CounterSet<EPartitionUploadStatus>)statusForPartition);
        }
        return results;
    }

    private static void consumeExternalUploadCount(PublicProjectId projectId, Map<String, CounterSet<EPartitionUploadStatus>> uploadsPerStatusPerPartition, GaugeWithCallback.Callback cb) {
        for (Map.Entry<String, CounterSet<EPartitionUploadStatus>> entry : uploadsPerStatusPerPartition.entrySet()) {
            String partitionName = entry.getKey();
            CounterSet<EPartitionUploadStatus> countsOfPartition = entry.getValue();
            for (EPartitionUploadStatus status : EPartitionUploadStatus.values()) {
                cb.call((double)countsOfPartition.getValue((Object)status), new String[]{projectId.projectId, partitionName, status.name()});
            }
        }
    }

    private void collectProjectSchedulingState(GaugeWithCallback.Callback cb) {
        try {
            WorkerIndex workerIndex = (WorkerIndex)this.indexLayer.openGlobalIndex(WorkerIndex.class);
            ProjectSchedulingFilter schedulingFilter = workerIndex.getSchedulingFilterAccess().get();
            ProjectIndex projectIndex = this.indexLayer.openProjectIndex();
            List allProjectInfos = projectIndex.getAllProjectInfos();
            for (ProjectInfo visibleProject : allProjectInfos) {
                boolean schedulable = schedulingFilter.isSchedulable(visibleProject.getInternalId());
                double pausedValue = schedulable ? 0.0 : 1.0;
                ProjectConfiguration projectConfiguration = ProjectConfigurationUtils.getProjectConfiguration((ProjectInfo)visibleProject, (IndexLayer)this.indexLayer);
                boolean isVotingProject = VotingConnectorUtils.hasMergeRequestIntegrationEnabled((ProjectConfiguration)projectConfiguration);
                cb.call(pausedValue, new String[]{visibleProject.getPrimaryPublicId().toString(), Boolean.toString(isVotingProject)});
            }
        }
        catch (StorageException e) {
            LOGGER.error("Could not retrieve project scheduling modes.", (Throwable)e);
        }
    }

    private static int collectProjectPostponedRollbackCount(ProjectStorageSystem projectStorageSystem) throws StorageException {
        PostponedRollbackIndex postponedRollbackIndex = (PostponedRollbackIndex)projectStorageSystem.openProjectIndex(PostponedRollbackIndex.class, null);
        return postponedRollbackIndex.getEntryCount();
    }

    private static int collectProjectAnalysisStatus(ProjectStorageSystem projectStorageSystem) throws StorageException {
        ProjectAnalysisProgressIndex progressIndex = (ProjectAnalysisProgressIndex)projectStorageSystem.openProjectIndex(ProjectAnalysisProgressIndex.class, null);
        return progressIndex.getAnalysisState().ordinal();
    }

    private static CounterSet<ProjectConnectorStatus.EConnectorStatus> collectProjectConnectorStatus(ProjectStorageSystem projectStorageSystem) throws StorageException {
        List connectorStatuses = ((ProjectConnectorStatusIndex)projectStorageSystem.openProjectIndex(ProjectConnectorStatusIndex.class, null)).getAllStatuses();
        Map<ProjectConnectorStatus.EConnectorStatus, Integer> counts = connectorStatuses.stream().collect(Collectors.groupingBy(ProjectConnectorStatus::getStatus, Collectors.summingInt(e -> 1)));
        return CounterSet.fromMap(counts);
    }

    private static void consumeProjectConnectorStatus(PublicProjectId projectId, CounterSet<ProjectConnectorStatus.EConnectorStatus> counts, GaugeWithCallback.Callback cb) {
        for (ProjectConnectorStatus.EConnectorStatus status : ProjectConnectorStatus.EConnectorStatus.values()) {
            cb.call((double)counts.getValue((Object)status), new String[]{projectId.projectId, status.name().toLowerCase()});
        }
    }

    private static CounterSet<ECommitTreeNodeState> collectCommitTreeStatus(ProjectStorageSystem projectStorageSystem) throws StorageException {
        CounterSet stateCount = new CounterSet();
        IndexSchema schema = projectStorageSystem.getSchema();
        for (String storeName : schema.getEntryNames()) {
            if (!schema.getEntry(storeName).getIndexClass().equals(CommitTreeIndex.class.getName())) continue;
            for (Map.Entry entry : ((CommitTreeIndex)projectStorageSystem.openProjectIndex(CommitTreeIndex.class, storeName, null)).getStateCount().entrySet()) {
                stateCount.inc((Object)((ECommitTreeNodeState)entry.getKey()), ((Integer)entry.getValue()).intValue());
            }
        }
        return stateCount;
    }

    private static <T extends LogIndexBase<?, ?>> CounterSet<LogIndexBase.EIndexLogLevel> collectLogCount(ProjectStorageSystem projectStorageSystem, Class<T> indexClass) throws StorageException {
        int[] frequencies = ((LogIndexBase)projectStorageSystem.openProjectIndex(indexClass, null)).getLogLevelFrequencies();
        CounterSet result = new CounterSet();
        for (LogIndexBase.EIndexLogLevel level : LogIndexBase.EIndexLogLevel.values()) {
            result.inc((Object)level, frequencies[level.ordinal()]);
        }
        return result;
    }

    private <T extends LogIndexBase<?, ?>> void collectGlobalLogCount(GaugeWithCallback.Callback cb, Class<T> indexClass) {
        try {
            GlobalStorageSystem globalStorageSystem = this.indexLayer.openGlobalStorageSystem();
            int[] globalFrequencies = ((LogIndexBase)globalStorageSystem.openGlobalIndex(indexClass)).getLogLevelFrequencies();
            for (LogIndexBase.EIndexLogLevel level : LogIndexBase.EIndexLogLevel.values()) {
                cb.call((double)globalFrequencies[level.ordinal()], new String[]{"__global__", level.name().toLowerCase()});
            }
        }
        catch (StorageException e) {
            LOGGER.error("Could not retrieve global log count for index '{}'", indexClass, (Object)e);
        }
    }

    private static int collectParseLogCount(ProjectStorageSystem projectStorageSystem) throws StorageException {
        return ((ParseLogIndex)projectStorageSystem.openProjectIndex(ParseLogIndex.class, null)).getNumberOfEntries();
    }

    private static double collectProjectContentFileCount(ProjectStorageSystem projectStorageSystem) throws StorageException {
        return ProjectMetricsCollector.getProjectMetricFromDefaultBranch(projectStorageSystem, "Files").orElse(0.0);
    }

    private static double collectProjectContentLocCount(ProjectStorageSystem projectStorageSystem) throws StorageException {
        return ProjectMetricsCollector.getProjectMetricFromDefaultBranch(projectStorageSystem, "Lines of Code").orElse(0.0);
    }

    private static Optional<Double> getProjectMetricFromDefaultBranch(ProjectStorageSystem projectStorageSystem, String metricName) throws StorageException {
        String defaultBranch = ((MetaIndex)projectStorageSystem.openProjectIndex(MetaIndex.class, null)).getDefaultBranchName();
        MetricDirectorySchema schema = ((MetricSchemaIndex)projectStorageSystem.openProjectIndex(MetricSchemaIndex.class, "metric-schema", HistoryAccessOption.readHeadUnbranched())).getPublicSchema();
        MetricDirectoryEntry metrics = ((MetricDirectoryIndex)projectStorageSystem.openProjectIndex(MetricDirectoryIndex.class, "metric-directory", HistoryAccessOption.readHead((String)defaultBranch))).getMetricDirectoryEntry("");
        if (schema == null || metrics == null) {
            return Optional.empty();
        }
        int metricLocation = schema.getValuePosition(metricName);
        if (metricLocation != -1) {
            return Optional.ofNullable(metrics.getDoubleValueWithoutNullAssert(metricLocation));
        }
        return Optional.empty();
    }

    private static enum EPartitionUploadStatus {
        PENDING,
        ERROR,
        SUCCESSFUL;

    }
}

