/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.project;

import com.teamscale.core.analysis.configuration.model.EAnalysisTool;
import com.teamscale.core.permissions.roles.EGlobalPermission;
import com.teamscale.core.rest.MoreMediaTypes;
import com.teamscale.index.backup.BackupUtils;
import com.teamscale.index.backup.write.BackupWriter;
import com.teamscale.index.configuration.ExternalAnalysisGroup;
import com.teamscale.index.configuration.ExternalFindingsDescription;
import com.teamscale.index.project.ExternalFindingsGroupDescriptionIndex;
import com.teamscale.service.base.ApiBase;
import com.teamscale.service.framework.authorization.RequiresGlobalPermission;
import com.teamscale.service.framework.util.ResponseUtils;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import jakarta.ws.rs.BadRequestException;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.InternalServerErrorException;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.Response;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveInputStream;
import org.apache.commons.compress.archivers.zip.ZipArchiveOutputStream;
import org.conqat.engine.commons.util.JsonSerializationException;
import org.conqat.engine.commons.util.JsonUtils;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.filesystem.FileSystemUtils;
import org.conqat.lib.commons.string.StringUtils;
import org.glassfish.jersey.media.multipart.FormDataBodyPart;
import org.glassfish.jersey.media.multipart.FormDataParam;

@Path(value="api/external-findings")
public class ExternalFindingsImportExportService
extends ApiBase {
    public static final String FINDINGS_ZIP_FILE_NAME = "custom-findings-descriptions.zip";

    @GET
    @Path(value="export")
    @Operation(summary="Export external findings", description="Downloads external findings groups and descriptions as a zip archive", responses={@ApiResponse(responseCode="400", description="The specified group could not be found.")}, tags={"Findings"})
    @RequiresGlobalPermission(value={EGlobalPermission.EDIT_EXTERNAL_FINDINGS_SCHEMA})
    @Produces(value={"application/zip"})
    public Response exportExternalFindings(@Parameter(description="The group to export, if specified") @QueryParam(value="group-name") String groupName) throws IOException, StorageException {
        ExternalFindingsGroupDescriptionIndex index = this.openGlobalIndex(ExternalFindingsGroupDescriptionIndex.class);
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        ExternalFindingsImportExportService.saveFindingsAndTeamscaleVersionToZipStream(index, groupName, outputStream);
        byte[] entity = outputStream.toByteArray();
        return ResponseUtils.getFileDownloadResponse((Object)entity, (MediaType)MoreMediaTypes.APPLICATION_ZIP_TYPE, (String)FINDINGS_ZIP_FILE_NAME);
    }

    @POST
    @Path(value="import")
    @Consumes(value={"multipart/form-data"})
    @RequiresGlobalPermission(value={EGlobalPermission.EDIT_EXTERNAL_FINDINGS_SCHEMA})
    @Operation(summary="Import external findings", description="Uploads external findings groups and/or descriptions put from a zip archive", responses={@ApiResponse(responseCode="400", description="Provided finding groups and/or descriptions not consistent."), @ApiResponse(responseCode="500", description="The server could not read from input.")}, tags={"Findings"})
    public void importExternalFindings(@Parameter(schema=@Schema(type="string", format="binary")) @FormDataParam(value="external-findings") FormDataBodyPart externalFindings) throws IOException, StorageException {
        InputStream inputStream = (InputStream)externalFindings.getValueAs(InputStream.class);
        if (inputStream == null) {
            throw new InternalServerErrorException("Could not read from input.");
        }
        ExternalFindingsGroupDescriptionIndex index = this.openGlobalIndex(ExternalFindingsGroupDescriptionIndex.class);
        try (ZipArchiveInputStream zipArchiveInputStream = new ZipArchiveInputStream((InputStream)new BufferedInputStream(inputStream));){
            ExternalFindingsImportExportService.readGroupsAndFindings(zipArchiveInputStream, index);
        }
    }

    private static void readGroupsAndFindings(ZipArchiveInputStream zipArchiveInputStream, ExternalFindingsGroupDescriptionIndex index) throws IOException, StorageException {
        ZipArchiveEntry zipArchiveEntry;
        String externalFindingDescriptionsFilename = BackupUtils.getExternalFindingDescriptionsFilename((EAnalysisTool)EAnalysisTool.CUSTOM);
        String externalFindingGroupsFilename = BackupUtils.getExternalFindingGroupsFilename((EAnalysisTool)EAnalysisTool.CUSTOM);
        boolean foundFiles = false;
        while ((zipArchiveEntry = zipArchiveInputStream.getNextEntry()) != null) {
            if (zipArchiveEntry.isDirectory()) continue;
            if (zipArchiveEntry.getName().endsWith(externalFindingDescriptionsFilename)) {
                ExternalFindingsImportExportService.saveDescriptions(StringUtils.bytesToString((byte[])FileSystemUtils.readStreamBinary((InputStream)zipArchiveInputStream)), index);
                foundFiles = true;
                continue;
            }
            if (!zipArchiveEntry.getName().endsWith(externalFindingGroupsFilename)) continue;
            ExternalFindingsImportExportService.saveGroups(StringUtils.bytesToString((byte[])FileSystemUtils.readStreamBinary((InputStream)zipArchiveInputStream)), index);
            foundFiles = true;
        }
        if (!foundFiles) {
            throw new BadRequestException("No file " + externalFindingDescriptionsFilename + " or " + externalFindingGroupsFilename + "found in provided archive.");
        }
    }

    private static void saveFindingsAndTeamscaleVersionToZipStream(ExternalFindingsGroupDescriptionIndex index, String groupName, OutputStream outputStream) throws IOException, StorageException, BadRequestException {
        ZipArchiveOutputStream findingsZipOutputStream = new ZipArchiveOutputStream(outputStream);
        String customGroupsFileName = BackupUtils.getExternalFindingGroupsPath((EAnalysisTool)EAnalysisTool.CUSTOM);
        List<ExternalAnalysisGroup> groups = ExternalFindingsImportExportService.getGroups(groupName, index);
        BackupWriter.writeByteArrayToZipFile((ZipArchiveOutputStream)findingsZipOutputStream, (byte[])StringUtils.stringToBytes((String)JsonUtils.serializeToJSON(groups)), (String)customGroupsFileName);
        Predicate<ExternalFindingsDescription> filter = x -> true;
        if (!StringUtils.isEmpty((String)groupName)) {
            Pattern pattern = Pattern.compile(groups.get(0).getMapping());
            filter = description -> pattern.matcher(description.getTypeId()).matches();
        }
        String customDescriptionsFileName = BackupUtils.getExternalFindingDescriptionsPath((EAnalysisTool)EAnalysisTool.CUSTOM);
        BackupWriter.writeByteArrayToZipFile((ZipArchiveOutputStream)findingsZipOutputStream, (byte[])StringUtils.stringToBytes((String)JsonUtils.serializeToJSON((Object)CollectionUtils.filter((Collection)index.getDescriptions(EAnalysisTool.CUSTOM), filter))), (String)customDescriptionsFileName);
        BackupWriter.writeVersionEntries((ZipArchiveOutputStream)findingsZipOutputStream);
        findingsZipOutputStream.close();
    }

    private static List<ExternalAnalysisGroup> getGroups(String groupName, ExternalFindingsGroupDescriptionIndex index) throws StorageException, BadRequestException {
        if (StringUtils.isEmpty((String)groupName)) {
            return index.getGroups(EAnalysisTool.CUSTOM);
        }
        ExternalAnalysisGroup group = index.getGroup(groupName, EAnalysisTool.CUSTOM);
        if (group == null) {
            throw new BadRequestException("Group " + groupName + " not found!");
        }
        return Collections.singletonList(group);
    }

    private static void saveDescriptions(String findingsJson, ExternalFindingsGroupDescriptionIndex index) throws IOException, StorageException, BadRequestException {
        try {
            ExternalFindingsDescription[] descriptions = (ExternalFindingsDescription[])JsonUtils.deserializeFromJson((String)findingsJson, ExternalFindingsDescription[].class);
            index.storeDescriptions(Arrays.asList(descriptions), EAnalysisTool.CUSTOM);
        }
        catch (JsonSerializationException e) {
            throw new BadRequestException("Could not deserialize from json.", (Throwable)e);
        }
    }

    private static void saveGroups(String findingsJson, ExternalFindingsGroupDescriptionIndex index) throws IOException, StorageException, BadRequestException {
        try {
            ExternalAnalysisGroup[] groups = (ExternalAnalysisGroup[])JsonUtils.deserializeFromJson((String)findingsJson, ExternalAnalysisGroup[].class);
            index.storeGroups(Arrays.asList(groups), EAnalysisTool.CUSTOM);
        }
        catch (JsonSerializationException e) {
            throw new BadRequestException("Could not deserialize from json.", (Throwable)e);
        }
    }
}

