/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.project;

import com.teamscale.core.analysis.configuration.index.model.ProjectConfiguration;
import com.teamscale.core.migration.ETeamscaleVersion;
import com.teamscale.core.permissions.roles.EProjectPermission;
import com.teamscale.index.migration.code_scopes.ProjectConfiguration71To98;
import com.teamscale.index.migration.v88_project_alias.V89ProjectConfigurationUnmigrated;
import com.teamscale.service.framework.authorization.RequiresProjectPermission;
import com.teamscale.service.framework.versioning.PublicApi;
import com.teamscale.service.project.ProjectConfigurationService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import jakarta.ws.rs.BadRequestException;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.QueryParam;
import java.util.Map;
import org.conqat.engine.index.shared.PublicProjectId;
import org.conqat.engine.persistence.store.StorageException;

public interface ProjectConfigurationServiceApi {
    @GET
    @PublicApi(since=ETeamscaleVersion.VERSION_9_9_0)
    @RequiresProjectPermission(value={EProjectPermission.VIEW})
    @Operation(summary="Get project configuration", description="Returns the configuration used for creation of the project in the path parameter.", tags={"Project"})
    public ProjectConfiguration getProjectConfiguration(@PathParam(value="project") PublicProjectId var1) throws StorageException;

    @PUT
    @PublicApi(since=ETeamscaleVersion.VERSION_9_9_0)
    @RequiresProjectPermission(value={EProjectPermission.EDIT})
    @Operation(summary="Edit project", description="Edits project based on provided project configuration.", responses={@ApiResponse(responseCode="400", description="Project validation error occurred.", content={@Content(mediaType="application/json", schema=@Schema(implementation=ProjectConfigurationService.ValidationErrorResponseEntity.class))})}, tags={"Project"})
    public boolean editProjectWithConfiguration(@RequestBody ProjectConfiguration var1, @Parameter(description="Parameter for controlling whether to perform a re-analyze of the project if required when changing the project configuration. Certain connector parameter  changes require the project to be re-analyzed for consistency reasons. This flag indicates that the user agreed for a re-analysis.") @QueryParam(value="reanalyze-if-required") boolean var2, @Parameter(description="Indicates whether to skip validation of the project. Can be used to force project creation despite validation errors.") @QueryParam(value="skip-project-validation") boolean var3) throws StorageException, BadRequestException;

    @GET
    @Path(value="properties")
    @PublicApi(since=ETeamscaleVersion.VERSION_2025_9_0)
    @RequiresProjectPermission(value={EProjectPermission.VIEW})
    @Operation(summary="Get project properties", description="Returns the properties of a project.", tags={"Project"})
    public Map<String, String> getProjectProperties(@PathParam(value="project") PublicProjectId var1) throws StorageException;

    @PUT
    @Path(value="properties")
    @PublicApi(since=ETeamscaleVersion.VERSION_2025_9_0)
    @RequiresProjectPermission(value={EProjectPermission.EDIT})
    @Operation(summary="Update project properties", description="Updates the properties of a project. This does not require re-analysis.", tags={"Project"})
    public void updateProjectProperties(@PathParam(value="project") PublicProjectId var1, @RequestBody Map<String, String> var2) throws StorageException;

    @GET
    @PublicApi(since=ETeamscaleVersion.VERSION_7_1_0, deprecatedSince=ETeamscaleVersion.VERSION_9_9_0)
    @RequiresProjectPermission(value={EProjectPermission.VIEW})
    @Operation(summary="Get project configuration", description="Returns the configuration used for creation of the project in the path parameter.", tags={"Project"})
    public ProjectConfiguration71To98 getProjectConfiguration71To98(@PathParam(value="project") PublicProjectId var1) throws StorageException;

    @PUT
    @PublicApi(since=ETeamscaleVersion.VERSION_7_1_0, deprecatedSince=ETeamscaleVersion.VERSION_9_9_0)
    @RequiresProjectPermission(value={EProjectPermission.EDIT})
    @Operation(summary="Edit project", description="Edits project based on provided project configuration.", responses={@ApiResponse(responseCode="400", description="Project validation error occurred.", content={@Content(mediaType="application/json", schema=@Schema(implementation=ProjectConfigurationService.ValidationErrorResponseEntity.class))})}, tags={"Project"})
    public boolean editProjectWithConfiguration71To98(@RequestBody ProjectConfiguration71To98 var1, @Parameter(description="Parameter for controlling whether to perform a re-analyze of the project if required when changing the project configuration. Certain connector parameter  changes require the project to be re-analyzed for consistency reasons. This flag indicates that the user agreed for a re-analysis.") @QueryParam(value="reanalyze-if-required") boolean var2, @Parameter(description="Indicates whether to skip validation of the project. Can be used to force project creation despite validation errors.") @QueryParam(value="skip-project-validation") boolean var3) throws StorageException, BadRequestException;

    @GET
    @PublicApi(since=ETeamscaleVersion.VERSION_5_6_0, deprecatedSince=ETeamscaleVersion.VERSION_7_1_0)
    @RequiresProjectPermission(value={EProjectPermission.VIEW})
    @Operation(summary="Get project configuration", description="Returns the configuration used for creation of the project in the path parameter.", tags={"Project"})
    public V89ProjectConfigurationUnmigrated getProjectConfigurationTeamscale56To70(@PathParam(value="project") PublicProjectId var1, @Parameter(description="Allows to skip resolution of project alias in case project id is directly provided") @QueryParam(value="skip-alias-resolution") boolean var2) throws StorageException;

    @PUT
    @PublicApi(since=ETeamscaleVersion.VERSION_5_6_0, deprecatedSince=ETeamscaleVersion.VERSION_7_1_0)
    @RequiresProjectPermission(value={EProjectPermission.EDIT})
    @Operation(summary="Edit project", description="Edits project based on provided project configuration.", responses={@ApiResponse(responseCode="400", description="Project validation error occurred.", content={@Content(mediaType="application/json", schema=@Schema(implementation=ProjectConfigurationService.ValidationErrorResponseEntity.class))})}, tags={"Project"})
    public boolean editProjectWithConfigurationTeamscale56To70(@RequestBody V89ProjectConfigurationUnmigrated var1, @Parameter(description="Parameter for controlling whether to perform a re-analyze of the project if required when changing the project configuration. Certain connector parameter  changes require the project to be re-analyzed for consistency reasons. This flag indicates that the user agreed for a re-analysis.") @QueryParam(value="reanalyze-if-required") boolean var2, @Parameter(description="Indicates whether to skip validation of the project. Can be used to force project creation despite validation errors.") @QueryParam(value="skip-project-validation") boolean var3) throws StorageException, BadRequestException;
}

