/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.project;

import com.teamscale.service.base.ApiBase;
import com.teamscale.service.dashboard.ParallelProjectInfoLoadingUtils;
import com.teamscale.service.framework.authorization.RequiresNoPermission;
import com.teamscale.service.framework.versioning.CloudApi;
import com.teamscale.service.project.PostponedRollbackCounts;
import com.teamscale.service.project.ProjectsConnectorState;
import com.teamscale.service.project.ProjectsState;
import io.swagger.v3.oas.annotations.Operation;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import java.util.concurrent.ExecutionException;
import org.conqat.engine.persistence.store.StorageException;

@Path(value="api/project-analysis-states")
public class ProjectsStatesService
extends ApiBase {
    public static final String END_POINT = "api/project-analysis-states";
    private static final String PERMISSION_DESCRIPTION = "This service returns project states only for projects that the user has at least view permissions for.";

    @GET
    @Operation(summary="Gets analysis states of all Teamscale projects", description="Provides the most up-to-date information about completed and currently-analyzed projects.", tags={"Project"})
    @RequiresNoPermission(description="This service returns project states only for projects that the user has at least view permissions for.")
    @CloudApi
    public ProjectsState getProjectsStates() throws StorageException, ExecutionException, InterruptedException {
        return ParallelProjectInfoLoadingUtils.getProjectsState(this.getPermissions().getVisibleProjects(), this.getParallelTaskExecutor(), this.getIndexLayer());
    }

    @GET
    @Path(value="connectors")
    @Operation(summary="Gets connector states of all Teamscale projects", description="Provides information about project connector states.", tags={"Project"})
    @RequiresNoPermission(description="This service returns project states only for projects that the user has at least view permissions for.")
    public ProjectsConnectorState getProjectsConnectorStates() throws StorageException, ExecutionException, InterruptedException {
        return ParallelProjectInfoLoadingUtils.getProjectsConnectorState(this.getPermissions().getVisibleProjects(false, true), this.getParallelTaskExecutor(), this.getIndexLayer());
    }

    @GET
    @Path(value="postponed-rollbacks")
    @Operation(summary="Gets postponed rollback counts of all Teamscale projects", description="Provides information about project postponed rollbacks counts.", tags={"Project"})
    @RequiresNoPermission(description="This service returns project states only for projects that the user has at least view permissions for.")
    public PostponedRollbackCounts getPostponedRollbackCounts() throws StorageException, ExecutionException, InterruptedException {
        return ParallelProjectInfoLoadingUtils.getPostponedRollbackCounts(this.getPermissions().getVisibleProjects(true, true), this.getParallelTaskExecutor(), this.getIndexLayer());
    }
}

