/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.project.analysis_profile;

import com.teamscale.core.analysis.configuration.index.AnalysisProfileIndex;
import com.teamscale.core.analysis.configuration.index.model.AnalysisGroup;
import com.teamscale.core.analysis.configuration.index.model.AnalysisProfile;
import com.teamscale.core.analysis.configuration.index.model.QualityIndicator;
import com.teamscale.core.analysis.configuration.model.EAnalysisTool;
import com.teamscale.index.configuration.IncludeExcludePatterns;
import com.teamscale.index.report.EReportFormat;
import com.teamscale.service.base.ApiBase;
import com.teamscale.service.framework.authorization.RequiresNoPermission;
import eu.cqse.check.framework.scanner.ELanguage;
import io.swagger.v3.oas.annotations.Operation;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.QueryParam;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.UnmodifiableMap;
import org.jspecify.annotations.Nullable;

@Path(value="api/connectors/default-patterns")
public class AnalysisProfileToIncludeExcludePatternsService
extends ApiBase {
    private static final UnmodifiableMap<LanguageAndTool, IncludeExcludePatterns> DEFAULT_PATTERNS_PER_LANGUAGE_AND_TOOL = AnalysisProfileToIncludeExcludePatternsService.buildDefaultPatternsPerLanguageAndTool();
    private static final String ABAP_REPORT_PARTITION_MAPPINGS = "\\.(sci)$|^coverage/.*([%$]).*\\.scov$|^coverage/.*\\.(scov)$";

    private static UnmodifiableMap<LanguageAndTool, IncludeExcludePatterns> buildDefaultPatternsPerLanguageAndTool() {
        HashMap<LanguageAndTool, IncludeExcludePatterns> result = new HashMap<LanguageAndTool, IncludeExcludePatterns>();
        AnalysisProfileToIncludeExcludePatternsService.addCsPatterns(result);
        AnalysisProfileToIncludeExcludePatternsService.addCppAndCPatterns(result);
        AnalysisProfileToIncludeExcludePatternsService.addVbPatterns(result);
        AnalysisProfileToIncludeExcludePatternsService.addJavaPatterns(result);
        AnalysisProfileToIncludeExcludePatternsService.addJavaScriptPatterns(result);
        AnalysisProfileToIncludeExcludePatternsService.addAbapPatterns(result);
        AnalysisProfileToIncludeExcludePatternsService.addPhpPatterns(result);
        AnalysisProfileToIncludeExcludePatternsService.addDartPatterns(result);
        return CollectionUtils.asUnmodifiable(result);
    }

    private static void addCsPatterns(Map<LanguageAndTool, IncludeExcludePatterns> into) {
        IncludeExcludePatterns csPatterns = new IncludeExcludePatterns();
        csPatterns.appendExcludedFilePatterns(new String[]{"**.designer.cs", "**.g.cs", "**/AssemblyInfo.cs"});
        csPatterns.appendExcludedContentPatterns(new String[]{"<auto-?generated( .*)?/?>", "\\[.*(System\\.CodeDom\\.Compiler\\.GeneratedCode|System\\.Runtime\\.CompilerServices\\.CompilerGeneratedAttribute)\\([^)]*\\)\\]", "Generated by Swagger Codegen"});
        into.put(LanguageAndTool.of(ELanguage.CS), csPatterns);
    }

    private static void addCppAndCPatterns(Map<LanguageAndTool, IncludeExcludePatterns> into) {
        IncludeExcludePatterns cppAndCPatterns = new IncludeExcludePatterns().appendReportMapping("**/compile_commands.json", EReportFormat.COMPILATION_DATABASE);
        into.put(LanguageAndTool.of(ELanguage.CPP), cppAndCPatterns);
        into.put(LanguageAndTool.of(ELanguage.CPP_MS_CLI), cppAndCPatterns);
        into.put(LanguageAndTool.of(ELanguage.C), cppAndCPatterns);
    }

    private static void addVbPatterns(Map<LanguageAndTool, IncludeExcludePatterns> into) {
        IncludeExcludePatterns vbPatterns = new IncludeExcludePatterns();
        vbPatterns.appendExcludedFilePatterns(new String[]{"**.designer.vb", "**.Designer.vb", "**.g.b", "**.g.i.b", "**/AssemblyInfo.vb"});
        vbPatterns.appendExcludedContentPatterns(new String[]{"<auto-?generated>"});
        into.put(LanguageAndTool.of(ELanguage.VB), vbPatterns);
    }

    private static void addJavaPatterns(Map<LanguageAndTool, IncludeExcludePatterns> into) {
        into.put(LanguageAndTool.of(ELanguage.JAVA), new IncludeExcludePatterns().appendTestIncludePatterns(new String[]{"**/test/**, **/testFixtures/**"}).appendExcludedFilePatterns(new String[]{"**/package-info.java", "**/module-info.java"}));
    }

    private static void addJavaScriptPatterns(Map<LanguageAndTool, IncludeExcludePatterns> into) {
        IncludeExcludePatterns pattern = new IncludeExcludePatterns();
        pattern.appendIncludedFilePatterns(new String[]{"**/tsconfig.json", "**/jsconfig.json", "**.html"});
        pattern.appendExcludedFilePatterns(new String[]{"**/build/**, **/dist/**, **/node_modules/**, **.min.js, **-min.js, **_min.js, **/obfuscated/**, **.d.ts"});
        pattern.appendExcludedContentPatterns(new String[]{"(#|@) sourceMappingURL=.+?"});
        pattern.appendTestIncludePatterns(new String[]{"**/*.test.js, **/*.test.ts, **/*.spec.js, **/*.spec.ts"});
        into.put(LanguageAndTool.of(ELanguage.JAVASCRIPT), pattern);
    }

    private static void addAbapPatterns(Map<LanguageAndTool, IncludeExcludePatterns> into) {
        into.put(LanguageAndTool.of(ELanguage.ABAP), new IncludeExcludePatterns().appendIncludedFilePatterns(new String[]{"objectPaths/**.objectpaths", "\n## Abap DDIC objects from the SAP system\n**.abap_ddic", "\n## Abap CDS objects from the SAP system\n**.abap_cds", "\n## Abap CDS meta objects from the SAP system\n**.abap_ddlx"}).appendExcludedFilePatterns(new String[]{"## Exclude generated Gateway interfaces\n**/CLAS/*_MPC.abap, **/CLAS/*_DPC.abap"}).appendTestIncludePatterns(new String[]{"**/CLAS/*/*CCAU.abap, **/FUGR/*/*T99.abap"}).appendReportMapping("**.sci", EReportFormat.SAP_CODE_INSPECTOR).appendReportMapping("coverage/**.scov", EReportFormat.SAP_COVERAGE).withPartitionPattern(ABAP_REPORT_PARTITION_MAPPINGS));
    }

    private static void addPhpPatterns(Map<LanguageAndTool, IncludeExcludePatterns> into) {
        into.put(LanguageAndTool.of(ELanguage.PHP, EAnalysisTool.PHPSTAN), new IncludeExcludePatterns().appendIncludedFilePatterns(new String[]{"**/composer.json"}));
    }

    private static void addDartPatterns(Map<LanguageAndTool, IncludeExcludePatterns> into) {
        into.put(LanguageAndTool.of(ELanguage.DART), new IncludeExcludePatterns().appendIncludedFilePatterns(new String[]{"**/pubspec.yaml"}).appendExcludedFilePatterns(new String[]{"**/*.g.dart", "**/*.pbenum.dart", "**/*.freezed.dart"}));
    }

    @GET
    @Operation(summary="Get default patterns", description="Returns the default include/exclude patterns for connectors as a map from analysis profile name to the corresponding default patterns based on the languages configured in the respective analysis profile")
    @RequiresNoPermission
    public Map<String, IncludeExcludePatterns> getDefaultPatterns() throws StorageException {
        AnalysisProfileIndex analysisIndex = this.openGlobalIndex(AnalysisProfileIndex.class);
        HashMap<String, IncludeExcludePatterns> profileToDefaultPatterns = new HashMap<String, IncludeExcludePatterns>();
        for (AnalysisProfile analysisProfile : analysisIndex.getAllProfiles()) {
            AnalysisProfileToIncludeExcludePatternsService.addProfileNameWithPatterns(profileToDefaultPatterns, analysisProfile);
        }
        return profileToDefaultPatterns;
    }

    @GET
    @Path(value="/languages")
    @Operation(summary="Get default patterns", description="Returns the default include/exclude patterns for connectors based on the given languages. Does not contain tool specific includes.")
    @RequiresNoPermission
    public IncludeExcludePatterns getDefaultPatternsForLanguages(@QueryParam(value="languages") List<ELanguage> languageList) throws StorageException {
        return AnalysisProfileToIncludeExcludePatternsService.getDefaultIncludeExcludePatterns(languageList);
    }

    private static void addProfileNameWithPatterns(HashMap<String, IncludeExcludePatterns> profileToDefaultPatterns, AnalysisProfile analysisProfile) {
        IncludeExcludePatterns joinedPatterns = AnalysisProfileToIncludeExcludePatternsService.getDefaultIncludeExcludePatterns(analysisProfile);
        profileToDefaultPatterns.put(analysisProfile.getName(), joinedPatterns);
    }

    private static IncludeExcludePatterns getDefaultIncludeExcludePatterns(AnalysisProfile analysisProfile) {
        IncludeExcludePatterns joinedPatterns = new IncludeExcludePatterns();
        joinedPatterns.merge(AnalysisProfileToIncludeExcludePatternsService.getDefaultIncludeExcludePatterns((Collection<ELanguage>)analysisProfile.getLanguages()));
        joinedPatterns.merge(AnalysisProfileToIncludeExcludePatternsService.getDefaultIncludeExcludePatterns((Collection<EAnalysisTool>)analysisProfile.getTools(), (Collection<ELanguage>)analysisProfile.getLanguages()));
        if (AnalysisProfileToIncludeExcludePatternsService.containsArchitectureAnalysis(analysisProfile)) {
            joinedPatterns.appendIncludedFilePatterns(new String[]{"**.architecture"});
        }
        return joinedPatterns;
    }

    private static IncludeExcludePatterns getDefaultIncludeExcludePatterns(Collection<ELanguage> languages) {
        IncludeExcludePatterns joinedPatterns = new IncludeExcludePatterns();
        for (ELanguage language : languages) {
            for (String extension : language.getFileExtensions()) {
                joinedPatterns.appendIncludedFilePatterns(new String[]{"**." + extension});
            }
            joinedPatterns.merge((IncludeExcludePatterns)DEFAULT_PATTERNS_PER_LANGUAGE_AND_TOOL.get((Object)LanguageAndTool.of(language)));
        }
        return joinedPatterns;
    }

    private static IncludeExcludePatterns getDefaultIncludeExcludePatterns(Collection<EAnalysisTool> tools, Collection<ELanguage> languages) {
        IncludeExcludePatterns joinedPatterns = new IncludeExcludePatterns();
        for (EAnalysisTool tool : tools) {
            joinedPatterns.merge((IncludeExcludePatterns)DEFAULT_PATTERNS_PER_LANGUAGE_AND_TOOL.get((Object)LanguageAndTool.of(tool)));
            tool.getSupportedLanguages().stream().filter(languages::contains).map(language -> LanguageAndTool.of(language, tool)).map(arg_0 -> DEFAULT_PATTERNS_PER_LANGUAGE_AND_TOOL.get(arg_0)).forEach(arg_0 -> ((IncludeExcludePatterns)joinedPatterns).merge(arg_0));
        }
        return joinedPatterns;
    }

    private static boolean containsArchitectureAnalysis(AnalysisProfile profile) {
        for (QualityIndicator qualityIndicator : profile.getQualityIndicators()) {
            for (AnalysisGroup group : qualityIndicator.getGroups()) {
                if (!group.getName().equals("Architecture Conformance")) continue;
                return true;
            }
        }
        return false;
    }

    private record LanguageAndTool(@Nullable ELanguage language, @Nullable EAnalysisTool tool) {
        private LanguageAndTool(@Nullable ELanguage language, @Nullable EAnalysisTool tool) {
            if (language == null && tool == null) {
                throw new IllegalArgumentException("Either language or tool must be provided");
            }
        }

        static LanguageAndTool of(ELanguage language, EAnalysisTool tool) {
            Objects.requireNonNull(language, "language");
            Objects.requireNonNull(tool, "tool");
            return new LanguageAndTool(language, tool);
        }

        static LanguageAndTool of(ELanguage language) {
            Objects.requireNonNull(language, "language");
            return new LanguageAndTool(language, null);
        }

        static LanguageAndTool of(EAnalysisTool tool) {
            Objects.requireNonNull(tool, "tool");
            return new LanguageAndTool(null, tool);
        }
    }
}

