/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.project.branch_tags;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.conqat.lib.commons.collections.Pair;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.string.StringUtils;

public class BranchTagSupplier {
    private final List<TagPattern> tagPatterns = new ArrayList<TagPattern>();

    public BranchTagSupplier(PairList<String, String> branchTagsAndRegexes) {
        for (Pair tagAndRegex : branchTagsAndRegexes) {
            String tagName = (String)tagAndRegex.getFirst();
            String regex = (String)tagAndRegex.getSecond();
            if (StringUtils.isEmpty((String)tagName) || StringUtils.isEmpty((String)regex)) continue;
            try {
                Pattern compiledPattern = Pattern.compile(regex);
                this.tagPatterns.add(new TagPattern(tagName, compiledPattern));
            }
            catch (PatternSyntaxException patternSyntaxException) {}
        }
    }

    public List<String> getTagsForBranch(String branchName) {
        ArrayList<String> matchingTags = new ArrayList<String>();
        if (StringUtils.isEmpty((String)branchName)) {
            return matchingTags;
        }
        for (TagPattern tagPattern : this.tagPatterns) {
            if (!tagPattern.pattern.matcher(branchName).matches()) continue;
            matchingTags.add(tagPattern.tagName);
        }
        return matchingTags;
    }

    private record TagPattern(String tagName, Pattern pattern) {
    }
}

