/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.project.project_creation_wizard;

import com.teamscale.commons.service.client.ServiceCallException;
import com.teamscale.core.accounts.ExternalCredentials;
import com.teamscale.core.accounts.ExternalCredentialsIndex;
import com.teamscale.core.permissions.roles.EBasicPermission;
import com.teamscale.core.permissions.roles.EBasicPermissionScope;
import com.teamscale.index.merge_request.MergeRequest;
import com.teamscale.index.repository.git.GitBranchRetriever;
import com.teamscale.index.repository.git.gitlab.GitLabClient;
import com.teamscale.index.repository.git.gitlab.GitLabMergeRequestProvider;
import com.teamscale.index.repository.git.gitlab.data.GitLabProject;
import com.teamscale.service.base.ApiBase;
import com.teamscale.service.framework.authorization.RequiresBasicPermission;
import com.teamscale.service.project.project_creation_wizard.ImportantBranchCalculator;
import com.teamscale.service.project.project_creation_wizard.ProjectLanguage;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.QueryParam;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.core.pattern.IncludeExcludeRegexSupport;
import org.conqat.engine.index.shared.RepositoryException;
import org.conqat.engine.persistence.store.StorageException;

@Path(value="api/projects/gitlab/{credentialsName}")
public class GitlabRepositoriesService
extends ApiBase {
    private static final Logger LOGGER = LogManager.getLogger();

    @GET
    @Operation(summary="Gets GitLab repositories for an account", description="Get all GitLab repositories that the current user has maintainer access to.", tags={"Project"})
    @RequiresBasicPermission(scope=EBasicPermissionScope.EXTERNAL_TOOL_ACCOUNTS, permissions={EBasicPermission.VIEW}, entityPathParameter="credentialsName")
    public List<GitLabProject> fetchGitlabProjects(@Parameter(description="Name of the external accounts") @PathParam(value="credentialsName") String credentialsName) throws StorageException, ServiceCallException {
        return this.getGitLabClient(credentialsName).listProjectsUserHasReporterAccessTo();
    }

    @GET
    @Path(value="languages")
    @Operation(summary="Get GitLab repository languages", description="Gets all languages associated with a GitLab repository, including their usage percentages in the project codebase.", tags={"Project"})
    @RequiresBasicPermission(scope=EBasicPermissionScope.EXTERNAL_TOOL_ACCOUNTS, permissions={EBasicPermission.VIEW}, entityPathParameter="credentialsName")
    public List<ProjectLanguage> getLanguagesForGitlabProject(@Parameter(description="Name of the external account") @PathParam(value="credentialsName") String credentialsName, @Parameter(description="ID of the GitLab repository") @QueryParam(value="repoId") String projectId) throws StorageException, ServiceCallException {
        GitLabClient client = this.getGitLabClient(credentialsName);
        Map languagesMapFromGitLab = client.getLanguagesForProject(projectId).getLanguages();
        return ProjectLanguage.fromGitLab(languagesMapFromGitLab);
    }

    @GET
    @Path(value="access-level")
    @Operation(summary="Get current user's access level", description="Gets the access level for the current user in a given GitLab repository.", tags={"Project"})
    @RequiresBasicPermission(scope=EBasicPermissionScope.EXTERNAL_TOOL_ACCOUNTS, permissions={EBasicPermission.VIEW}, entityPathParameter="credentialsName")
    public int getAccessLevel(@Parameter(description="Name of the external account") @PathParam(value="credentialsName") String credentialsName, @Parameter(description="ID of the GitLab repository") @QueryParam(value="repoId") String repoId) throws StorageException, ServiceCallException {
        return this.getGitLabClient(credentialsName).getProjectAccessLevel(repoId).getLevel();
    }

    @GET
    @Path(value="default-branch")
    @Operation(summary="Get GitLab default branch", description="Gets the default branch of a GitLab repository.", tags={"Project"})
    @RequiresBasicPermission(scope=EBasicPermissionScope.EXTERNAL_TOOL_ACCOUNTS, permissions={EBasicPermission.VIEW}, entityPathParameter="credentialsName")
    public String getDefaultBranchForGitlabProject(@Parameter(description="Name of the external account") @PathParam(value="credentialsName") String credentialsName, @Parameter(description="ID of the GitLab repository") @QueryParam(value="repoId") String projectId) throws StorageException, ServiceCallException {
        GitLabClient client = this.getGitLabClient(credentialsName);
        GitLabProject project = client.getProject(projectId);
        return project.getDefaultBranch();
    }

    @GET
    @Path(value="branches")
    @Operation(summary="Get GitLab default branch", description="Gets the default branch of a GitLab repository.", tags={"Project"})
    @RequiresBasicPermission(scope=EBasicPermissionScope.EXTERNAL_TOOL_ACCOUNTS, permissions={EBasicPermission.VIEW}, entityPathParameter="credentialsName")
    public List<String> getAllBranchesForGitlabProject(@Parameter(description="Name of the external account") @PathParam(value="credentialsName") String credentialsName, @Parameter(description="ID of the GitLab repository") @QueryParam(value="repoId") String projectId) throws StorageException, ServiceCallException {
        return this.getBranches(credentialsName, projectId);
    }

    @GET
    @Path(value="important-branches")
    @Operation(summary="Get GitLab important branches", description="Gets the important branches of a GitLab repository.", tags={"Project"})
    @RequiresBasicPermission(scope=EBasicPermissionScope.EXTERNAL_TOOL_ACCOUNTS, permissions={EBasicPermission.VIEW}, entityPathParameter="credentialsName")
    public List<String> getImportantBranchesForGitlabProject(@Parameter(description="Name of the external account") @PathParam(value="credentialsName") String credentialsName, @Parameter(description="ID of the GitLab repository") @QueryParam(value="repoId") String projectId) throws StorageException, ServiceCallException {
        GitLabClient client = this.getGitLabClient(credentialsName);
        GitLabMergeRequestProvider mergeRequestProvider = new GitLabMergeRequestProvider(projectId, client, new IncludeExcludeRegexSupport());
        ImportantBranchCalculator importantBranchCalculator = new ImportantBranchCalculator(mergeRequestProvider.getAllSupportedOpenMergeRequests().stream().map(MergeRequest::getTargetBranch).toList(), this.getBranches(credentialsName, projectId), List.of());
        return importantBranchCalculator.getImportantBranchPattern();
    }

    private GitLabClient getGitLabClient(String credentialsName) throws StorageException {
        ExternalCredentialsIndex externalCredentialsIndex = (ExternalCredentialsIndex)this.getIndexLayer().openGlobalIndex(ExternalCredentialsIndex.class);
        ExternalCredentials externalCredentials = externalCredentialsIndex.getExternalCredentials(credentialsName);
        if (externalCredentials == null) {
            throw new StorageException("User not found.");
        }
        return new GitLabClient(externalCredentials.uri, externalCredentials.password, LOGGER);
    }

    private List<String> getBranches(String credentialsName, String projectId) throws StorageException, ServiceCallException {
        ExternalCredentialsIndex externalCredentialsIndex = (ExternalCredentialsIndex)this.getIndexLayer().openGlobalIndex(ExternalCredentialsIndex.class);
        ExternalCredentials externalCredentials = externalCredentialsIndex.getExternalCredentials(credentialsName);
        if (externalCredentials == null) {
            throw new StorageException("User not found.");
        }
        GitLabClient client = new GitLabClient(externalCredentials.uri, externalCredentials.password, LOGGER);
        try {
            return new ArrayList<String>(GitBranchRetriever.getGitBranches((URI)client.getProject(projectId).getHttpUriToRepo(), (String)externalCredentials.username, (String)externalCredentials.password));
        }
        catch (RepositoryException e) {
            throw new ServiceCallException((Throwable)e);
        }
    }
}

