/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.project.wizard;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.exc.InvalidFormatException;
import com.fasterxml.jackson.dataformat.toml.TomlMapper;
import com.teamscale.service.project.wizard.ImportWizardService;
import eu.cqse.check.framework.scanner.ELanguage;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.lib.commons.filesystem.FileSystemUtils;
import org.conqat.lib.commons.js_export.ExportToTypeScript;
import org.conqat.lib.commons.resources.Resource;
import org.jspecify.annotations.Nullable;

public class ImportWizardRegistry {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Map<String, ImportWizardService.Backup> AVAILABLE_BACKUPS = new HashMap<String, ImportWizardService.Backup>();

    public static void registerPath(Path path, EProjectType projectType) {
        try (DirectoryStream<Path> projectFolders = Files.newDirectoryStream(path);){
            for (Path projectDirectory : projectFolders) {
                String projectId = projectDirectory.getFileName().toString();
                if (FileSystemUtils.isSystemFileName((String)projectId)) continue;
                Path backup = projectDirectory.resolve("backup.zip");
                String backupPath = backup.toAbsolutePath().toString();
                Path tomlPath = projectDirectory.resolve("description.toml");
                ProjectDescription parsedToml = ImportWizardRegistry.getParsedToml(tomlPath);
                if (parsedToml == null) {
                    LOGGER.warn("Could not read TOML file: " + String.valueOf(tomlPath));
                    continue;
                }
                AVAILABLE_BACKUPS.put(projectId, new ImportWizardService.Backup(parsedToml.title, parsedToml.description, backupPath, parsedToml.languages, parsedToml.logo, projectType));
            }
        }
        catch (IOException e) {
            LOGGER.error("Error reading available projects under path: " + String.valueOf(path.toAbsolutePath()), (Throwable)e);
        }
    }

    public static Map<String, ImportWizardService.Backup> getAvailableBackups() {
        return AVAILABLE_BACKUPS;
    }

    private static @Nullable ProjectDescription getParsedToml(Path teamscaleTomlFile) throws IOException {
        String teamscaleToml = Files.readString(teamscaleTomlFile);
        return ImportWizardRegistry.getParsedToml(teamscaleTomlFile.getFileName().toString(), teamscaleToml);
    }

    private static @Nullable ProjectDescription getParsedToml(String teamscaleTomlFile, String teamscaleToml) throws IOException {
        try {
            return ProjectDescription.parse(teamscaleToml);
        }
        catch (InvalidFormatException e) {
            LOGGER.error("Could not parse TOML " + teamscaleTomlFile, (Throwable)e);
            return null;
        }
    }

    public static void registerResources(List<Resource> resources, EProjectType projectType) {
        try {
            for (Resource resource : resources) {
                ProjectDescription parsedToml = ImportWizardRegistry.getParsedToml(resource.getPath(), resource.getContentAsRawString());
                if (parsedToml == null) {
                    LOGGER.warn("Could not read TOML: " + resource.getPath());
                    continue;
                }
                AVAILABLE_BACKUPS.put(Path.of(resource.getPath(), new String[0]).getParent().getFileName().toString(), new ImportWizardService.Backup(parsedToml.title, parsedToml.description, parsedToml.backupUrl, parsedToml.languages, parsedToml.logo, projectType));
            }
        }
        catch (IOException e) {
            LOGGER.error("Error reading available projects from resource folder.", (Throwable)e);
        }
    }

    public record ProjectDescription(@JsonProperty(value="title") String title, @JsonProperty(value="description") String description, @JsonProperty(value="languages") List<ELanguage> languages, @JsonProperty(value="logo") @Nullable String logo, @JsonProperty(value="backupUrl") @Nullable String backupUrl) {
        public static ProjectDescription parse(String toml) throws IOException {
            TomlMapper mapper = (TomlMapper)((TomlMapper.Builder)TomlMapper.builder().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false)).build();
            return (ProjectDescription)mapper.readValue(toml, ProjectDescription.class);
        }
    }

    @ExportToTypeScript
    public static enum EProjectType {
        PUBLIC,
        DEV,
        USER;

    }
}

