/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.reports;

import com.teamscale.core.permissions.roles.EBasicPermissionScope;
import com.teamscale.index.quality_report.QualityArtifactDescriptor;
import com.teamscale.index.quality_report.QualityArtifactIndexBase;
import com.teamscale.index.quality_report.QualityArtifactParameters;
import com.teamscale.service.base.ElementListServiceBase;
import com.teamscale.service.reports.QualityArtifactValidator;
import jakarta.ws.rs.NotFoundException;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.date.DateTimeUtils;

public abstract class QualityArtifactServiceBase<QUALITYARTIFACT extends QualityArtifactDescriptor>
extends ElementListServiceBase<QUALITYARTIFACT> {
    protected abstract QualityArtifactIndexBase<QUALITYARTIFACT> openQualityArtifactIndex() throws StorageException;

    @Override
    protected void deleteElement(QUALITYARTIFACT elementToDelete) throws StorageException {
        this.openQualityArtifactIndex().remove(elementToDelete);
    }

    @Override
    protected QUALITYARTIFACT getElement(String artifactId) throws StorageException {
        return (QUALITYARTIFACT)this.openQualityArtifactIndex().getById(artifactId);
    }

    @Override
    protected void updateElement(QUALITYARTIFACT oldElement, QUALITYARTIFACT newElement) throws StorageException {
        QualityArtifactValidator.getValidator(newElement, this.serviceInfo).validateOrThrow();
        newElement.getMetaInfo().setUpdatedTimestamp(DateTimeUtils.millisNow());
        this.openQualityArtifactIndex().setQualityArtifact(newElement.getMetaInfo().getId(), newElement);
    }

    @Override
    protected void createElement(QUALITYARTIFACT newQualityArtifact) throws StorageException {
        QualityArtifactValidator.getValidator(newQualityArtifact, this.serviceInfo).validateOrThrow();
        QualityArtifactIndexBase<QUALITYARTIFACT> qualityArtifactIndex = this.openQualityArtifactIndex();
        qualityArtifactIndex.storeQualityArtifactWithNewId(newQualityArtifact);
    }

    protected QUALITYARTIFACT copyQualityArtifact(String templateQualityArtifactId, QualityArtifactParameters tempQualityArtifact) throws StorageException {
        this.checkMayCreateQualityArtifact(tempQualityArtifact);
        QualityArtifactIndexBase<QUALITYARTIFACT> artifactIndex = this.openQualityArtifactIndex();
        QualityArtifactDescriptor existingArtifact = artifactIndex.getById(templateQualityArtifactId);
        QualityArtifactServiceBase.ensureQualityArtifactExists(templateQualityArtifactId, existingArtifact);
        QualityArtifactDescriptor newQualityArtifact = this.createQualityArtifactCopy(tempQualityArtifact, existingArtifact);
        QualityArtifactValidator.getValidator(newQualityArtifact, this.serviceInfo).validateOrThrow();
        return (QUALITYARTIFACT)newQualityArtifact;
    }

    protected abstract void checkMayCreateQualityArtifact(QualityArtifactParameters var1) throws StorageException;

    protected abstract QUALITYARTIFACT createQualityArtifactCopy(QualityArtifactParameters var1, QUALITYARTIFACT var2);

    private static <QUALITYARTIFACT> void ensureQualityArtifactExists(String templateQualityArtifactId, QUALITYARTIFACT existingQualityArtifact) {
        if (existingQualityArtifact == null) {
            throw new NotFoundException("Existing report with id " + templateQualityArtifactId + " was not found");
        }
    }

    protected abstract EBasicPermissionScope getPermissionScope();

    @Override
    protected void createPermissions(QUALITYARTIFACT newElement) throws StorageException {
        this.getPermissions().createPermissionModifier().makeCurrentUserOwner(this.getPermissionScope(), newElement.getMetaInfo().getId());
    }

    @Override
    protected void deletePermissions(QUALITYARTIFACT deletedElement) throws StorageException {
        this.getPermissions().createPermissionModifier().removeBasicRoleInstanceAssignments(this.getPermissionScope(), deletedElement.getMetaInfo().getId());
    }
}

