/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.repository;

import com.teamscale.core.accounts.ExternalCredentialsIndex;
import com.teamscale.core.accounts.IExternalCredentialsProvider;
import com.teamscale.core.analysis.configuration.ConnectorUtils;
import com.teamscale.core.analysis.configuration.ProjectConfigurationException;
import com.teamscale.core.analysis.configuration.index.model.ConnectorConfiguration;
import com.teamscale.core.analysis.configuration.index.model.ProjectConfiguration;
import com.teamscale.core.analysis.configuration.model.ConfigurationInitializationContext;
import com.teamscale.core.analysis.configuration.model.connectors.ConnectorDescriptorBase;
import com.teamscale.core.index.IndexLayer;
import com.teamscale.core.index.ProjectIndex;
import com.teamscale.core.option.server.ServerOptionIndex;
import com.teamscale.core.options.RepositoryCloneOption;
import com.teamscale.core.permissions.roles.EGlobalPermission;
import com.teamscale.core.utils.ProjectUtils;
import com.teamscale.index.repository.git.GitRepositoryConnection;
import com.teamscale.index.repository.git.GitRepositoryConnector;
import com.teamscale.index.repository.git.GitRepositoryConnectorDescriptor;
import com.teamscale.index.repository.git.GitRepositoryInfoIndex;
import com.teamscale.service.base.ApiBase;
import com.teamscale.service.framework.authorization.RequiresGlobalPermission;
import com.teamscale.service.repository.GitRepositoryConnectorUtils;
import io.swagger.v3.oas.annotations.Operation;
import jakarta.ws.rs.GET;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.index.shared.IProjectId;
import org.conqat.engine.index.shared.InternalProjectId;
import org.conqat.engine.index.shared.ProjectInfo;
import org.conqat.engine.index.shared.RepositoryException;
import org.conqat.engine.persistence.store.StorageException;
import org.jetbrains.annotations.VisibleForTesting;
import org.jspecify.annotations.NonNull;

@jakarta.ws.rs.Path(value="api/git-repository-clones")
public class GitRepositoryClonesService
extends ApiBase {
    private static final Logger LOGGER = LogManager.getLogger();
    @VisibleForTesting
    static final Pattern VERSION_DIRECTORY_PATTERN = Pattern.compile("v\\d+", 2);
    @VisibleForTesting
    static final List<String> WELL_KNOWN_BARE_REPO_CONTENTS = List.of("config", "objects", "refs");

    @GET
    @jakarta.ws.rs.Path(value="directories")
    @RequiresGlobalPermission(value={EGlobalPermission.ACCESS_ADMINISTRATIVE_SERVICES})
    @Operation(summary="Get information about the directories within the git clones directory", description="Returns a list of all directories containing local git repository clones.", tags={"Debugging", "Administration", "Repositories"})
    public List<RepositoryCloneDirectory> getGitCloneDirectories() throws StorageException, IOException {
        Map<String, Set<String>> absoluteCloneDirectoryToProjectIds = this.createAbsoluteCloneDirectoryToProjectIds();
        Path cloneDirectory = RepositoryCloneOption.getRepositoryCloneDirectory((ServerOptionIndex)this.openGlobalIndex(ServerOptionIndex.class));
        return GitRepositoryClonesService.scanCloneDirectories(cloneDirectory, absoluteCloneDirectoryToProjectIds, true);
    }

    @VisibleForTesting
    static List<RepositoryCloneDirectory> scanCloneDirectories(Path cloneDirectory, Map<String, Set<String>> absoluteCloneDirectoryToProjectIds, boolean recurseIntoVersionDirectories) throws IOException {
        ArrayList<RepositoryCloneDirectory> result = new ArrayList<RepositoryCloneDirectory>();
        try (Stream<Path> children = Files.list(cloneDirectory);){
            for (Path directory : children.filter(x$0 -> Files.isDirectory(x$0, new LinkOption[0])).filter(GitRepositoryClonesService::isNonAbapSystemDir).toList()) {
                boolean isVersionDirectory = VERSION_DIRECTORY_PATTERN.matcher(directory.getFileName().toString()).matches();
                if (isVersionDirectory && recurseIntoVersionDirectories) {
                    result.addAll(GitRepositoryClonesService.scanCloneDirectories(directory, absoluteCloneDirectoryToProjectIds, false));
                    continue;
                }
                if (isVersionDirectory || !GitRepositoryClonesService.isGitDirectory(directory)) continue;
                String absolutePath = directory.toAbsolutePath().toString();
                result.add(new RepositoryCloneDirectory(absolutePath, new ArrayList<String>(absoluteCloneDirectoryToProjectIds.getOrDefault(absolutePath, Set.of()))));
            }
        }
        return result;
    }

    private static boolean isNonAbapSystemDir(Path path) {
        return !"sap.abap.system".equals(path.getFileName().toString());
    }

    private static boolean isGitDirectory(Path directory) {
        return WELL_KNOWN_BARE_REPO_CONTENTS.stream().map(directory::resolve).allMatch(x$0 -> Files.exists(x$0, new LinkOption[0]));
    }

    private @NonNull Map<String, Set<String>> createAbsoluteCloneDirectoryToProjectIds() throws StorageException {
        HashMap<String, Set<String>> absoluteCloneDirectoryToProjectIds = new HashMap<String, Set<String>>();
        for (ProjectInfo projectInfo : this.openGlobalIndex(ProjectIndex.class).getAllProjectInfos()) {
            ProjectConfiguration projectConfiguration;
            if (projectInfo.isDeleting() || (projectConfiguration = ProjectUtils.retrieveProjectConfig((IProjectId)projectInfo.getInternalId(), (IndexLayer)this.getIndexLayer())) == null) continue;
            for (ConnectorConfiguration connectorConfiguration : projectConfiguration.getConnectors()) {
                try {
                    this.extractLocalCloneDirectoryFromConnector(projectInfo, connectorConfiguration, absoluteCloneDirectoryToProjectIds);
                }
                catch (ProjectConfigurationException | RepositoryException e) {
                    LOGGER.error((Object)e);
                }
            }
        }
        return absoluteCloneDirectoryToProjectIds;
    }

    private void extractLocalCloneDirectoryFromConnector(ProjectInfo projectInfo, ConnectorConfiguration connectorConfiguration, Map<String, Set<String>> absoluteCloneDirectoryToProjectIds) throws StorageException, ProjectConfigurationException, RepositoryException {
        ConfigurationInitializationContext context = new ConfigurationInitializationContext(this.getUser().getUsername(), this.getIndexLayer(), (IExternalCredentialsProvider)this.openGlobalIndex(ExternalCredentialsIndex.class), ConfigurationInitializationContext.EInitializationReason.OTHER);
        ConnectorDescriptorBase loadedConnector = ConnectorUtils.loadConnector((ConnectorConfiguration)connectorConfiguration, (ConfigurationInitializationContext)context, (InternalProjectId)this.serviceInfo.getInternalId());
        if (loadedConnector instanceof GitRepositoryConnectorDescriptor) {
            GitRepositoryConnectorDescriptor gitConnector = (GitRepositoryConnectorDescriptor)loadedConnector;
            String connectorId = gitConnector.getConnectorIdentifier();
            GitRepositoryInfoIndex gitInfoIndex = (GitRepositoryInfoIndex)this.getIndexLayer().openProjectStorageSystem(projectInfo).openProjectIndex(GitRepositoryInfoIndex.class, GitRepositoryInfoIndex.createIndexName((String)connectorId), null);
            GitRepositoryConnector connector = GitRepositoryConnectorUtils.createGitRepositoryConnector(gitConnector, gitInfoIndex, projectInfo.getPrimaryPublicId(), connectorId, this.getIndexLayer());
            try (GitRepositoryConnection connection = GitRepositoryConnectorUtils.createGitRepositoryConnection(connector, this.getIndexLayer());){
                Path localCloneDirectory = connection.getMainRepository().getLocalDirectory();
                absoluteCloneDirectoryToProjectIds.computeIfAbsent(localCloneDirectory.toAbsolutePath().toString(), x -> new HashSet()).add(projectInfo.getPrimaryPublicId().toString());
            }
        }
    }

    public record RepositoryCloneDirectory(String absolutePath, List<String> referencingProjects) {
    }
}

