/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.repository;

import com.teamscale.core.accounts.ExternalCredentialsIndex;
import com.teamscale.core.accounts.IExternalCredentialsProvider;
import com.teamscale.core.analysis.configuration.ConnectorUtils;
import com.teamscale.core.analysis.configuration.ProjectConfigurationException;
import com.teamscale.core.analysis.configuration.index.model.ConnectorConfiguration;
import com.teamscale.core.analysis.configuration.index.model.ProjectConfiguration;
import com.teamscale.core.analysis.configuration.model.ConfigurationInitializationContext;
import com.teamscale.core.analysis.configuration.model.connectors.ConnectorDescriptorBase;
import com.teamscale.core.index.IndexLayer;
import com.teamscale.core.permissions.roles.EProjectPermission;
import com.teamscale.core.utils.ProjectUtils;
import com.teamscale.index.repository.RevisionResolverFactory;
import com.teamscale.index.repository.git.GitRepositoryConnectorDescriptor;
import com.teamscale.index.repository.git.GitRevisionResolver;
import com.teamscale.service.base.ApiBase;
import com.teamscale.service.framework.authorization.RequiresProjectPermission;
import com.teamscale.service.repository.GitTag;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.NotFoundException;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.QueryParam;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Pattern;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.index.shared.IProjectId;
import org.conqat.engine.index.shared.InternalProjectId;
import org.conqat.engine.index.shared.PublicProjectId;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.string.StringUtils;
import org.eclipse.jgit.transport.RefSpec;
import org.jspecify.annotations.Nullable;

@Path(value="api/projects/{project}/git-tags")
public class GitTagService
extends ApiBase {
    @GET
    @RequiresProjectPermission(value={EProjectPermission.VIEW})
    @Operation(summary="Get all git tags", description="Collects all git tags from all git connections in the given project.", tags={"Connectors"})
    @ApiResponse(responseCode="404", description="If no project with the given ID was found.")
    public List<GitTag> getAllGitTags(@PathParam(value="project") PublicProjectId projectId, @Parameter(description="Only return tags from the given repository") @QueryParam(value="repository") @DefaultValue(value="") String repositoryIdentifier) throws StorageException, ProjectConfigurationException {
        ProjectConfiguration projectConfiguration = this.getProjectConfig(projectId);
        if (repositoryIdentifier.isEmpty()) {
            return this.getGitTagsForProject(projectConfiguration);
        }
        return this.getGitTagsForRepository(repositoryIdentifier, projectConfiguration);
    }

    @GET
    @RequiresProjectPermission(value={EProjectPermission.VIEW})
    @Operation(summary="Gets a git tag by its ref name", description="Returns the git tag with the given ref name or null if it could not be found.", tags={"Connectors"})
    @ApiResponses(value={@ApiResponse(responseCode="204", description="No git tag with the given name was found."), @ApiResponse(responseCode="404", description="If no project with the given ID was found.")})
    @Path(value="{tagName}")
    public @Nullable GitTag getGitTagByName(@PathParam(value="project") PublicProjectId projectId, @PathParam(value="tagName") String tagName, @Parameter(description="Only return tags from the given repository") @QueryParam(value="repository") @DefaultValue(value="") String repositoryIdentifier) throws StorageException, ProjectConfigurationException {
        if (StringUtils.isEmpty((String)tagName)) {
            return null;
        }
        this.getProjectConfig(projectId);
        return this.getAllGitTags(projectId, repositoryIdentifier).stream().filter(tag -> tagName.equals(tag.refName())).findAny().orElse(null);
    }

    @POST
    @RequiresProjectPermission(value={EProjectPermission.VIEW})
    @Operation(summary="Get the target commit of a git tag", description="Resolves the given git tag to the tagged commit.", tags={"Connectors"})
    @ApiResponses(value={@ApiResponse(responseCode="204", description="Failed to resolve the tag to a commit. This may happen if the commit history was changed since the tags were last fetched."), @ApiResponse(responseCode="404", description="If no project with the given ID was found.")})
    @Path(value="resolve")
    public @Nullable CommitDescriptor resolveTag(@PathParam(value="project") PublicProjectId projectId, @RequestBody(required=true) GitTag tag) throws StorageException, ProjectConfigurationException {
        ProjectConfiguration projectConfiguration = this.getProjectConfig(projectId);
        for (ConnectorConfiguration connector : projectConfiguration.getConnectors()) {
            Optional<GitRepositoryConnectorDescriptor> gitConnectorDescriptor = this.loadGitConnectorDescriptor(projectConfiguration, connector);
            if (gitConnectorDescriptor.isEmpty() || !gitConnectorDescriptor.get().getConnectorIdentifier().equals(tag.connectorIdentifier())) continue;
            return this.resolveCommit(tag, projectConfiguration, gitConnectorDescriptor.get()).orElse(null);
        }
        return null;
    }

    private ProjectConfiguration getProjectConfig(PublicProjectId projectId) throws StorageException {
        ProjectConfiguration projectConfiguration = ProjectUtils.retrieveProjectConfig((IProjectId)projectId, (IndexLayer)this.getIndexLayer());
        if (projectConfiguration == null) {
            throw new NotFoundException("Project with id '" + String.valueOf(projectId) + "' was not found.");
        }
        return projectConfiguration;
    }

    private List<GitTag> getGitTagsForProject(ProjectConfiguration projectConfiguration) throws ProjectConfigurationException, StorageException {
        ArrayList<GitTag> allTags = new ArrayList<GitTag>();
        for (ConnectorConfiguration connector : projectConfiguration.getConnectors()) {
            Optional<GitRepositoryConnectorDescriptor> gitConnectorDescriptor = this.loadGitConnectorDescriptor(projectConfiguration, connector);
            if (gitConnectorDescriptor.isEmpty()) continue;
            allTags.addAll(this.getAllGitTagsForConnector(projectConfiguration, gitConnectorDescriptor.get()));
        }
        return allTags;
    }

    private List<GitTag> getGitTagsForRepository(String repositoryIdentifier, ProjectConfiguration projectConfiguration) throws ProjectConfigurationException, StorageException {
        Optional<GitRepositoryConnectorDescriptor> gitRepositoryConnectorDescriptor = this.loadGitConnectorDescriptor(projectConfiguration, projectConfiguration.getConnectorByIdentifier(repositoryIdentifier));
        if (gitRepositoryConnectorDescriptor.isEmpty()) {
            throw new ProjectConfigurationException("Could not find a matching Git repository connector for the identifier '" + repositoryIdentifier + "'.");
        }
        return this.getAllGitTagsForConnector(projectConfiguration, gitRepositoryConnectorDescriptor.get());
    }

    private Optional<GitRepositoryConnectorDescriptor> loadGitConnectorDescriptor(ProjectConfiguration projectConfiguration, ConnectorConfiguration connector) throws ProjectConfigurationException, StorageException {
        ConnectorDescriptorBase connectorDescriptorBase = ConnectorUtils.loadConnector((ConnectorConfiguration)connector, (ConfigurationInitializationContext)new ConfigurationInitializationContext(this.getIndexLayer(), (IExternalCredentialsProvider)this.openGlobalIndex(ExternalCredentialsIndex.class)), (InternalProjectId)projectConfiguration.getInternalId());
        if (connectorDescriptorBase instanceof GitRepositoryConnectorDescriptor) {
            GitRepositoryConnectorDescriptor gitRepositoryConnectorDescriptor = (GitRepositoryConnectorDescriptor)connectorDescriptorBase;
            return Optional.of(gitRepositoryConnectorDescriptor);
        }
        return Optional.empty();
    }

    private List<GitTag> getAllGitTagsForConnector(ProjectConfiguration projectConfiguration, GitRepositoryConnectorDescriptor connector) throws StorageException {
        Optional revisionResolver = RevisionResolverFactory.getGitBasedRevisionResolver((GitRepositoryConnectorDescriptor)connector, (InternalProjectId)projectConfiguration.getInternalId(), (IndexLayer)this.serviceInfo.getIndexLayer());
        if (revisionResolver.isEmpty()) {
            return Collections.emptyList();
        }
        return this.getAllUserRequestedRefsForConnector(projectConfiguration, connector);
    }

    private List<GitTag> getAllUserRequestedRefsForConnector(ProjectConfiguration projectConfiguration, GitRepositoryConnectorDescriptor connector) throws StorageException {
        Optional revisionResolver = RevisionResolverFactory.getGitBasedRevisionResolver((GitRepositoryConnectorDescriptor)connector, (InternalProjectId)projectConfiguration.getInternalId(), (IndexLayer)this.serviceInfo.getIndexLayer());
        if (revisionResolver.isEmpty()) {
            return Collections.emptyList();
        }
        return ((GitRevisionResolver)revisionResolver.get()).getRefsByPrefix(GitTagService.getRequestedRefMappings(connector), false).stream().map(refNamePair -> new GitTag((String)refNamePair.getFirst(), (String)refNamePair.getSecond(), projectConfiguration.getName(), projectConfiguration.getPrimaryPublicId(), connector.getConnectorIdentifier())).toList();
    }

    private static Map<String, Pattern> getRequestedRefMappings(GitRepositoryConnectorDescriptor connector) {
        HashMap<String, Pattern> requestedRefs = new HashMap<String, Pattern>();
        requestedRefs.put("refs/tags/", Pattern.compile("refs/tags/(.*)"));
        for (Map.Entry entry : connector.getAdditionalRefSpecMappings().entrySet()) {
            requestedRefs.put(GitTagService.getDestinationPrefixFromRefSpec((String)entry.getKey()), (Pattern)entry.getValue());
        }
        return requestedRefs;
    }

    private static String getDestinationPrefixFromRefSpec(String refSpec) {
        return StringUtils.stripSuffix((String)new RefSpec(refSpec).getDestination(), (String)"*");
    }

    private Optional<CommitDescriptor> resolveCommit(GitTag tag, ProjectConfiguration projectConfiguration, GitRepositoryConnectorDescriptor connector) throws StorageException {
        Optional revisionResolver = RevisionResolverFactory.getGitBasedRevisionResolver((GitRepositoryConnectorDescriptor)connector, (InternalProjectId)projectConfiguration.getInternalId(), (IndexLayer)this.serviceInfo.getIndexLayer());
        if (revisionResolver.isEmpty()) {
            return Optional.empty();
        }
        return ((GitRevisionResolver)revisionResolver.get()).resolveTagToCommitDescriptor(tag.refName());
    }
}

