/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.repository;

import com.teamscale.core.analysis.configuration.ConnectorUtils;
import com.teamscale.core.analysis.configuration.ProjectConfigurationException;
import com.teamscale.core.analysis.configuration.index.model.ConnectorConfiguration;
import com.teamscale.core.analysis.configuration.index.model.ProjectConfiguration;
import com.teamscale.core.analysis.configuration.index.model.ProjectConfigurationUtils;
import com.teamscale.core.analysis.configuration.model.ConfigurationInitializationContext;
import com.teamscale.core.analysis.configuration.model.connectors.ConnectorDescriptorBase;
import com.teamscale.core.index.CommitDescriptorIndex;
import com.teamscale.index.external.update.ExternalResultsPartitionLastUpdateIndex;
import com.teamscale.index.repository.RepositoryRevisionIndex;
import com.teamscale.index.repository.base.RepositoryConnectorDescriptorBase;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.index.shared.InternalProjectId;
import org.conqat.engine.persistence.index.schema.ProjectStorageSystem;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.hist.HistoryAccessOption;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.Pair;
import org.conqat.lib.commons.collections.PairList;

public class RequiredPartitionsChecker {
    private final ProjectConfiguration projectConfiguration;
    private final ConfigurationInitializationContext initializationContext;
    private final RepositoryRevisionIndex repositoryRevisionIndex;
    private final CommitDescriptorIndex commitDescriptorIndex;
    private final ProjectStorageSystem projectStorageSystem;

    public RequiredPartitionsChecker(ConfigurationInitializationContext initializationContext, ProjectStorageSystem projectStorageSystem) throws StorageException {
        this.projectStorageSystem = projectStorageSystem;
        this.projectConfiguration = ProjectConfigurationUtils.getProjectConfiguration((ProjectStorageSystem)projectStorageSystem);
        this.initializationContext = initializationContext;
        this.repositoryRevisionIndex = (RepositoryRevisionIndex)projectStorageSystem.openProjectIndex(RepositoryRevisionIndex.class, null);
        this.commitDescriptorIndex = (CommitDescriptorIndex)projectStorageSystem.openProjectIndex(CommitDescriptorIndex.class, null);
    }

    public List<MissingPartitionInfo> checkMissingPartitionUploads(CommitDescriptor commit) throws StorageException, ProjectConfigurationException {
        Map<String, CommitDescriptor> latestCommitsByConnector = this.getLatestCommitPerConnector(commit);
        ArrayList<MissingPartitionInfo> missingUploads = new ArrayList<MissingPartitionInfo>();
        for (ConnectorConfiguration connector : ConnectorUtils.getSourceCodeRepositoryConnectors((ProjectConfiguration)this.projectConfiguration, (ConfigurationInitializationContext)this.initializationContext)) {
            ConnectorDescriptorBase descriptor = ConnectorUtils.loadConnector((ConnectorConfiguration)connector, (ConfigurationInitializationContext)this.initializationContext, (InternalProjectId)this.projectConfiguration.getInternalId());
            if (!(descriptor instanceof RepositoryConnectorDescriptorBase)) continue;
            RepositoryConnectorDescriptorBase repositoryDescriptor = (RepositoryConnectorDescriptorBase)descriptor;
            MissingPartitionInfo missingInfo = this.checkExternalUploads(repositoryDescriptor, latestCommitsByConnector);
            missingUploads.add(missingInfo);
        }
        return missingUploads;
    }

    private MissingPartitionInfo checkExternalUploads(RepositoryConnectorDescriptorBase repositoryDescriptor, Map<String, CommitDescriptor> latestCommitsByConnector) throws StorageException {
        CommitDescriptor latestCommit = latestCommitsByConnector.get(repositoryDescriptor.getConnectorIdentifier());
        if (latestCommit == null) {
            return new MissingPartitionInfo(repositoryDescriptor.getConnectorIdentifier(), null, Collections.emptySet());
        }
        List requiredPartitions = repositoryDescriptor.getPartitionsRequiredForSecurityView();
        Set<String> uploadedPartitions = this.getPartitionsWithProcessedUploads(latestCommit, requiredPartitions);
        Set missingUploadedPartitions = CollectionUtils.subtract((Collection)requiredPartitions, uploadedPartitions);
        return new MissingPartitionInfo(repositoryDescriptor.getConnectorIdentifier(), latestCommit, missingUploadedPartitions);
    }

    private Set<String> getPartitionsWithProcessedUploads(CommitDescriptor commit, List<String> requiredPartitions) throws StorageException {
        List<CommitDescriptor> lastUpdateCommitsForRequiredPartitions = this.getLastUpdateCommitsForRequiredPartitions(commit, requiredPartitions);
        if (lastUpdateCommitsForRequiredPartitions.isEmpty()) {
            return Collections.emptySet();
        }
        HashSet<String> partitionsWithProcessedUploads = new HashSet<String>();
        for (int i = 0; i < requiredPartitions.size(); ++i) {
            CommitDescriptor commitDescriptor = lastUpdateCommitsForRequiredPartitions.get(i);
            if (commitDescriptor == null || commitDescriptor.getTimestamp() < commit.getTimestamp()) continue;
            partitionsWithProcessedUploads.add(requiredPartitions.get(i));
        }
        return partitionsWithProcessedUploads;
    }

    private long getNextCodeCommitTimestamp(CommitDescriptor commit) throws StorageException {
        List allCommitsOnBranchBetweenInclusive = this.commitDescriptorIndex.getAllCommitsOnBranchBetweenInclusive(new CommitDescriptor(commit.getBranchName(), commit.getTimestamp() + 1L), new CommitDescriptor(commit.getBranchName(), Long.MAX_VALUE));
        return allCommitsOnBranchBetweenInclusive.stream().map(CommitDescriptor::getTimestamp).min(Long::compareTo).orElse(Long.MAX_VALUE);
    }

    private List<CommitDescriptor> getLastUpdateCommitsForRequiredPartitions(CommitDescriptor commit, List<String> requiredPartitions) throws StorageException {
        long nextCommitTimestamp = this.getNextCodeCommitTimestamp(commit);
        HistoryAccessOption historyAccessOption = HistoryAccessOption.readCommit((CommitDescriptor)new CommitDescriptor(commit.getBranchName(), nextCommitTimestamp));
        ExternalResultsPartitionLastUpdateIndex lastUpdateIndex = (ExternalResultsPartitionLastUpdateIndex)this.projectStorageSystem.openProjectIndex(ExternalResultsPartitionLastUpdateIndex.class, historyAccessOption);
        return lastUpdateIndex.getLastUpdatedCommits(requiredPartitions);
    }

    private Map<String, CommitDescriptor> getLatestCommitPerConnector(CommitDescriptor commit) throws StorageException {
        PairList repositoryCommitMappings = this.repositoryRevisionIndex.getAllKnownRepositoryRevisions();
        HashMap<String, CommitDescriptor> latestCommitsByConnector = new HashMap<String, CommitDescriptor>();
        for (Pair repositoryCommitMapping : repositoryCommitMappings) {
            String repositoryIdentifier = ((RepositoryRevisionIndex.RevisionAndRepository)repositoryCommitMapping.getSecond()).repositoryIdentifier();
            CommitDescriptor currentCommit = (CommitDescriptor)repositoryCommitMapping.getFirst();
            if (!currentCommit.getBranchName().equals(commit.getBranchName()) || currentCommit.getTimestamp() > commit.getTimestamp()) continue;
            latestCommitsByConnector.computeIfPresent(repositoryIdentifier, (ignored, latestCommit) -> currentCommit.getTimestamp() > latestCommit.getTimestamp() ? currentCommit : latestCommit);
            latestCommitsByConnector.computeIfAbsent(repositoryIdentifier, ignored -> currentCommit);
        }
        return latestCommitsByConnector;
    }

    public record MissingPartitionInfo(String connectorIdentifier, CommitDescriptor latestCommit, Set<String> missingPartitions) {
    }
}

