/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.requirements_tracing;

import com.teamscale.core.permissions.roles.EProjectPermission;
import com.teamscale.index.query.StoredQueryDescriptor;
import com.teamscale.index.query.StoredQueryIndex;
import com.teamscale.service.framework.authorization.RequiresProjectPermission;
import com.teamscale.service.query.StoredQueriesServiceBase;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import java.util.List;
import org.conqat.engine.persistence.store.StorageException;

@Path(value="api/projects/{project}/spec-items/queries")
public class SpecItemQueriesService
extends StoredQueriesServiceBase {
    public SpecItemQueriesService() {
        super(StoredQueryIndex.EStoredQueryType.SPEC_ITEM);
    }

    @GET
    @Operation(summary="Get spec item queries", description="Retrieves the list of available spec item query descriptors.", tags={"Specification Items", "Stored Queries"})
    @RequiresProjectPermission(value={EProjectPermission.VIEW})
    public List<StoredQueryDescriptor> getSpecItemQueries() throws StorageException {
        return this.getAllQueries();
    }

    @POST
    @Operation(summary="Save spec item query", description="Creates an spec item query descriptor in the system.", tags={"Specification Items", "Stored Queries"})
    @RequiresProjectPermission(value={EProjectPermission.EDIT_SPEC_ITEM_QUERIES})
    public void saveSpecItemQueryDescriptor(@RequestBody(required=true) StoredQueryDescriptor specItemQueryDescriptor) throws StorageException {
        this.storeQuery(specItemQueryDescriptor);
    }

    @DELETE
    @Path(value="{specItemQueryName}")
    @Operation(summary="Delete spec item query", description="Deletes a spec item query descriptor from the system.", tags={"Specification Items", "Stored Queries"}, responses={@ApiResponse(responseCode="404", description="Spec item query with given name could not be found.")})
    @RequiresProjectPermission(value={EProjectPermission.EDIT_SPEC_ITEM_QUERIES})
    public void deleteSpecItemQueryDescriptor(@Parameter(description="Name of the spec item query to delete") @PathParam(value="specItemQueryName") String specItemQueryName) throws StorageException {
        this.deleteQuery(specItemQueryName);
    }
}

