/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.resource;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.teamscale.core.permissions.roles.EProjectPermission;
import com.teamscale.index.resource.TokenElementIndex;
import com.teamscale.index.resource.TokenElementInfo;
import com.teamscale.service.base.ApiBase;
import com.teamscale.service.framework.authorization.RequiresProjectPermission;
import com.teamscale.service.framework.cache.Cache;
import com.teamscale.service.framework.cache.etag.AnalysisStateContributor;
import com.teamscale.service.framework.cache.etag.RequestContributor;
import com.teamscale.service.framework.parameter.ResolveToCodePath;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.IShallowEntityVisitor;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.NotFoundException;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.QueryParam;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Stack;
import org.conqat.engine.index.shared.UnresolvedCommitDescriptor;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.hist.HistoryAccessOption;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.string.StringUtils;
import org.conqat.lib.commons.uniformpath.UniformPath;

@Path(value="api/projects/{project}/code-outline")
public class CodeOutlineService
extends ApiBase {
    private static final EnumSet<EShallowEntityType> RENDERED_ENTITY_TYPES = EnumSet.of(EShallowEntityType.ATTRIBUTE, EShallowEntityType.METHOD, EShallowEntityType.TYPE);

    @GET
    @Path(value="{uniformPath}")
    @RequiresProjectPermission(value={EProjectPermission.VIEW})
    @Operation(summary="Get code outline", description="Returns a code outline for a file, which summarizes the abstract syntax tree of the code", tags={"Source Code", "Project"}, responses={@ApiResponse(responseCode="404", description="If no corresponding file exists")})
    @Cache(maxAge=1, eTagContributors={AnalysisStateContributor.class, RequestContributor.class})
    public List<OutlineElement> getCodeOutline(@PathParam(value="uniformPath") @ResolveToCodePath UniformPath uniformPath, @QueryParam(value="t") @Parameter(description="This parameter can be used to pass a timestamp giving the time (in milliseconds since 1970) for which the data should be provided. This can optionally be prefixed by the name of the branch, followed by a colon.") UnresolvedCommitDescriptor commit) throws StorageException {
        HistoryAccessOption historyAccessOption = this.determineHistoryOption(commit);
        TokenElementIndex tokenElementIndex = this.openProjectIndex(TokenElementIndex.class, "content", historyAccessOption);
        TokenElementInfo tokenElement = tokenElementIndex.getTokenElementByPath(uniformPath);
        if (tokenElement == null) {
            throw new NotFoundException("File " + String.valueOf(uniformPath) + " does not exist");
        }
        return CodeOutlineService.createOutline((List<ShallowEntity>)tokenElement.getShallowEntitiesWithoutPreprocessorTokens());
    }

    private static List<OutlineElement> createOutline(List<ShallowEntity> shallowEntities) {
        if (CollectionUtils.isNullOrEmpty(shallowEntities)) {
            return Collections.emptyList();
        }
        OutlineElementCreator creator = new OutlineElementCreator();
        ShallowEntity.traverse(shallowEntities, (IShallowEntityVisitor)creator);
        return creator.getElements();
    }

    static class OutlineElementCreator
    implements IShallowEntityVisitor {
        private final Stack<List<OutlineElement>> children = new Stack();

        public OutlineElementCreator() {
            this.children.push(new ArrayList());
        }

        public boolean visit(ShallowEntity entity) {
            if (OutlineElementCreator.shouldCreateOutlineElement(entity)) {
                this.children.push(new ArrayList());
            }
            return true;
        }

        public void endVisit(ShallowEntity entity) {
            if (OutlineElementCreator.shouldCreateOutlineElement(entity)) {
                OutlineElement element = new OutlineElement(entity.getStartLine(), entity.getName(), entity.getType().name(), this.children.pop());
                this.children.peek().add(element);
            }
        }

        private static boolean shouldCreateOutlineElement(ShallowEntity entity) {
            if (StringUtils.isEmpty((String)entity.getName())) {
                return false;
            }
            return RENDERED_ENTITY_TYPES.contains(entity.getType());
        }

        public List<OutlineElement> getElements() {
            CCSMAssert.isFalse((boolean)this.children.isEmpty(), (String)"Algorithmic error: stack must never be empty at this point. The list we pushed in the constructor should never have been popped off.");
            return this.children.peek();
        }
    }

    static class OutlineElement {
        @JsonProperty(value="children")
        private final List<OutlineElement> children;
        @JsonProperty(value="lineNumber")
        private final int lineNumber;
        @JsonProperty(value="name")
        private final String name;
        @JsonProperty(value="type")
        private final String type;

        public OutlineElement(int lineNumber, String name, String type, List<OutlineElement> children) {
            this.lineNumber = lineNumber;
            this.name = name;
            this.type = type;
            this.children = children;
        }

        public String toString() {
            return OutlineElement.outlineElementToString(this, 0);
        }

        private static String outlineElementToString(OutlineElement element, int indentation) {
            StringBuilder builder = new StringBuilder();
            builder.append(StringUtils.fillString((int)indentation, (char)' ')).append(element.type).append(" ").append(element.name).append(" on line ").append(element.lineNumber).append("\n");
            for (OutlineElement child : element.children) {
                builder.append(OutlineElement.outlineElementToString(child, indentation + 2));
            }
            return builder.toString();
        }
    }
}

