/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.resource;

import com.teamscale.core.permissions.roles.EProjectPermission;
import com.teamscale.index.resource.EExtendedResourceType;
import com.teamscale.index.resource.ExtendedResourceTypeIndex;
import com.teamscale.index.resource.ResourceServiceUtils;
import com.teamscale.index.resource.metrics.architecture.MetricsToArchitectureMetricsMappingIndex;
import com.teamscale.service.base.ApiBase;
import com.teamscale.service.framework.authorization.RequiresProjectPermission;
import io.swagger.v3.oas.annotations.Operation;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.QueryParam;
import java.util.EnumSet;
import java.util.Optional;
import org.conqat.engine.index.shared.UnresolvedCommitDescriptor;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.hist.HistoryAccessOption;
import org.conqat.lib.commons.uniformpath.UniformPath;

@Path(value="api/projects/{project}/ext-resource-type")
public class ExtendedResourceTypeService
extends ApiBase {
    @GET
    @Path(value="{uniformPath: .*}")
    @Operation(summary="Get extended resource types", description="Returns the extended resource types for an element.", tags={"Source Code"})
    @RequiresProjectPermission(value={EProjectPermission.VIEW})
    public EnumSet<EExtendedResourceType> getExtendedResourceTypes(@PathParam(value="uniformPath") UniformPath uniformPath, @QueryParam(value="t") UnresolvedCommitDescriptor commit) throws StorageException {
        HistoryAccessOption historyAccessOption = this.determineHistoryOption(commit);
        ExtendedResourceTypeIndex extendedTypeIndex = this.openProjectIndex(ExtendedResourceTypeIndex.class, historyAccessOption);
        Optional resolvedPath = ResourceServiceUtils.resolveUniqueArchitectureElementPath((String)uniformPath.toString(), (MetricsToArchitectureMetricsMappingIndex)this.openProjectIndex(MetricsToArchitectureMetricsMappingIndex.class, historyAccessOption));
        if (resolvedPath.isPresent()) {
            return extendedTypeIndex.getResourceTypes((String)resolvedPath.get());
        }
        return EnumSet.noneOf(EExtendedResourceType.class);
    }
}

