/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.resource;

import com.teamscale.core.migration.ETeamscaleVersion;
import com.teamscale.core.permissions.roles.EProjectPermission;
import com.teamscale.service.framework.authorization.RequiresProjectPermission;
import com.teamscale.service.framework.versioning.PublicApi;
import com.teamscale.service.resource.SourceCodeDownloadService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.NotFoundException;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Response;
import org.conqat.engine.index.shared.UnresolvedCommitDescriptor;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.uniformpath.UniformPath;

public interface ISourceCodeDownloadServiceApi {
    @GET
    @Produces(value={"text/plain", "application/json", "application/octet-stream"})
    @Operation(summary="Download source code", description="Starts a download of the source code file at the given uniform path.", responses={@ApiResponse(responseCode="400", description="The file cannot be anonymized as it is a binary file."), @ApiResponse(responseCode="404", description="No file is available at the given uniform path."), @ApiResponse(responseCode="406", description="The file cannot be provided in the requested media type.")}, tags={"Source Code"})
    @PublicApi(since=ETeamscaleVersion.VERSION_5_2_0)
    @RequiresProjectPermission(value={EProjectPermission.VIEW})
    public Response getCode(@Parameter(description="The uniform path of the source code file to be downloaded.", required=true) @PathParam(value="uniformPath") UniformPath var1, @Parameter(description="The commit for which the source code should be downloaded.") @QueryParam(value="t") UnresolvedCommitDescriptor var2, @Parameter(description="Whether to allow missing files by not logging the error. The eclipse plugin does not know whether files are excluded from Teamscale or not, so we disable the logging of these errors in that case.") @QueryParam(value="expectFileUnknown") boolean var3, @Parameter(description="The requested representation for the file to be downloaded.") @QueryParam(value="representation") @DefaultValue(value="TEXT") SourceCodeDownloadService.ECodeRepresentation var4) throws NotFoundException, StorageException;
}

