/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.resource;

import com.teamscale.index.resource.TokenElementInfo;
import com.teamscale.service.resource.ISourceCodeDownloadServiceApi;
import com.teamscale.service.resource.SourceCodeDownloadServiceBase;
import com.teamscale.service.resource.debug.TokenElementDebugService;
import jakarta.ws.rs.BadRequestException;
import jakarta.ws.rs.NotFoundException;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.core.Response;
import java.util.Optional;
import org.conqat.engine.index.shared.UnresolvedCommitDescriptor;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.js_export.ExportToTypeScript;
import org.conqat.lib.commons.uniformpath.UniformPath;

@Path(value="api/projects/{project}/source-code-download/{uniformPath: .*}")
public class SourceCodeDownloadService
extends SourceCodeDownloadServiceBase
implements ISourceCodeDownloadServiceApi {
    private static final String WARNING_TEXT = "WARNING:\nThis anonymized code needs to be manually checked.\nOur anonymization function can't know about language specifics or special function names that are important for the program syntax.\nThe anonymization just replaces every token that Teamscale classifies as identifier, comment, or literal token.\nPoints to check manually:\n* Are any non-anonymized parts left?\n* Does the anonymized code still represent the original code (does it still look compilable?; if you are reporting a bug: does it still trigger the bug)?\nBegin of anonymized code:\n";
    private ECodeRepresentation representation;

    @Override
    public Response getCode(UniformPath uniformPath, UnresolvedCommitDescriptor commit, boolean expectFileUnknown, ECodeRepresentation representation) throws NotFoundException, StorageException {
        this.representation = representation;
        Optional<Response> responseOptional = this.doGetCode(uniformPath, this.determineHistoryOption(commit));
        if (!expectFileUnknown && responseOptional.isEmpty()) {
            throw new NotFoundException("No code found for uniform path: " + String.valueOf(uniformPath));
        }
        return responseOptional.orElse(null);
    }

    @Override
    protected String processTokenElement(TokenElementInfo tokenElement) throws BadRequestException {
        if (this.representation == ECodeRepresentation.TEXT) {
            return tokenElement.getText();
        }
        if (this.representation == ECodeRepresentation.ANONYMIZED) {
            return WARNING_TEXT + TokenElementDebugService.buildRepresentation(tokenElement, TokenElementDebugService.ERepresentation.ANONYMIZED);
        }
        if (this.representation == ECodeRepresentation.PREPROCESSED) {
            return TokenElementDebugService.buildRepresentation(tokenElement, TokenElementDebugService.ERepresentation.PREPROCESSED);
        }
        if (this.representation == ECodeRepresentation.PREPROCESSED_ANONYMIZED) {
            return WARNING_TEXT + TokenElementDebugService.buildRepresentation(tokenElement, TokenElementDebugService.ERepresentation.PREPROCESSED_ANONYMIZED);
        }
        throw new BadRequestException("Unknown representation for file download.");
    }

    @Override
    protected byte[] processBinaryElement(byte[] binaryResult) throws BadRequestException {
        if (this.representation == ECodeRepresentation.ANONYMIZED) {
            throw new BadRequestException("Binary source files cannot be anonymized");
        }
        return binaryResult;
    }

    @ExportToTypeScript
    public static enum ECodeRepresentation {
        TEXT,
        ANONYMIZED,
        PREPROCESSED,
        PREPROCESSED_ANONYMIZED;

    }
}

