/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.resource;

import com.teamscale.core.permissions.roles.EProjectPermission;
import com.teamscale.index.resource.metrics.architecture.ArchitectureMetricsUtils;
import com.teamscale.index.testgap.MethodLastTestedIndex;
import com.teamscale.service.base.ApiBase;
import com.teamscale.service.framework.authorization.RequiresProjectPermission;
import com.teamscale.service.resource.TestCoveragePartitionInfo;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.QueryParam;
import java.util.HashMap;
import java.util.List;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.index.shared.UnresolvedCommitDescriptor;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.hist.HistoryAccessOption;
import org.conqat.lib.commons.compare.ComparableUtils;
import org.conqat.lib.commons.uniformpath.UniformPath;

@Path(value="api/projects/{project}/test-gap-partitions/{uniformPath: .*}")
public class TestGapPartitionService
extends ApiBase {
    @GET
    @Operation(summary="Test Gap Partitions", description="Returns the test gap partitions for an element. This will include partitions that only received coverage through TGA coverage merges as well.", tags={"Test Coverage"})
    @RequiresProjectPermission(value={EProjectPermission.VIEW})
    public List<TestCoveragePartitionInfo> getTestGapPartitionsForPath(@PathParam(value="uniformPath") UniformPath uniformPath, @QueryParam(value="t") @Parameter(description="This parameter can be used to pass a timestamp giving the time (in milliseconds since 1970) for which the data should be provided. This can optionally be prefixed by the name of the branch, followed by a colon.") UnresolvedCommitDescriptor commit) throws StorageException {
        String uniformPathString = ArchitectureMetricsUtils.removeArchitecturePathPrefix((String)uniformPath.toString());
        HistoryAccessOption historyAccessOption = this.determineHistoryOption(commit);
        MethodLastTestedIndex methodLastTestedIndex = this.openProjectIndex(MethodLastTestedIndex.class, historyAccessOption);
        List partitions = methodLastTestedIndex.getPartitions();
        HashMap partitionToLastUpdate = new HashMap();
        methodLastTestedIndex.getTestInfosForPartitionsAndExactPath(partitions, uniformPathString).forEach(testInfo -> partitionToLastUpdate.merge(testInfo.getPartition(), testInfo.getCommit(), (x$0, x$1) -> (CommitDescriptor)ComparableUtils.max((Comparable)x$0, (Comparable)x$1, (Comparable[])new CommitDescriptor[0])));
        return partitionToLastUpdate.entrySet().stream().map(entry -> new TestCoveragePartitionInfo((String)entry.getKey(), ((CommitDescriptor)entry.getValue()).getTimestamp())).toList();
    }
}

