/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.resource.debug;

import com.teamscale.core.permissions.roles.EProjectPermission;
import com.teamscale.core.precommit.PreCommitUtils;
import com.teamscale.index.resource.TokenElementIndex;
import com.teamscale.index.resource.TokenElementInfo;
import com.teamscale.service.base.ApiBase;
import com.teamscale.service.framework.authorization.RequiresProjectPermission;
import com.teamscale.service.resource.debug.IdentifierAnonymizer;
import eu.cqse.check.framework.preprocessor.c.CPreprocessor;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.NotFoundException;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.QueryParam;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import org.conqat.engine.index.shared.UnresolvedCommitDescriptor;
import org.conqat.engine.persistence.index.schema.ProjectStorageSystem;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.hist.HistoryAccessOption;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.js_export.ExportToTypeScript;
import org.conqat.lib.commons.string.StringUtils;
import org.conqat.lib.commons.uniformpath.UniformPath;
import org.jspecify.annotations.Nullable;

@Path(value="api/projects/{project}/tokens/debug/content/{uniformPath}")
public class TokenElementDebugService
extends ApiBase {
    private static final Pattern ANONYMIZATION_PATTERN = Pattern.compile("[\\p{L}\\d ]+");

    @GET
    @RequiresProjectPermission(value={EProjectPermission.VIEW})
    @Operation(summary="Get token element internals", description="Returns a string representation of a token element, supporting various representations.", tags={"Debugging"})
    public String getDebugContent(@PathParam(value="uniformPath") UniformPath uniformPath, @Parameter(description="This parameter can be used to pass a timestamp giving the time (in milliseconds since 1970) for which the data should be provided. This can optionally be prefixed by the name of the branch, followed by a colon.") @QueryParam(value="t") UnresolvedCommitDescriptor commit, @QueryParam(value="representation") @DefaultValue(value="TEXT") ERepresentation representation, @QueryParam(value="pre-commit-id") @Nullable String preCommitId) throws StorageException {
        TokenElementIndex index;
        TokenElementInfo tokenElement;
        if (preCommitId != null) {
            commit = new UnresolvedCommitDescriptor(PreCommitUtils.createPrecommitBranchNameForCommitId((String)this.getUser().getUsername(), (String)preCommitId), Long.MAX_VALUE);
        }
        if ((tokenElement = (index = TokenElementIndex.open((ProjectStorageSystem)this.getProjectStorageSystem(), (HistoryAccessOption)this.determineHistoryOption(commit))).getTokenElementByPath(uniformPath)) == null) {
            throw new NotFoundException("No element of name " + String.valueOf(uniformPath) + " found!");
        }
        return TokenElementDebugService.buildRepresentation(tokenElement, representation);
    }

    public static String buildRepresentation(TokenElementInfo tokenElement, ERepresentation representation) {
        return switch (representation.ordinal()) {
            case 0 -> tokenElement.getText();
            case 1 -> StringUtils.concat((Iterable)tokenElement.getTokens(), (String)"\n");
            case 2 -> StringUtils.concat((Iterable)tokenElement.getShallowEntitiesWithoutPreprocessorTokens(), (String)"");
            case 3 -> StringUtils.concat((Iterable)tokenElement.getRawShallowEntities(), (String)"");
            case 4 -> TokenElementDebugService.prettyPrint((List<IToken>)tokenElement.getRawTokens(), (List<IToken>)tokenElement.getRawTokens(), new TokenAnonymizer());
            case 5 -> TokenElementDebugService.prettyPrint(tokenElement.getPreprocessedTokens(), (List<IToken>)tokenElement.getTokens(), IToken::getText);
            case 6 -> TokenElementDebugService.prettyPrint(tokenElement.getPreprocessedTokens(), (List<IToken>)tokenElement.getTokens(), new TokenAnonymizer());
            default -> throw new IllegalArgumentException("Unknown representation: " + String.valueOf((Object)representation));
        };
    }

    private static String prettyPrint(List<IToken> tokens, List<IToken> originalTokens, Function<IToken, String> tokenTextModifier) {
        Predicate<IToken> isNoMacro = Predicate.not(CPreprocessor.IS_MACRO_TOKEN);
        StringBuilder prettyPrintedText = new StringBuilder();
        int currentLine = 0;
        for (int tokenIndex = 0; tokenIndex < tokens.size(); ++tokenIndex) {
            int distanceToPrevious = TokenElementDebugService.calculateDistanceToPreviousToken(tokens, tokenIndex, originalTokens);
            IToken token = tokens.get(tokenIndex);
            if (isNoMacro.test(token)) {
                while (token.getLineNumber() > currentLine) {
                    prettyPrintedText.append("\n");
                    ++currentLine;
                }
            }
            prettyPrintedText.append(" ".repeat(Math.max(0, distanceToPrevious)));
            String newTokenText = tokenTextModifier.apply(token);
            prettyPrintedText.append(newTokenText);
            if (!isNoMacro.test(token)) continue;
            currentLine += StringUtils.countCharacter((String)newTokenText, (char)'\n');
        }
        return prettyPrintedText.toString();
    }

    private static int calculateDistanceToPreviousToken(List<IToken> tokens, int tokenIndex, List<IToken> originalTokens) {
        int distanceToPrevious;
        if (tokenIndex == 0) {
            return 0;
        }
        Predicate<IToken> isNoMacro = Predicate.not(CPreprocessor.IS_MACRO_TOKEN);
        IToken token = tokens.get(tokenIndex);
        int originalIndex = CollectionUtils.indexOfFirstMatch(originalTokens, token1 -> TokenElementDebugService.tokensAreEqual(token1, token));
        if (originalIndex > 0 && !TokenElementDebugService.tokensAreEqual(originalTokens.get(originalIndex - 1), tokens.get(tokenIndex - 1))) {
            IToken previousToken = originalTokens.get(originalIndex - 1);
            int charsInBetween = token.getOffset() - (previousToken.getEndOffset() + 1);
            int linebreaksInBetween = token.getLineNumber() - previousToken.getLineNumber();
            distanceToPrevious = charsInBetween - linebreaksInBetween;
        } else if (isNoMacro.test(token) && isNoMacro.test(tokens.get(tokenIndex - 1))) {
            IToken previousToken = tokens.get(tokenIndex - 1);
            int charsInBetween = token.getOffset() - (previousToken.getEndOffset() + 1);
            int linebreaksInBetween = token.getLineNumber() - previousToken.getLineNumber();
            distanceToPrevious = charsInBetween - linebreaksInBetween;
        } else {
            distanceToPrevious = 1;
        }
        return distanceToPrevious;
    }

    private static String applyAnonymizationPattern(IToken token, String replacement) {
        return ANONYMIZATION_PATTERN.matcher(token.getText()).replaceAll(replacement);
    }

    private static boolean tokensAreEqual(IToken token1, IToken token2) {
        return token1.getOffset() == token2.getOffset() && token1.getOriginId().equals(token2.getOriginId());
    }

    @ExportToTypeScript
    public static enum ERepresentation {
        TEXT,
        TOKEN,
        AST,
        RAW_AST,
        ANONYMIZED,
        PREPROCESSED,
        PREPROCESSED_ANONYMIZED;

    }

    private static class TokenAnonymizer
    implements Function<IToken, String> {
        private final IdentifierAnonymizer anonymizer = new IdentifierAnonymizer();

        private TokenAnonymizer() {
        }

        @Override
        public String apply(IToken token) {
            if (token.getType().getTokenClass() == ETokenType.ETokenClass.IDENTIFIER) {
                return this.anonymizer.anonymize(token.getText());
            }
            return switch (token.getType()) {
                case ETokenType.IDENTIFIER -> this.anonymizer.anonymize(token.getText());
                case ETokenType.STRING_LITERAL -> TokenElementDebugService.applyAnonymizationPattern(token, "literal");
                case ETokenType.COMMENT -> TokenElementDebugService.applyAnonymizationPattern(token, "comment");
                case ETokenType.JSX -> TokenElementDebugService.applyAnonymizationPattern(token, "jsx");
                case ETokenType.TEMPLATE_LITERAL -> TokenElementDebugService.applyAnonymizationPattern(token, "template");
                case ETokenType.UNTERMINATED_TEMPLATE_LITERAL -> TokenElementDebugService.applyAnonymizationPattern(token, "unterminated_template");
                default -> token.getText();
            };
        }
    }
}

