/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.search.result;

import com.teamscale.index.repository.IRepositoryLogEntry;
import com.teamscale.index.repository.RepositoryLogEntryAggregate;
import com.teamscale.index.repository.RepositoryLogIndex;
import com.teamscale.index.search.CodeSearchSynchronizer;
import com.teamscale.index.search.SearchSource;
import com.teamscale.index.search.SearchToken;
import com.teamscale.service.commits.ExtendedRepositoryLogEntry;
import com.teamscale.service.commits.LogEntryResolver;
import com.teamscale.service.search.SearchQuery;
import com.teamscale.service.search.result.CommitResultInfo;
import com.teamscale.service.search.result.SearchHitBase;
import com.teamscale.service.search.result.SearchResult;
import java.util.List;
import java.util.function.BiPredicate;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.index.shared.IProjectId;
import org.conqat.engine.index.shared.PublicProjectId;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.date.DateTimeUtils;

public class CommitSearchHit
extends SearchHitBase {
    private final LogEntryResolver logEntryResolver;
    private final RepositoryLogIndex logIndex;
    private final BiPredicate<IProjectId, IRepositoryLogEntry> logFilter;

    public CommitSearchHit(SearchSource source, List<SearchToken> tokens, PublicProjectId project, SearchQuery.SearchHitLookupIndices searchHitLookupIndices) {
        super(source, tokens, project);
        this.logEntryResolver = searchHitLookupIndices.logEntryResolver();
        this.logIndex = searchHitLookupIndices.logIndex();
        this.logFilter = searchHitLookupIndices.privacyFilter();
    }

    @Override
    public SearchResult createSearchResult() throws StorageException {
        CommitDescriptor commit = (CommitDescriptor)CodeSearchSynchronizer.COMMIT_DESCRIPTOR_SERIALIZER.deserialize((Object)this.source.getSourceName());
        RepositoryLogEntryAggregate logEntry = (RepositoryLogEntryAggregate)this.logIndex.getEntry(commit);
        if (logEntry == null) {
            return null;
        }
        if (!this.logFilter.test((IProjectId)this.project, (IRepositoryLogEntry)logEntry)) {
            return null;
        }
        String url = commit.toString();
        SearchResult searchResult = new SearchResult("Commit at " + DateTimeUtils.getUiFormattedDateString((long)commit.getTimestamp()) + " (" + commit.getBranchName() + ")", url, this.project, null);
        List<ExtendedRepositoryLogEntry> extendedRepositoryLogEntryList = this.logEntryResolver.resolveExtendedRepositoryLogEntry(List.of(logEntry.toAggregateLogEntryWithPrimaryConnector()), null);
        searchResult.addInfo(new CommitResultInfo(extendedRepositoryLogEntryList.getFirst()));
        return searchResult;
    }
}

