/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.search.result;

import com.teamscale.index.issues.IssueIndexBase;
import com.teamscale.index.search.SearchSource;
import com.teamscale.index.search.SearchToken;
import com.teamscale.service.search.result.IssueResultInfo;
import com.teamscale.service.search.result.IssueSearchResult;
import com.teamscale.service.search.result.SearchHitBase;
import com.teamscale.service.search.result.SearchResult;
import com.teamscale.wia.TeamscaleIssue;
import java.util.List;
import org.conqat.engine.index.shared.PublicProjectId;
import org.conqat.engine.persistence.store.StorageException;

public class IssueSearchHit<T extends TeamscaleIssue>
extends SearchHitBase {
    private final IssueIndexBase<T> issueIndex;

    public IssueSearchHit(SearchSource source, List<SearchToken> tokens, PublicProjectId project, IssueIndexBase<T> issueIndex) {
        super(source, tokens, project);
        this.issueIndex = issueIndex;
    }

    @Override
    public SearchResult createSearchResult() throws StorageException {
        String id = this.source.getSourceName();
        TeamscaleIssue issue = this.issueIndex.getIssueForInternalId(id);
        if (issue == null) {
            return null;
        }
        String subject = issue.getSubject();
        IssueSearchResult searchResult = new IssueSearchResult(issue.getHumanReadableType() + ": " + id, id, this.project, subject.length());
        searchResult.addInfo(new IssueResultInfo(issue));
        return searchResult;
    }
}

