/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.search.result;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.teamscale.service.search.result.SearchHitLocation;
import com.teamscale.service.search.result.SearchResult;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.conqat.engine.index.shared.PublicProjectId;

public class IssueSearchResult
extends SearchResult {
    @JsonProperty(value="subjectHits")
    private final List<SearchHitLocation> subjectHits = new ArrayList<SearchHitLocation>();
    @JsonProperty(value="descriptionHits")
    private final List<SearchHitLocation> descriptionHits = new ArrayList<SearchHitLocation>();
    @JsonProperty(value="subjectLength")
    private final int subjectLength;

    public IssueSearchResult(String title, String url, PublicProjectId project, int subjectLength) {
        super(title, url, project, null);
        this.subjectLength = subjectLength;
    }

    @Override
    public void addHit(SearchHitLocation hit) {
        if (hit.getOffset() > this.subjectLength) {
            this.descriptionHits.add(new SearchHitLocation(hit.getOffset() - this.subjectLength - 1, hit.getLength()));
        } else {
            this.subjectHits.add(hit);
        }
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof IssueSearchResult)) {
            return false;
        }
        IssueSearchResult that = (IssueSearchResult)obj;
        if (!super.equals(obj)) {
            return false;
        }
        return this.subjectLength == that.subjectLength;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.subjectLength);
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof IssueSearchResult;
    }
}

