/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.system;

import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.teamscale.core.index.IndexLayer;
import com.teamscale.core.permissions.roles.EGlobalPermission;
import com.teamscale.core.runtime.impl.analysis.JobDescriptor;
import com.teamscale.core.runtime.impl.progress.AnalysisProgressIndexBase;
import com.teamscale.core.runtime.impl.progress.ProjectAnalysisProgressIndex;
import com.teamscale.core.runtime.impl.scheduling.ScheduledJob;
import com.teamscale.core.runtime.impl.worker.WorkerClusterStatus;
import com.teamscale.core.runtime.impl.worker.WorkerIndex;
import com.teamscale.core.runtime.impl.worker.WorkerThread;
import com.teamscale.index.repository.RepositoryLogEntryAggregate;
import com.teamscale.index.repository.RepositoryLogIndex;
import com.teamscale.service.base.ApiBase;
import com.teamscale.service.framework.ITeamscaleServiceInfo;
import com.teamscale.service.framework.authorization.RequiresGlobalPermission;
import com.teamscale.service.framework.logging.ICriticalEventLogger;
import com.teamscale.service.system.CancelTriggerRequestBody;
import com.teamscale.service.system.WorkerGroupStatus;
import com.teamscale.service.system.WorkerStatus;
import io.swagger.v3.oas.annotations.Operation;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.core.Context;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.commons.util.JsonUtils;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.index.shared.IProjectId;
import org.conqat.engine.index.shared.InternalProjectId;
import org.conqat.engine.index.shared.ProjectInfo;
import org.conqat.engine.index.shared.PublicProjectId;
import org.conqat.engine.persistence.index.collections.DurableSet;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.string.StringUtils;
import org.jspecify.annotations.Nullable;

@Path(value="api/execution-status")
public class ExecutionStatusService
extends ApiBase {
    private static final Logger LOGGER = LogManager.getLogger();
    @Context
    private ICriticalEventLogger criticalEventLogger;

    @GET
    @Operation(summary="Get worker status", description="Retrieves the worker status info.", tags={"System"})
    @Path(value="workers")
    @RequiresGlobalPermission(value={EGlobalPermission.VIEW_SYSTEM_STATUS})
    public List<WorkerGroupStatus> getWorkerStatus() throws StorageException {
        WorkerIndex workerIndex = this.openGlobalIndex(WorkerIndex.class);
        ArrayList<WorkerGroupStatus> result = new ArrayList<WorkerGroupStatus>();
        for (WorkerClusterStatus clusterStatus : workerIndex.getWorkerClusterStatusAccess().listAll()) {
            result.add(new WorkerGroupStatus(clusterStatus));
        }
        for (WorkerGroupStatus workerGroupStatus : result) {
            for (WorkerStatus worker : workerGroupStatus.getWorkers()) {
                this.appendRevisionInfo(worker);
            }
        }
        result.sort(Comparator.comparing(WorkerGroupStatus::getProcessId));
        return result;
    }

    @PUT
    @Operation(summary="Cancel the provided trigger", description="Cancels the provided trigger. There are two steps of canceling a trigger. The first is via a flag, the trigger has to look up and may cancel gracefully. The second is via interrupt, where the trigger may be canceled at any operation, which may lead to inconsistent data.", tags={"System"})
    @Path(value="workers/{workerId}/cancel")
    @RequiresGlobalPermission(value={EGlobalPermission.ACCESS_ADMINISTRATIVE_SERVICES})
    public void cancelTrigger(@PathParam(value="workerId") String workerId, CancelTriggerRequestBody body) {
        this.writeCancelTriggerEvent(body);
        this.serviceInfo.getMessageBroker().sendMessage(workerId, JsonUtils.serializeToJSON((Object)new WorkerThread.Messages.CancelTriggerMessage(body.project(), body.taskName(), body.commit(), body.interrupt())));
    }

    private void writeCancelTriggerEvent(CancelTriggerRequestBody body) {
        String action = body.interrupt() ? "Abort" : "Cancel";
        String message = "%s trigger %s for project %s and commit %s".formatted(action, body.taskName(), body.project(), body.commit());
        this.criticalEventLogger.logCriticalEventMessage((IProjectId)body.project(), message);
    }

    @GET
    @Path(value="queue")
    @Operation(summary="Get job queue", description="Retrieves the entire job queue from all projects.", tags={"System"})
    @RequiresGlobalPermission(value={EGlobalPermission.VIEW_SYSTEM_STATUS})
    public List<JobDescriptorDto> extractJobQueue() throws StorageException {
        List visibleProjects = this.getPermissions().getVisibleProjects();
        return ExecutionStatusService.extractJobQueue(this.serviceInfo, visibleProjects);
    }

    public static List<JobDescriptorDto> extractJobQueue(ITeamscaleServiceInfo serviceInfo, List<ProjectInfo> projects) throws StorageException {
        ArrayList<JobDescriptorDto> jobQueue = new ArrayList<JobDescriptorDto>();
        for (ProjectInfo project : projects) {
            if (project == null || project.isDeletingOrReanalyzing()) continue;
            Function<InternalProjectId, PublicProjectId> projectIdLookup = projectId -> {
                if (!Objects.equals(project.getInternalId(), projectId)) {
                    throw new IllegalStateException("Expected job for project %s bug got %s".formatted(project.getInternalId(), projectId));
                }
                return project.getPrimaryPublicId();
            };
            try {
                AnalysisProgressIndexBase progressIndex = AnalysisProgressIndexBase.open((IndexLayer)serviceInfo.getIndexLayer(), (IProjectId)project.getInternalId());
                DurableSet jobs = progressIndex.createJobQueueSet();
                for (ScheduledJob job : jobs) {
                    jobQueue.add(JobDescriptorDto.of(job, projectIdLookup));
                }
            }
            catch (StorageException e) {
                LOGGER.error((Object)e);
            }
        }
        return jobQueue;
    }

    @GET
    @Path(value="queue-size")
    @Operation(summary="Get job queue size", description="Retrieves size of the entire job queue from all projects.", tags={"System"})
    @RequiresGlobalPermission(value={EGlobalPermission.VIEW_SYSTEM_STATUS})
    public JobQueueCountWithDelayedJobs getJobQueueSize() throws StorageException {
        List visibleProjects = this.getPermissions().getVisibleProjects();
        return ExecutionStatusService.getJobQueueSize(this.serviceInfo.getIndexLayer(), visibleProjects);
    }

    public static JobQueueCountWithDelayedJobs getJobQueueSize(IndexLayer indexLayer, List<ProjectInfo> projects) {
        long now = System.currentTimeMillis();
        JobQueueCountWithDelayedJobs jobQueueSizes = JobQueueCountWithDelayedJobs.ZERO;
        for (ProjectInfo project : projects) {
            jobQueueSizes = jobQueueSizes.merge(ExecutionStatusService.getJobQueueSize(indexLayer, project, now));
        }
        return jobQueueSizes;
    }

    private static JobQueueCountWithDelayedJobs getJobQueueSize(IndexLayer indexLayer, ProjectInfo project, long now) {
        if (project == null || project.isDeletingOrReanalyzing()) {
            return JobQueueCountWithDelayedJobs.ZERO;
        }
        try {
            ProjectAnalysisProgressIndex projectProgressIndex = (ProjectAnalysisProgressIndex)indexLayer.openNonHistorizedProjectIndex(ProjectAnalysisProgressIndex.class, project);
            DurableSet jobQueue = projectProgressIndex.createJobQueueSet();
            return new JobQueueCountWithDelayedJobs(jobQueue.size(), (int)jobQueue.stream().filter(job -> job.getEarliestScheduleTimestamp() > now).count());
        }
        catch (StorageException e) {
            LOGGER.error((Object)e);
            return JobQueueCountWithDelayedJobs.ZERO;
        }
    }

    private void appendRevisionInfo(WorkerStatus worker) throws StorageException {
        if (worker.getCommit() != null) {
            CCSMAssert.isNotNull((Object)worker.getProjectId(), (String)("No project ID set for worker with commit: " + String.valueOf(worker.getCommit())));
            IndexLayer indexLayer = this.getIndexLayer();
            Optional internalProjectId = indexLayer.openProjectIndex().tryResolveToInternalId((IProjectId)worker.getProjectId());
            if (internalProjectId.isEmpty()) {
                return;
            }
            RepositoryLogIndex logIndex = (RepositoryLogIndex)indexLayer.openProjectIndex((IProjectId)internalProjectId.get(), RepositoryLogIndex.class, null);
            RepositoryLogEntryAggregate logEntry = (RepositoryLogEntryAggregate)logIndex.getEntry(worker.getCommit());
            if (logEntry != null) {
                worker.appendRevisionData(logEntry.toAggregateLogEntryWithPrimaryConnector());
            }
        }
    }

    public record JobDescriptorDto(PublicProjectId publicProjectId, String triggerName, @Nullable CommitDescriptor schedulingCommit, @Nullable String parameter, long earliestExecutionTimestamp) {
        static JobDescriptorDto of(ScheduledJob scheduledJob, Function<InternalProjectId, PublicProjectId> projectIdLookup) {
            JobDescriptor job = scheduledJob.getJob();
            return new JobDescriptorDto(projectIdLookup.apply(job.getInternalProjectId()), job.getTriggerName(), job.getSchedulingCommitDescriptor(), job.getParameter(), scheduledJob.getEarliestScheduleTimestamp());
        }

        @JsonGetter(value="simpleName")
        public String getSimpleName() {
            return StringUtils.getLastPart((String)this.triggerName, (String)".");
        }
    }

    public record JobQueueCountWithDelayedJobs(@JsonProperty(value="numberOfAllJobs") int numberOfAllJobs, @JsonProperty(value="numberOfDelayedJobs") int numberOfDelayedJobs) {
        private static final JobQueueCountWithDelayedJobs ZERO = new JobQueueCountWithDelayedJobs(0, 0);

        private JobQueueCountWithDelayedJobs merge(JobQueueCountWithDelayedJobs other) {
            return new JobQueueCountWithDelayedJobs(this.numberOfAllJobs + other.numberOfAllJobs, this.numberOfDelayedJobs + other.numberOfDelayedJobs);
        }
    }
}

