/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.system;

import com.teamscale.core.runtime.api.scheduling.SchedulingConstants;
import com.teamscale.core.runtime.impl.progress.ProjectAnalysisProgressIndex;
import com.teamscale.index.repository.RepositoryLogIndex;
import com.teamscale.service.framework.authorization.EComplexPermission;
import com.teamscale.service.framework.authorization.RequiresComplexPermission;
import com.teamscale.service.framework.versioning.CloudApi;
import com.teamscale.service.system.AnalysisProgressDescriptor;
import com.teamscale.service.system.AnalysisProgressServiceBase;
import io.swagger.v3.oas.annotations.Operation;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.index.shared.IProjectId;
import org.conqat.engine.index.shared.ProjectInfo;
import org.conqat.engine.persistence.store.StorageException;

@Path(value="api/analysis-progress")
public class GlobalAnalysisProgressService
extends AnalysisProgressServiceBase {
    private static final Logger LOGGER = LogManager.getLogger();

    @GET
    @RequiresComplexPermission(value=EComplexPermission.MAY_RETRIEVE_GLOBAL_ANALYSIS_PROGRESS)
    @Operation(summary="Get global analysis progress", description="Retrieves the global analysis progress (for all projects).", tags={"System"})
    @CloudApi
    public Map<String, List<AnalysisProgressDescriptor>> getGlobalAnalysisProgress() throws StorageException {
        HashMap<String, List<AnalysisProgressDescriptor>> result = new HashMap<String, List<AnalysisProgressDescriptor>>();
        for (ProjectInfo project : this.getPermissions().getVisibleProjects()) {
            if (SchedulingConstants.isMaintenance((IProjectId)project.getInternalId())) continue;
            try {
                ProjectAnalysisProgressIndex progressIndex = (ProjectAnalysisProgressIndex)this.getIndexLayer().openNonHistorizedProjectIndex(ProjectAnalysisProgressIndex.class, project);
                RepositoryLogIndex logIndex = (RepositoryLogIndex)this.getIndexLayer().openNonHistorizedProjectIndex(RepositoryLogIndex.class, project);
                result.put(project.getPrimaryPublicId().toString(), GlobalAnalysisProgressService.createProgressDescriptors(progressIndex, logIndex));
            }
            catch (StorageException e) {
                LOGGER.error("Error obtaining information for project " + String.valueOf(project) + ": " + e.getMessage(), (Throwable)e);
            }
        }
        return result;
    }
}

