/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.system;

import com.teamscale.core.index.IndexLayer;
import com.teamscale.core.index.ProjectIndex;
import com.teamscale.core.permissions.PermissionCache;
import com.teamscale.core.permissions.PermissionIndex;
import com.teamscale.core.permissions.ServicePermissions;
import com.teamscale.core.permissions.UserPermissionsProvider;
import com.teamscale.core.user.User;
import com.teamscale.core.user.UserGroupIndex;
import com.teamscale.index.repository.RepositoryUpdateUtils;
import com.teamscale.service.base.ApiBase;
import com.teamscale.service.framework.authentication.RequiresNoLogin;
import com.teamscale.service.framework.util.LegacyApiUtils;
import com.teamscale.service.framework.versioning.LegacyApi;
import io.swagger.v3.oas.annotations.Hidden;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import jakarta.ws.rs.ForbiddenException;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.InternalServerErrorException;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Response;
import java.util.Set;
import org.conqat.engine.index.shared.IProjectId;
import org.conqat.engine.persistence.cache.SynchronizedCacheAccess;
import org.conqat.engine.persistence.store.StorageException;

@Hidden
@LegacyApi
@Path(value="post-commit-hook")
public class LegacyCommitHookService
extends ApiBase {
    private static final String USERNAME_PARAMETER = "user";
    private static final String ACCESS_KEY_PARAMETER = "access-token";
    public static final String SERVICE_NAME = "post-commit-hook";
    private static final String REPOSITORY_PARAMETER = "repository";
    private static final String REPOSITORY_PARAM_DESCRIPTION = "The URL of the repository affected or a prefix of the URL. To determine triggers that should be scheduled, this URL must be a prefix of the repository URLs used by the triggers. So being too detailed here might stop the hook from working.";
    private static final String USERNAME_PARAM_DESCRIPTION = "The name of the user used for authentication.";
    private static final String ACCESS_KEY_PARAM_DESCRIPTION = "The access key of the user used for authentication.";

    @POST
    @Operation(summary="Trigger commit hook", description="Allows to trigger periodic jobs via a commit hook.")
    @RequiresNoLogin
    public Response triggerCommitHookPost(@Parameter(description="The URL of the repository affected or a prefix of the URL. To determine triggers that should be scheduled, this URL must be a prefix of the repository URLs used by the triggers. So being too detailed here might stop the hook from working.") @QueryParam(value="repository") String repository, @Parameter(description="The name of the user used for authentication.") @QueryParam(value="user") String username, @Parameter(description="The access key of the user used for authentication.") @QueryParam(value="access-token") String accessKey) throws StorageException {
        RepositoryUpdateUtils.extractAndScheduleAffectedTriggers((String)repository, (IndexLayer)this.getIndexLayer(), projects -> this.checkPermissions(username, accessKey, (Set<? extends IProjectId>)projects));
        return LegacyApiUtils.plainTextSuccess();
    }

    @GET
    @Operation(summary="Trigger commit hook", description="Allows to trigger periodic jobs via a commit hook.")
    @RequiresNoLogin
    public Response triggerCommitHookGet(@Parameter(description="The URL of the repository affected or a prefix of the URL. To determine triggers that should be scheduled, this URL must be a prefix of the repository URLs used by the triggers. So being too detailed here might stop the hook from working.") @QueryParam(value="repository") String repository, @Parameter(description="The name of the user used for authentication.") @QueryParam(value="user") String username, @Parameter(description="The access key of the user used for authentication.") @QueryParam(value="access-token") String accessKey) throws StorageException {
        RepositoryUpdateUtils.extractAndScheduleAffectedTriggers((String)repository, (IndexLayer)this.getIndexLayer(), projects -> this.checkPermissions(username, accessKey, (Set<? extends IProjectId>)projects));
        return LegacyApiUtils.plainTextSuccess();
    }

    private void checkPermissions(String username, String accessKey, Set<? extends IProjectId> externallyTriggeredProjects) {
        try {
            ServicePermissions permissions = this.getServicePermissions(username, accessKey);
            for (IProjectId iProjectId : externallyTriggeredProjects) {
                permissions.checkCommitHook(iProjectId);
            }
        }
        catch (ForbiddenException | StorageException e) {
            throw new InternalServerErrorException(e.getMessage(), e);
        }
    }

    private ServicePermissions getServicePermissions(String username, String unencryptedAccessKey) throws StorageException {
        User user = this.serviceInfo.getAuthenticationRequestHandler().authenticateViaEncryptedAccessToken(username, unencryptedAccessKey);
        if (user == null) {
            throw new ForbiddenException("Invalid user or mismatch in access key!");
        }
        SynchronizedCacheAccess permissionCacheAccess = this.serviceInfo.getIndexLayer().getStorageCacheProvider().getCacheProvider("__global__").getCacheAccess(PermissionCache.class);
        PermissionIndex permissionIndex = this.openGlobalIndex(PermissionIndex.class);
        UserGroupIndex groupIndex = this.openGlobalIndex(UserGroupIndex.class);
        ProjectIndex projectIndex = this.openGlobalIndex(ProjectIndex.class);
        UserPermissionsProvider userPermissionsProvider = new UserPermissionsProvider(groupIndex, permissionIndex, permissionCacheAccess);
        return new ServicePermissions(userPermissionsProvider.getUserPermissions(user), null, projectIndex, permissionIndex);
    }
}

