/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.tasks;

import com.teamscale.core.permissions.roles.EProjectPermission;
import com.teamscale.index.task.ETaskStatus;
import com.teamscale.index.task.Task;
import com.teamscale.index.task.TaskIndex;
import com.teamscale.service.base.ApiBase;
import com.teamscale.service.framework.authorization.RequiresProjectPermission;
import com.teamscale.service.tasks.TaskServiceFilterUtils;
import com.teamscale.service.tasks.TaskServiceQueryOptions;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import jakarta.ws.rs.BadRequestException;
import jakarta.ws.rs.BeanParam;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.QueryParam;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.conqat.engine.index.shared.UnresolvedCommitDescriptor;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.hist.HistoryAccessOption;
import org.conqat.lib.commons.collections.CounterSet;

@Path(value="api/projects/{project}/tasks/summary")
public class TaskSummaryService
extends ApiBase {
    @GET
    @RequiresProjectPermission(value={EProjectPermission.VIEW})
    @Operation(summary="Get task summary", description="Retrieves the counts of tasks in each possible task state.", tags={"Tasks"}, responses={@ApiResponse(responseCode="400", description="Provided timestamp must be greater than the baseline timestamp.")})
    public Map<ETaskStatus, Integer> getTaskSummary(@Parameter(description="This parameter can be used to pass a timestamp giving the time (in milliseconds since 1970) for which the data should be provided. This can optionally be prefixed by the name of the branch, followed by a colon.") @QueryParam(value="t") UnresolvedCommitDescriptor commit, @DefaultValue(value="1") @Parameter(description="The baseline from which tasks that don't have a task status of open are counted.") @QueryParam(value="baseline") UnresolvedCommitDescriptor baseline, @BeanParam TaskServiceQueryOptions taskQueryParameters) throws StorageException {
        HistoryAccessOption historyOption = this.determineHistoryOption(commit);
        long timestamp = historyOption.getTimestamp();
        if (historyOption.isReadHead()) {
            timestamp = Long.MAX_VALUE;
        }
        if (baseline.getTimestamp() > timestamp) {
            throw new BadRequestException("Timestamp must be greater than baseline timestamp.");
        }
        return this.createTaskSummary(baseline.getTimestamp(), timestamp, taskQueryParameters);
    }

    private Map<ETaskStatus, Integer> createTaskSummary(long baselineTimestamp, long maxCreatedTimestamp, TaskServiceQueryOptions taskQueryParameters) throws StorageException {
        TaskIndex taskIndex = this.openProjectIndex(TaskIndex.class, null);
        List tasks = taskIndex.getAllTasks();
        Function<Task, Boolean> filter = task -> task.getStatus() == ETaskStatus.OPEN || TaskSummaryService.wasCreatedBetween(task, baselineTimestamp, maxCreatedTimestamp);
        return TaskSummaryService.toFilteredStatusCountMap(TaskServiceFilterUtils.applyNonStatusFilters(taskQueryParameters, tasks), filter);
    }

    public static Map<ETaskStatus, Integer> toFilteredStatusCountMap(List<Task> tasks, Function<Task, Boolean> filter) {
        CounterSet counterSet = CounterSet.forEnum(ETaskStatus.class);
        counterSet.incAll(List.of(ETaskStatus.values()), 0);
        tasks.stream().filter(filter::apply).map(Task::getStatus).forEach(arg_0 -> ((CounterSet)counterSet).inc(arg_0));
        return counterSet.toMap();
    }

    public static boolean wasCreatedBetween(Task task, long startTimestamp, long endTimestamp) {
        long createdTimestamp = task.getCreated();
        return startTimestamp <= createdTimestamp && createdTimestamp <= endTimestamp;
    }
}

