/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.testgap;

import com.teamscale.index.external.ExternalAnalysisPartitionIndex;
import com.teamscale.service.base.ApiBase;
import com.teamscale.service.framework.authorization.RequiresNoPermission;
import com.teamscale.service.testgap.ProjectPartitionsInfo;
import io.swagger.v3.oas.annotations.Operation;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import java.util.ArrayList;
import java.util.List;
import org.conqat.engine.index.shared.IProjectId;
import org.conqat.engine.index.shared.ProjectInfo;
import org.conqat.engine.persistence.store.StorageException;

@Path(value="api/test-coverage/line-based/partitions")
public class GlobalTgaPartitionsService
extends ApiBase {
    @GET
    @Operation(summary="Get test coverage partitions", description="Returns a the available test coverage partitions. Each object contains a project and it's test partitions.", tags={"Test Coverage"})
    @RequiresNoPermission(description="Only partitions are returned for which the user has view permissions.")
    public List<ProjectPartitionsInfo> getAllGlobalLineBasedPartitions() throws StorageException {
        ArrayList<ProjectPartitionsInfo> projectPartitions = new ArrayList<ProjectPartitionsInfo>();
        List visibleProjects = this.getPermissions().getVisibleProjects();
        if (visibleProjects.isEmpty()) {
            return projectPartitions;
        }
        for (ProjectInfo project : visibleProjects) {
            ExternalAnalysisPartitionIndex partitionIndex = (ExternalAnalysisPartitionIndex)this.getProjectStorageSystem((IProjectId)project.getInternalId()).openProjectIndex(ExternalAnalysisPartitionIndex.class, null);
            projectPartitions.add(new ProjectPartitionsInfo(project.getPrimaryPublicId(), partitionIndex.getCoveragePartitions()));
        }
        return projectPartitions;
    }
}

