/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.testgap;

import com.teamscale.core.migration.ETeamscaleVersion;
import com.teamscale.core.permissions.roles.EProjectPermission;
import com.teamscale.index.resource.TimeIntervalBasedServiceQueryOptions;
import com.teamscale.index.testgap.assessment.AssessedTgaData;
import com.teamscale.index.testgap.assessment.ETgaAssessmentType;
import com.teamscale.index.testgap.assessment.TgaAggregationUtils;
import com.teamscale.index.testgap.query.ITgaCoverageSourceParameter;
import com.teamscale.index.testgap.query.ITgaRequest;
import com.teamscale.index.testgap.query.IssueTgaParameters;
import com.teamscale.index.testgap.query.TgaCoverageSourceFormParameters;
import com.teamscale.index.testgap.query.TgaCoverageSourceQueryParameters;
import com.teamscale.index.testgap.query.TgaRequestAssessmentFormOptions;
import com.teamscale.index.testgap.query.TgaRequestAssessmentOptionsBase;
import com.teamscale.index.testgap.query.TgaRequestAssessmentQueryOptions;
import com.teamscale.index.testgap.query.TgaRequestQueryOptions;
import com.teamscale.service.framework.authorization.RequiresProjectPermission;
import com.teamscale.service.framework.cache.Cache;
import com.teamscale.service.framework.cache.etag.AnalysisStateContributor;
import com.teamscale.service.framework.cache.etag.RequestContributor;
import com.teamscale.service.framework.versioning.PublicApi;
import com.teamscale.service.testgap.CrossAnnotationServiceBase;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import jakarta.ws.rs.BeanParam;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import org.conqat.engine.index.shared.RepositoryException;
import org.conqat.engine.persistence.store.StorageException;

@Path(value="api/projects/{project}/test-gaps/percentage")
public class TgaPercentageService
extends CrossAnnotationServiceBase {
    @GET
    @Cache(maxAge=1, eTagContributors={AnalysisStateContributor.class, RequestContributor.class})
    @Operation(summary="Get test gap percentage", description="Calculates the TGA percentage for the given uniform path or the given issue ID.", tags={"Test Gap Analysis"}, responses={@ApiResponse(responseCode="400", description="Could not find actual commit for given branch at given timestamp."), @ApiResponse(responseCode="400", description="Attempt to use timespan to retrieve execution treemap of a single test run. Baseline timestamp and end timestamp have to be equal."), @ApiResponse(responseCode="404", description="Found no commits to be merged."), @ApiResponse(responseCode="400", description="Could not determine common merge base."), @ApiResponse(responseCode="404", description="Found no issue for the provided id."), @ApiResponse(responseCode="409", description="Found multiple issues for the provided id.")})
    @RequiresProjectPermission(value={EProjectPermission.VIEW})
    @PublicApi(since=ETeamscaleVersion.VERSION_5_9_6)
    public Double getTgaPercentage(@BeanParam IssueTgaParameters issueTgaParameters, @BeanParam TimeIntervalBasedServiceQueryOptions timeIntervalParameters, @BeanParam TgaRequestQueryOptions tgaRequestParameters, @BeanParam TgaCoverageSourceQueryParameters coverageSourceParameters, @BeanParam TgaRequestAssessmentQueryOptions assessmentQueryOptions) throws StorageException, RepositoryException {
        return this.processTgaPercentageRequest(issueTgaParameters, timeIntervalParameters, tgaRequestParameters, (ITgaCoverageSourceParameter)coverageSourceParameters, (TgaRequestAssessmentOptionsBase)assessmentQueryOptions);
    }

    @POST
    @Operation(summary="Get test gap percentage", description="Calculates the TGA percentage for the given uniform path or the given issue ID.", tags={"Test Gap Analysis"}, responses={@ApiResponse(responseCode="400", description="Could not find actual commit for given branch at given timestamp."), @ApiResponse(responseCode="400", description="Attempt to use timespan to retrieve execution treemap of a single test run. Baseline timestamp and end timestamp have to be equal."), @ApiResponse(responseCode="404", description="Found no commits to be merged."), @ApiResponse(responseCode="400", description="Could not determine common merge base."), @ApiResponse(responseCode="404", description="Found no issue for the provided id."), @ApiResponse(responseCode="409", description="Found multiple issues for the provided id.")})
    @RequiresProjectPermission(value={EProjectPermission.VIEW})
    @PublicApi(since=ETeamscaleVersion.VERSION_5_9_6, deprecatedSince=ETeamscaleVersion.VERSION_2024_7_0)
    @Consumes(value={"application/x-www-form-urlencoded"})
    public Double postTgaPercentage(@BeanParam IssueTgaParameters issueTgaParameters, @BeanParam TimeIntervalBasedServiceQueryOptions timeIntervalParameters, @BeanParam TgaRequestQueryOptions tgaRequestParameters, @BeanParam TgaCoverageSourceFormParameters coverageSourceParameters, @BeanParam TgaRequestAssessmentFormOptions filterOptions) throws StorageException, RepositoryException {
        return this.processTgaPercentageRequest(issueTgaParameters, timeIntervalParameters, tgaRequestParameters, (ITgaCoverageSourceParameter)coverageSourceParameters, (TgaRequestAssessmentOptionsBase)filterOptions);
    }

    private Double processTgaPercentageRequest(IssueTgaParameters issueTgaParameters, TimeIntervalBasedServiceQueryOptions timeIntervalParameters, TgaRequestQueryOptions tgaRequestParameters, ITgaCoverageSourceParameter coverageSourceParameters, TgaRequestAssessmentOptionsBase assessmentOptions) throws StorageException, RepositoryException {
        this.checkCrossAnnotationPermissions(coverageSourceParameters);
        ITgaRequest request = this.createTgaRequest(coverageSourceParameters, timeIntervalParameters, tgaRequestParameters, issueTgaParameters, assessmentOptions);
        AssessedTgaData assessedData = request.fetchAndAssessData();
        return TgaAggregationUtils.calculateRatio((ETgaAssessmentType)request.getTgaAssessmentType(), (AssessedTgaData)assessedData);
    }
}

