/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.testgap.badge;

import com.teamscale.service.badge.StaticBadgeUtils;
import com.teamscale.service.framework.badge.BadgeBuilder;
import com.teamscale.service.framework.badge.SegmentStyle;
import org.conqat.lib.commons.assessment.ETrafficLightColor;
import org.conqat.lib.commons.collections.CounterSet;
import org.conqat.lib.commons.string.StringUtils;

public class TgaBadgeCreator {
    private final double ratio;
    private final int testedChurn;
    private final int untestedChange;
    private final int untestedAddition;
    private final String format;
    private final String request;
    private final String incompleteBuildText;

    public TgaBadgeCreator(double ratio, int testedChurn, int untestedChange, int untestedAddition, String format, String request) {
        this.ratio = ratio;
        this.testedChurn = testedChurn;
        this.untestedChange = untestedChange;
        this.untestedAddition = untestedAddition;
        this.format = format;
        this.request = request;
        this.incompleteBuildText = "";
    }

    public TgaBadgeCreator(double ratio, int testedChurn, int untestedChange, int untestedAddition, String format, String request, String incompleteBuildText) {
        this.ratio = ratio;
        this.testedChurn = testedChurn;
        this.untestedChange = untestedChange;
        this.untestedAddition = untestedAddition;
        this.format = format;
        this.request = request;
        this.incompleteBuildText = incompleteBuildText;
    }

    public byte[] createBadge() {
        String tooltip = "-tested changes: " + this.testedChurn + StringUtils.LINE_SEPARATOR + "-untested changes: " + this.untestedChange + StringUtils.LINE_SEPARATOR + "-untested additions: " + this.untestedAddition + StringUtils.LINE_SEPARATOR;
        BadgeBuilder badgeBuilder = new BadgeBuilder();
        if ("assessment".equals(this.format)) {
            StaticBadgeUtils.appendBuildJobsSegment(badgeBuilder, this.incompleteBuildText);
            int testGaps = this.untestedAddition + this.untestedChange;
            String title = testGaps + " Test Gap";
            if (testGaps != 1) {
                title = title + "s";
            }
            title = title + " (" + StringUtils.formatAsPercentage((Number)this.ratio) + ")";
            badgeBuilder.textSegment(title).style(SegmentStyle.TITLE).tooltip(this.request).append();
            this.appendAssessmentSegments(badgeBuilder);
        } else {
            badgeBuilder.textSegment("Test Gap").style(SegmentStyle.TITLE).tooltip(this.request).append();
            badgeBuilder.textSegment(StringUtils.formatAsPercentage((Number)this.ratio)).style(SegmentStyle.GRAY).tooltip(tooltip).append();
        }
        return StringUtils.stringToBytes((String)badgeBuilder.toSvg());
    }

    private void appendAssessmentSegments(BadgeBuilder badgeBuilder) {
        CounterSet colorCounter = new CounterSet();
        colorCounter.inc((Object)ETrafficLightColor.GREEN, this.testedChurn);
        colorCounter.inc((Object)ETrafficLightColor.YELLOW, this.untestedChange);
        colorCounter.inc((Object)ETrafficLightColor.RED, this.untestedAddition);
        if (colorCounter.getTotal() == 0) {
            badgeBuilder.textSegment("No changes relevant for TGA").style(SegmentStyle.BLACK).append();
            return;
        }
        TgaBadgeCreator.appendColoredBadgeSegment(badgeBuilder, ETrafficLightColor.GREEN, "tested changes: ", (CounterSet<ETrafficLightColor>)colorCounter);
        TgaBadgeCreator.appendColoredBadgeSegment(badgeBuilder, ETrafficLightColor.YELLOW, "untested changes: ", (CounterSet<ETrafficLightColor>)colorCounter);
        TgaBadgeCreator.appendColoredBadgeSegment(badgeBuilder, ETrafficLightColor.RED, "untested additions: ", (CounterSet<ETrafficLightColor>)colorCounter);
    }

    private static void appendColoredBadgeSegment(BadgeBuilder badgeBuilder, ETrafficLightColor color, String textPrefix, CounterSet<ETrafficLightColor> colorCounter) {
        int colorCount = colorCounter.getValue((Object)color);
        double airWidth = 100.0 * (double)colorCount / (double)colorCounter.getTotal();
        if (airWidth > 0.0) {
            badgeBuilder.segment().style(SegmentStyle.of((String)color.getHexValue())).air(airWidth).tooltip(textPrefix + colorCount).append();
        }
    }
}

