/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.testgap.badge;

import com.teamscale.core.permissions.roles.EProjectPermission;
import com.teamscale.index.issues.IssueHistoryIndex;
import com.teamscale.index.issues.IssueIndex;
import com.teamscale.index.issues.IssueIndexBase;
import com.teamscale.index.resource.TimeIntervalBasedServiceQueryOptions;
import com.teamscale.index.testgap.ETestGapState;
import com.teamscale.index.testgap.MethodIssueIndex;
import com.teamscale.index.testgap.assessment.AssessedTgaData;
import com.teamscale.index.testgap.assessment.ETgaAssessmentType;
import com.teamscale.index.testgap.assessment.TgaAggregationUtils;
import com.teamscale.index.testgap.query.ITgaCoverageSourceParameter;
import com.teamscale.index.testgap.query.ITgaRequest;
import com.teamscale.index.testgap.query.IssueTgaParameters;
import com.teamscale.index.testgap.query.TgaCoverageSourceQueryParameters;
import com.teamscale.index.testgap.query.TgaRequestAssessmentOptionsBase;
import com.teamscale.index.testgap.query.TgaRequestAssessmentQueryOptions;
import com.teamscale.index.testgap.query.TgaRequestQueryOptions;
import com.teamscale.index.utils.IssueUtils;
import com.teamscale.service.framework.authentication.Badge;
import com.teamscale.service.framework.authorization.RequiresProjectPermission;
import com.teamscale.service.framework.cache.Cache;
import com.teamscale.service.framework.cache.etag.AnalysisStateContributor;
import com.teamscale.service.framework.cache.etag.RequestContributor;
import com.teamscale.service.testgap.CrossAnnotationServiceBase;
import com.teamscale.service.testgap.badge.TgaBadgeCreator;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import jakarta.ws.rs.BeanParam;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.NotFoundException;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import org.conqat.engine.index.shared.RepositoryException;
import org.conqat.engine.persistence.index.keyed.IKeyedObjectIndex;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.CounterSet;

@Path(value="api/projects/{project}/test-gaps/badge")
public class TgaBadgeService
extends CrossAnnotationServiceBase {
    @GET
    @Badge
    @Cache(maxAge=1, eTagContributors={AnalysisStateContributor.class, RequestContributor.class})
    @Operation(summary="Get test gap badge", description="Calculates the test gap badge for the given path or the given issue ID and returns the value as an SVG badge.", tags={"Test Gap Analysis", "Badge"}, responses={@ApiResponse(responseCode="400", description="Could not find actual commit for given branch at given timestamp."), @ApiResponse(responseCode="400", description="Attempt to use timespan to retrieve execution treemap of a single test run. Baseline timestamp and end timestamp have to be equal."), @ApiResponse(responseCode="404", description="Found no commits to be merged."), @ApiResponse(responseCode="404", description="The given issue ID could not be found."), @ApiResponse(responseCode="400", description="Could not determine common merge base."), @ApiResponse(responseCode="409", description="Found multiple issues for the provided id.")})
    @RequiresProjectPermission(value={EProjectPermission.VIEW})
    @Produces(value={"image/svg+xml"})
    public byte[] getTestGapBadge(@Parameter(description="Allows to specify badge format") @QueryParam(value="format") String format, @BeanParam TgaCoverageSourceQueryParameters coverageParameters, @BeanParam IssueTgaParameters issueTgaParameters, @BeanParam TimeIntervalBasedServiceQueryOptions timeIntervalBasedParameters, @BeanParam TgaRequestQueryOptions tgaRequestParameters, @BeanParam TgaRequestAssessmentQueryOptions assessmentOptions) throws StorageException, RepositoryException {
        this.checkCrossAnnotationPermissions((ITgaCoverageSourceParameter)coverageParameters);
        if (this.isUnknownIssue(tgaRequestParameters)) {
            throw new NotFoundException("Unknown issue with ID '" + tgaRequestParameters.getIssueId() + "'.");
        }
        return this.createTgaBadge(format, (ITgaCoverageSourceParameter)coverageParameters, issueTgaParameters, timeIntervalBasedParameters, tgaRequestParameters, (TgaRequestAssessmentOptionsBase)assessmentOptions);
    }

    private boolean isUnknownIssue(TgaRequestQueryOptions tgaRequestParameters) throws StorageException {
        boolean isSingleIssueRequest;
        String issueId = tgaRequestParameters.getIssueId();
        boolean bl = isSingleIssueRequest = issueId != null && !issueId.equals(MethodIssueIndex.NO_ISSUE.getExternalId()) && !issueId.equals(MethodIssueIndex.NO_ISSUE.getInternalId());
        if (isSingleIssueRequest) {
            IssueHistoryIndex issueHistoryIndex = this.openProjectIndex(IssueHistoryIndex.class, null);
            IssueIndex issueIndex = this.openProjectIndex(IssueIndex.class, null);
            return IssueUtils.getSingleIssueHistoryForId((IKeyedObjectIndex)issueHistoryIndex, (IssueIndexBase)issueIndex, (String)issueId, (boolean)true).isEmpty();
        }
        return false;
    }

    private byte[] createTgaBadge(String format, ITgaCoverageSourceParameter coverageSourceParameters, IssueTgaParameters issueTgaParameters, TimeIntervalBasedServiceQueryOptions timeIntervalParameters, TgaRequestQueryOptions tgaRequestParameters, TgaRequestAssessmentOptionsBase assessmentOptions) throws StorageException, RepositoryException {
        ITgaRequest request = this.createTgaRequest(coverageSourceParameters, timeIntervalParameters, tgaRequestParameters, issueTgaParameters, assessmentOptions);
        AssessedTgaData assessedData = request.fetchAndAssessData();
        double tgaRatio = TgaAggregationUtils.calculateRatio((ETgaAssessmentType)request.getTgaAssessmentType(), (AssessedTgaData)assessedData);
        CounterSet tgaStates = TgaAggregationUtils.countStates((AssessedTgaData)assessedData);
        return new TgaBadgeCreator(tgaRatio, tgaStates.getValue((Object)ETestGapState.TESTED_CHURN), tgaStates.getValue((Object)ETestGapState.UNTESTED_CHANGE), tgaStates.getValue((Object)ETestGapState.UNTESTED_ADDITION), format, request.toString()).createBadge();
    }
}

