/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.testgap.upload;

import com.teamscale.core.migration.ETeamscaleVersion;
import com.teamscale.core.permissions.roles.EProjectPermission;
import com.teamscale.core.runtime.api.rollback.RollbackRequest;
import com.teamscale.core.runtime.api.scheduling.ISchedulerCommunicator;
import com.teamscale.core.runtime.impl.analysis.JobDescriptor;
import com.teamscale.core.runtime.impl.rollback.ForceRollbackTrigger;
import com.teamscale.index.testgap.SourceLocation;
import com.teamscale.index.testgap.dotnet.DotNetMethodMappingIndex;
import com.teamscale.index.testgap.dotnet.DotNetVersionIndex;
import com.teamscale.index.testgap.dotnet.MethodMappingUtils;
import com.teamscale.service.framework.authorization.RequiresProjectPermission;
import com.teamscale.service.framework.versioning.PublicApi;
import com.teamscale.service.upload.base.ExternalUploadServiceBase;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.InternalServerErrorException;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.QueryParam;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.index.shared.InternalProjectId;
import org.conqat.engine.index.shared.UnresolvedCommitDescriptor;
import org.conqat.engine.persistence.store.IStore;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.branched.CommitLayeringBranchingLayer;
import org.conqat.engine.persistence.store.hist.HistoryAccessOption;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.filesystem.FileSystemUtils;
import org.conqat.lib.commons.filesystem.TemporaryDirectory;
import org.glassfish.jersey.media.multipart.BodyPart;
import org.glassfish.jersey.media.multipart.FormDataMultiPart;

@Path(value="api/projects/{project}/external-analysis/dotnet-debug-info")
public class DotNetDebugInfoUploadService
extends ExternalUploadServiceBase {
    @POST
    @PublicApi(since=ETeamscaleVersion.VERSION_5_9_0)
    @RequiresProjectPermission(value={EProjectPermission.EXTERNAL_UPLOADS})
    @Operation(summary="Upload debug info", description="Uploads PDB or MDB files for analysis. Processes an upload of method mapping information.", tags={"External Analysis", "Debugging"})
    @Consumes(value={"multipart/form-data"})
    public void uploadDebugInfo(@Parameter(description="The parameter that contains the program version to which the uploaded coverage belongs.", required=true) @QueryParam(value="version") String version, @Parameter(description="This parameter can be used to pass a timestamp giving the time (in milliseconds since 1970) for which the data should be provided. This can optionally be prefixed by the name of the branch, followed by a colon.") @QueryParam(value="t") UnresolvedCommitDescriptor commit, @Parameter(schema=@Schema(name="file", type="string", format="binary")) @RequestBody(required=true) FormDataMultiPart multiPart) throws StorageException {
        CommitDescriptor uploadCommit = this.storeProgramVersion(version, commit);
        ArrayList<CommitDescriptor> rollbackedCommits = new ArrayList<CommitDescriptor>();
        ArrayList<PairList<String, SourceLocation>> rollbackedMappings = new ArrayList<PairList<String, SourceLocation>>();
        this.insertMethodMappings(rollbackedCommits, rollbackedMappings, uploadCommit, false);
        this.collectAndStoreUploadedMappings(multiPart, uploadCommit);
        this.restoreRollbackedMappingsToIndex(rollbackedCommits, rollbackedMappings);
        this.scheduleTriggers(!rollbackedMappings.isEmpty(), uploadCommit);
    }

    @DELETE
    @RequiresProjectPermission(value={EProjectPermission.EXTERNAL_UPLOADS})
    @Operation(summary="Delete debug info", description="Deletes a program version.", tags={"External Analysis", "Debugging"})
    public void removeUploadedDebugInfo(@Parameter(description="The parameter that contains the program version to which the uploaded coverage belongs.", required=true) @QueryParam(value="version") String version) throws StorageException {
        DotNetVersionIndex versionIndex = this.openProjectIndex(DotNetVersionIndex.class, null);
        CommitDescriptor uploadCommit = versionIndex.getVersionCommit(version);
        versionIndex.removeVersion(version);
        ArrayList<CommitDescriptor> rollbackedCommits = new ArrayList<CommitDescriptor>();
        ArrayList<PairList<String, SourceLocation>> rollbackedMappings = new ArrayList<PairList<String, SourceLocation>>();
        this.insertMethodMappings(rollbackedCommits, rollbackedMappings, uploadCommit, true);
        this.restoreRollbackedMappingsToIndex(rollbackedCommits, rollbackedMappings);
        this.scheduleTriggers(!rollbackedMappings.isEmpty(), uploadCommit);
    }

    @Override
    protected IStore openExternalResultRawStore() throws StorageException {
        return this.openStoreInProject("dot-net-method-mappings", DotNetMethodMappingIndex.class);
    }

    private CommitDescriptor storeProgramVersion(String version, UnresolvedCommitDescriptor commit) throws StorageException {
        DotNetVersionIndex versionIndex = this.openProjectIndex(DotNetVersionIndex.class, null);
        CommitDescriptor newCommit = this.resolveCommitWithFallbackTimestamp(commit, System.currentTimeMillis());
        return versionIndex.setCommitForVersionUnlessItExists(version, newCommit);
    }

    private void insertMethodMappings(List<CommitDescriptor> rollbackedCommits, List<PairList<String, SourceLocation>> rollbackedMappings, CommitDescriptor uploadCommit, boolean isDeleteRequest) throws StorageException {
        CommitDescriptor rollbackCommit = uploadCommit.cloneWithDecrementedTimestamp();
        CommitLayeringBranchingLayer branchingLayer = this.openExternalResultBranchingLayer();
        rollbackedCommits.addAll(DotNetDebugInfoUploadService.collectCommitsNewerThanCommit(branchingLayer, rollbackCommit));
        rollbackedMappings.addAll(DotNetDebugInfoUploadService.extractMethodMappings(branchingLayer, rollbackedCommits));
        if (!rollbackedCommits.isEmpty()) {
            branchingLayer.performRollback(Collections.singletonMap(rollbackCommit.getBranchName(), rollbackCommit.getTimestamp()));
        }
        if (DotNetDebugInfoUploadService.firstCommitKeyIsUploadCommit(uploadCommit, rollbackedCommits)) {
            CommitDescriptor commit = rollbackedCommits.remove(0);
            PairList<String, SourceLocation> mapping = rollbackedMappings.remove(0);
            if (!isDeleteRequest) {
                this.openDotNetMethodMappingIndex(commit).setMappings(mapping);
            }
        }
    }

    private DotNetMethodMappingIndex openDotNetMethodMappingIndex(CommitDescriptor uploadCommit) throws StorageException {
        return this.openProjectIndex(DotNetMethodMappingIndex.class, HistoryAccessOption.readHeadWriteTimestamp((String)uploadCommit.getBranchName(), (long)uploadCommit.getTimestamp()));
    }

    private void collectAndStoreUploadedMappings(FormDataMultiPart multiPart, CommitDescriptor uploadCommit) throws StorageException {
        try {
            this.collectMappings(multiPart, uploadCommit);
        }
        catch (IOException e) {
            throw new InternalServerErrorException("Unable to collect mappings of the uploaded symbol files", (Throwable)e);
        }
    }

    private void collectMappings(FormDataMultiPart multiPart, CommitDescriptor commit) throws IOException, StorageException {
        try (TemporaryDirectory tempDirectory = FileSystemUtils.getTemporaryDirectory((String)DotNetDebugInfoUploadService.class.getSimpleName());){
            PairList symbolFiles = new PairList();
            for (BodyPart part : multiPart.getBodyParts()) {
                String filePath = part.getContentDisposition().getFileName();
                String fileName = FileSystemUtils.getLastPathSegment((String)filePath);
                File tempFile = File.createTempFile("symbol_file", "." + FileSystemUtils.getFileExtension((String)fileName), tempDirectory.getPath().toFile());
                try (InputStream in = (InputStream)part.getEntityAs(InputStream.class);
                     FileOutputStream out = new FileOutputStream(tempFile);){
                    FileSystemUtils.copy((InputStream)in, (OutputStream)out);
                }
                symbolFiles.add((Object)fileName, (Object)tempFile);
            }
            MethodMappingUtils.extractAndStoreMethodMappings((PairList)symbolFiles, (DotNetMethodMappingIndex)this.openDotNetMethodMappingIndex(commit));
        }
    }

    private static List<PairList<String, SourceLocation>> extractMethodMappings(CommitLayeringBranchingLayer branchingLayer, List<CommitDescriptor> newerCommits) throws StorageException {
        return CollectionUtils.mapWithException(newerCommits, commit -> {
            IStore branchedView = branchingLayer.openStore(HistoryAccessOption.readTimestamp((String)commit.getBranchName(), (long)commit.getTimestamp()));
            return new DotNetMethodMappingIndex(branchedView).getAllMappings();
        });
    }

    private void restoreRollbackedMappingsToIndex(List<CommitDescriptor> rollbackedCommits, List<PairList<String, SourceLocation>> rollbackedMappings) throws StorageException {
        for (int i = 0; i < rollbackedCommits.size(); ++i) {
            this.openDotNetMethodMappingIndex(rollbackedCommits.get(i)).setMappings(rollbackedMappings.get(i));
        }
    }

    private void scheduleTriggers(boolean needsRollback, CommitDescriptor uploadCommit) throws StorageException {
        if (needsRollback) {
            CommitDescriptor rollbackCommit = uploadCommit.cloneWithDecrementedTimestamp();
            RollbackRequest rollbackRequest = new RollbackRequest(rollbackCommit, "Scheduled due to PDB upload to an older commit.");
            JobDescriptor rollbackJob = JobDescriptor.forRollback((InternalProjectId)this.serviceInfo.getInternalId(), (RollbackRequest)rollbackRequest, ForceRollbackTrigger.class);
            ISchedulerCommunicator.getInstance().scheduleExternalJob(this.getIndexLayer(), rollbackJob);
        }
    }
}

