/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.testimpact.legacy;

import com.teamscale.core.migration.ETeamscaleVersion;
import com.teamscale.core.permissions.roles.EProjectPermission;
import com.teamscale.index.testimpact.TestLinks;
import com.teamscale.index.testimpact.TestLinksIndex;
import com.teamscale.service.base.ApiBase;
import com.teamscale.service.framework.authorization.RequiresProjectPermission;
import com.teamscale.service.framework.cache.Cache;
import com.teamscale.service.framework.cache.etag.AnalysisStateContributor;
import com.teamscale.service.framework.cache.etag.RequestContributor;
import com.teamscale.service.framework.logging.UncriticalStatusCode;
import com.teamscale.service.framework.versioning.PublicApi;
import com.teamscale.service.testimpact.ImpactedTestsService;
import com.teamscale.service.testimpact.legacy.ClusteredTestDetailsPre80;
import com.teamscale.service.testimpact.legacy.LegacyTiaRequestOptionsPre80;
import com.teamscale.service.testimpact.legacy.PrioritizableTestClusterPre80;
import com.teamscale.service.testimpact.prioritization.PrioritizableTest;
import com.teamscale.service.testimpact.prioritization.PrioritizableTestCluster;
import com.teamscale.service.testimpact.prioritization.legacy.PrioritizableTestPre80;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import jakarta.ws.rs.BeanParam;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.container.ResourceContext;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.Response;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.hist.HistoryAccessOption;
import org.conqat.engine.sourcecode.coverage.TestWithClusterId;
import org.conqat.lib.commons.collections.CollectionUtils;

@Path(value="api/projects/{project}/impacted-tests")
public class LegacyImpactedTestsService
extends ApiBase {
    @Context
    private ResourceContext resourceContext;

    @PublicApi(since=ETeamscaleVersion.VERSION_5_7_0, deprecatedSince=ETeamscaleVersion.VERSION_8_0_0)
    @UncriticalStatusCode(value=Response.Status.PRECONDITION_FAILED)
    @Operation(summary="Get impacted tests", description="Returns an ordered list of test clusters that are impacted by the given changes. The returned flat list of tests is a subset of all tests known to Teamscale. When the tests themselves have changed, new tests were added or tests have been deleted, this service cannot take that into account. Please use the PUT endpoint instead to provide a list of available tests. In particular, this endpoint may return tests that no longer exist. Callers must handle this case.", tags={"Test Intelligence"}, responses={@ApiResponse(responseCode="412", description="The given commit has not been processed yet."), @ApiResponse(responseCode="400", description="One of the given options is invalid.")})
    @Cache(maxAge=1, eTagContributors={AnalysisStateContributor.class, RequestContributor.class})
    @RequiresProjectPermission(value={EProjectPermission.VIEW})
    @GET
    public List<PrioritizableTestPre80> getImpactedTests(@BeanParam LegacyTiaRequestOptionsPre80 tiaRequestOptions) throws StorageException, InterruptedException {
        List<PrioritizableTest> impactedTests = ((ImpactedTestsService)this.resourceContext.getResource(ImpactedTestsService.class)).getImpactedTests(tiaRequestOptions.toTiaRequestOptions());
        return PrioritizableTestPre80.from(impactedTests);
    }

    @PublicApi(since=ETeamscaleVersion.VERSION_5_7_0, deprecatedSince=ETeamscaleVersion.VERSION_8_0_0)
    @UncriticalStatusCode(value=Response.Status.PRECONDITION_FAILED)
    @Operation(summary="Get impacted tests", description="Returns an ordered list of test clusters that are impacted by the given changes. The returned list of test clusters is a subset of the tests given in the request body. Clusters of selected and prioritized tests are formed based on the clustering information given in the request body. The tests from the request body are furthermore used to determine if any tests have changed or new tests were added. These are always included in the returned list of impacted tests.", tags={"Test Intelligence"}, responses={@ApiResponse(responseCode="412", description="The given commit has not been processed yet."), @ApiResponse(responseCode="400", description="One of the given options is invalid.")})
    @RequiresProjectPermission(value={EProjectPermission.VIEW})
    @PUT
    public List<PrioritizableTestClusterPre80> getImpactedTests(@BeanParam LegacyTiaRequestOptionsPre80 tiaRequestOptions, @RequestBody List<ClusteredTestDetailsPre80> availableTests) throws StorageException, InterruptedException {
        HistoryAccessOption historyAccessOption = this.determineHistoryOption(tiaRequestOptions.getEndCommit());
        TestLinksIndex testLinksIndex = this.openProjectIndex(TestLinksIndex.class, historyAccessOption);
        List<TestWithClusterId> testWithPartition = LegacyImpactedTestsService.ensurePartitionIsSet(testLinksIndex, availableTests, tiaRequestOptions.getPartitions());
        List<PrioritizableTestCluster> impactedTests = ((ImpactedTestsService)this.resourceContext.getResource(ImpactedTestsService.class)).getImpactedTestsFromAvailableTests(tiaRequestOptions.toTiaRequestOptions(), testWithPartition);
        return PrioritizableTestClusterPre80.from(impactedTests);
    }

    private static List<TestWithClusterId> ensurePartitionIsSet(TestLinksIndex testLinksIndex, Collection<ClusteredTestDetailsPre80> testsAvailableForExecution, Set<String> requestedPartitions) throws StorageException {
        ArrayList<TestWithClusterId> result = new ArrayList<TestWithClusterId>();
        List testLinks = testLinksIndex.getTestLinks(CollectionUtils.map(testsAvailableForExecution, ClusteredTestDetailsPre80::getUniformPath));
        CollectionUtils.forEach(testsAvailableForExecution, (Iterable)testLinks, (clusteredTestDetails, testLink) -> result.add(LegacyImpactedTestsService.convertToTestWithPartition(requestedPartitions, clusteredTestDetails, testLink)));
        return result;
    }

    private static TestWithClusterId convertToTestWithPartition(Set<String> requestedPartitions, ClusteredTestDetailsPre80 clusteredTestDetails, TestLinks testLink) {
        if (testLink == null) {
            return clusteredTestDetails.withPartition("new");
        }
        Set partitions = testLink.getPartitions();
        if (!requestedPartitions.isEmpty()) {
            partitions.retainAll(requestedPartitions);
        }
        if (partitions.isEmpty()) {
            return clusteredTestDetails.withPartition("unknown");
        }
        return clusteredTestDetails.withPartition((String)CollectionUtils.getAny((Iterable)partitions));
    }
}

