/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.testimpact.legacy;

import com.teamscale.index.testimpact.ETestPrioritizationStrategy;
import com.teamscale.index.testimpact.TiaPartitionsQueryParams;
import com.teamscale.index.testimpact.TiaRequestOptions;
import com.teamscale.index.testimpact.TiaTestFilterQueryParams;
import io.swagger.v3.oas.annotations.Parameter;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.QueryParam;
import java.util.Set;
import org.conqat.engine.index.shared.UnresolvedCommitDescriptor;
import org.conqat.lib.commons.uniformpath.UniformPath;

public class LegacyTiaRequestOptionsPre80 {
    private static final String INCLUDE_ADDED_TESTS_PARAMETER_NAME = "include-added-tests";
    private static final String INCLUDE_NON_IMPACTED = "include-non-impacted";
    private static final String PRIORITIZATION_STRATEGY = "prioritization-strategy";
    private static final String ENSURE_PROCESSED = "ensure-processed";
    private static final String INCLUDE_FAILED_AND_SKIPPED = "include-failed-and-skipped";
    @QueryParam(value="baseline")
    @DefaultValue(value="1")
    @Parameter(description="The baseline commit (exclusive). This parameter can be used to pass a timestamp giving the time (in milliseconds since 1970) for which the data should be provided or \"HEAD\" to refer to the most recent commit. This can optionally be prefixed by the name of the branch, followed by a colon (by default, we use the default branch). You can append a \"p1\" to resolve to the immediate parent of the most recent commit at the given branch/timestamp. p2 would resolve to the parent of the immediate parent and so on. In merge commits, the parent resolution considers only the first parent. You can append \"e\" to include the potential external report uploads of the commit. A parameter value that uses all features would be \"master:1601637680000p1e\"")
    private UnresolvedCommitDescriptor baselineCommit;
    @QueryParam(value="end")
    @Parameter(description="The end commit (inclusive). This parameter can be used to pass a timestamp giving the time (in milliseconds since 1970) for which the data should be provided or \"HEAD\" to refer to the most recent commit. This can optionally be prefixed by the name of the branch, followed by a colon (by default, we use the default branch). You can append a \"p1\" to resolve to the immediate parent of the most recent commit at the given branch/timestamp. p2 would resolve to the parent of the immediate parent and so on. In merge commits, the parent resolution considers only the first parent. You can append \"e\" to include the potential external report uploads of the commit. A parameter value that uses all features would be \"master:1601637680000p1e\"", required=true)
    private UnresolvedCommitDescriptor endCommit;
    @QueryParam(value="partitions")
    @Parameter(description="This parameter may be given multiple times. Specifies the test coverage partitions to consider.")
    private Set<String> partitions;
    @QueryParam(value="prioritization-strategy")
    @Parameter(description="The name of the test prioritization strategy")
    @DefaultValue(value="ADDITIONAL_COVERAGE_PER_TIME")
    private ETestPrioritizationStrategy prioritizationStrategy;
    @QueryParam(value="ensure-processed")
    @Parameter(description="If set to true the request will fail with '412 PRECONDITION FAILED' if the exact given end commit has not been processed yet and therefore data may not be up-to-date.")
    @DefaultValue(value="true")
    private boolean ensureProcessed;
    @QueryParam(value="include-non-impacted")
    @Parameter(description="Append and prioritize non-impacted tests after impacted tests")
    private boolean includeNonImpactedTests;
    @QueryParam(value="include-failed-and-skipped")
    @Parameter(description="Append and prioritize previously failed and skipped tests before impacted tests.")
    private boolean includeFailedAndSkippedTests;
    @QueryParam(value="include-added-tests")
    @Parameter(description="Append and prioritize tests for which there is no coverage yet.")
    @DefaultValue(value="true")
    private boolean includeAddedTests;

    public LegacyTiaRequestOptionsPre80() {
    }

    public LegacyTiaRequestOptionsPre80(UnresolvedCommitDescriptor baselineCommit, UnresolvedCommitDescriptor endCommit, Set<String> partitions, ETestPrioritizationStrategy prioritizationStrategy, boolean ensureProcessed, boolean includeNonImpactedTests, boolean includeFailedAndSkippedTests) {
        this.baselineCommit = baselineCommit;
        this.endCommit = endCommit;
        this.partitions = partitions;
        this.prioritizationStrategy = prioritizationStrategy;
        this.ensureProcessed = ensureProcessed;
        this.includeNonImpactedTests = includeNonImpactedTests;
        this.includeFailedAndSkippedTests = includeFailedAndSkippedTests;
        this.includeAddedTests = true;
    }

    public UnresolvedCommitDescriptor getEndCommit() {
        return this.endCommit;
    }

    public Set<String> getPartitions() {
        return this.partitions;
    }

    public boolean isEnsureProcessed() {
        return this.ensureProcessed;
    }

    public TiaRequestOptions toTiaRequestOptions() {
        return new TiaRequestOptions(this.baselineCommit, this.endCommit, new TiaPartitionsQueryParams(this.partitions, this.partitions.isEmpty()), this.prioritizationStrategy, this.ensureProcessed, new TiaTestFilterQueryParams(this.includeNonImpactedTests, this.includeFailedAndSkippedTests, this.includeAddedTests), null, (UniformPath)UniformPath.codeRoot());
    }
}

