/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.tests;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.teamscale.core.permissions.roles.EProjectPermission;
import com.teamscale.index.query.StoredQueryIndex;
import com.teamscale.index.tests.TestHistoryEntry;
import com.teamscale.index.tests.TestHistoryIndex;
import com.teamscale.service.base.SortAndPaginationOptions;
import com.teamscale.service.framework.authorization.RequiresProjectPermission;
import com.teamscale.service.issues.QueryServiceBase;
import com.teamscale.service.tests.TestQueryUtils;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import jakarta.ws.rs.BeanParam;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.QueryParam;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.conqat.engine.index.shared.UnresolvedCommitDescriptor;
import org.conqat.engine.index.shared.tests.ETestExecutionResult;
import org.conqat.engine.persistence.index.keyed.IKeyedObjectDescriber;
import org.conqat.engine.persistence.index.keyed.IKeyedObjectIndex;
import org.conqat.engine.persistence.index.keyed.query.autocomplete.AutocompletionResult;
import org.conqat.engine.persistence.index.keyed.query.autocomplete.IndexAutocompleter;
import org.conqat.engine.persistence.index.keyed.query.lexer.EQueryTokenType;
import org.conqat.engine.persistence.index.schema.ProjectStorageSystem;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.Pair;

@Path(value="api/projects/{project}/test-query")
public class TestQueryService
extends QueryServiceBase {
    @GET
    @Operation(summary="Perform test query", description="Retrieves the size and list of tests for the query.", responses={@ApiResponse(responseCode="400", content={@Content(mediaType="application/json", schema=@Schema(implementation=QueryServiceBase.QueryParserFailure.class))}, description="Could not process query.")}, tags={"Tests"})
    @RequiresProjectPermission(value={EProjectPermission.VIEW})
    public TestQueryResult performTestQuery(@Parameter(description="Test query", required=true, allowEmptyValue=true) @QueryParam(value="query") String query, @BeanParam SortAndPaginationOptions sortAndPaginationOptions, @QueryParam(value="t") @Parameter(description="This parameter can be used to pass a timestamp giving the time (in milliseconds since 1970) for which the data should be provided. This can optionally be prefixed by the name of the branch, followed by a colon.") UnresolvedCommitDescriptor unresolvedCommit, @QueryParam(value="on-partition-level") @Parameter(description="If true, one result entry is returned per uniform path and partition") boolean onPartitionLevel, @QueryParam(value="only-with-coverage") @Parameter(description="If true only tests with testwise coverage will be returned") boolean onlyWithCoverage) throws StorageException {
        List<TestHistoryEntry> testHistoryEntries = TestQueryUtils.getTestHistoryEntries(query, onlyWithCoverage, onPartitionLevel, this.resolve(unresolvedCommit), this.serviceInfo);
        int resultSize = testHistoryEntries.size();
        testHistoryEntries = sortAndPaginationOptions.sortAndPaginate(testHistoryEntries, arg_0 -> ((IKeyedObjectDescriber)TestHistoryIndex.DESCRIBER).getValueComparator(arg_0));
        return new TestQueryResult(resultSize, testHistoryEntries, sortAndPaginationOptions.getNextStartIndex());
    }

    @GET
    @Path(value="autocomplete")
    @Operation(summary="Get autocompletion suggestions", description="Retrieves a list of autocompletion suggestions for the given query.", tags={"Tests"})
    @RequiresProjectPermission(value={EProjectPermission.VIEW})
    public AutocompletionResult getAutocompletionSuggestions(@Parameter(description="Token to generate autocompletion suggestions for", required=true, allowEmptyValue=true) @QueryParam(value="token") String queryTerm, @QueryParam(value="t") @Parameter(description="This parameter can be used to pass a timestamp giving the time (in milliseconds since 1970) for which the data should be provided. This can optionally be prefixed by the name of the branch, followed by a colon.") UnresolvedCommitDescriptor commit) throws StorageException {
        TestHistoryIndex testHistoryIndex = this.openProjectIndex(TestHistoryIndex.class, this.determineHistoryOption(commit));
        List testExecutionResults = ETestExecutionResult.getReadableNames();
        return new IndexAutocompleter((IKeyedObjectIndex)testHistoryIndex, Map.of("result", testExecutionResults), Map.of(new Pair((Object)EQueryTokenType.QUERY, (Object)0), () -> StoredQueryIndex.openIndex((ProjectStorageSystem)this.getProjectStorageSystem(), (StoredQueryIndex.EStoredQueryType)StoredQueryIndex.EStoredQueryType.TEST).getAllQueryNames()), 10).getSuggestions(queryTerm);
    }

    @GET
    @Path(value="validation")
    @RequiresProjectPermission(value={EProjectPermission.VIEW})
    @Operation(summary="Validate test query", description="Decides whether an test query is valid.", tags={"Tests"})
    public boolean isTestQueryValid(@Parameter(description="Test query to validate", required=true, allowEmptyValue=true) @QueryParam(value="query") String queryTerm) throws StorageException {
        return this.validateQuery(queryTerm, StoredQueryIndex.EStoredQueryType.TEST);
    }

    private static class TestQueryResult {
        @JsonProperty(value="resultSize")
        private final int resultSize;
        @JsonProperty(value="tests")
        private final List<TestHistoryEntry> tests = new ArrayList<TestHistoryEntry>();
        @JsonProperty(value="nextStartIndex")
        private final int nextStartIndex;

        private TestQueryResult(int resultSize, List<TestHistoryEntry> tests, int nextStartIndex) {
            this.resultSize = resultSize;
            this.nextStartIndex = nextStartIndex;
            this.tests.addAll(tests);
        }
    }
}

