/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.user;

import com.teamscale.core.permissions.roles.EBasicPermission;
import com.teamscale.core.permissions.roles.EBasicPermissionScope;
import com.teamscale.core.user.User;
import com.teamscale.index.user.UserAliasLookup;
import com.teamscale.service.base.ApiBase;
import com.teamscale.service.framework.authorization.RequiresNoPermission;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.FormParam;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.conqat.engine.persistence.index.schema.GlobalStorageSystem;
import org.conqat.engine.persistence.store.StorageException;

@Path(value="api/users/names/resolution")
public class UserAliasResolutionService
extends ApiBase {
    @POST
    @Consumes(value={"application/x-www-form-urlencoded"})
    @RequiresNoPermission(description="This API requires VIEW permission for every resolved user. If the permission is missing, the supplied value is returned back.")
    @Operation(summary="Resolve username or alias", description="Retrieves the usernames for the supplied aliases, usernames, full names or e-mail addresses. For users which cannot be resolved, the supplied value is returned back.", tags={"Users", "Administration"})
    public List<String> postResolveUserAliases(@Parameter(description="User aliases to resolve") @FormParam(value="alias") List<String> aliases) throws StorageException {
        return this.resolveUserAliases(aliases);
    }

    private List<String> resolveUserAliases(List<String> aliases) throws StorageException {
        UserAliasLookup userLookup = UserAliasLookup.createInstance((GlobalStorageSystem)this.getGlobalStorageSystem());
        ArrayList<String> users = new ArrayList<String>();
        for (String alias : aliases) {
            Optional resolvedUser = userLookup.resolveUser(alias);
            if (resolvedUser.isPresent() && this.getPermissions().hasBasicPermission(EBasicPermissionScope.USERS, ((User)resolvedUser.get()).getUsername(), EBasicPermission.VIEW)) {
                users.add(((User)resolvedUser.get()).toWebUIString());
                continue;
            }
            users.add(alias);
        }
        return users;
    }
}

