/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.user;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.teamscale.core.user.User;
import com.teamscale.index.repository.ECommitType;
import com.teamscale.index.repository.RepositoryLogEntry;
import java.util.Objects;
import java.util.Set;
import org.conqat.engine.index.shared.ParentedCommitDescriptor;
import org.conqat.lib.commons.test.IndexValueClass;
import org.jspecify.annotations.Nullable;

@IndexValueClass
public class UserResolvedRepositoryLogEntry
extends RepositoryLogEntry {
    private static final long serialVersionUID = 1L;
    private static final String RESOLVED_AUTHOR_PROPERTY = "resolvedAuthor";
    @JsonProperty(value="resolvedAuthor")
    private final @Nullable User resolvedAuthor;
    @JsonProperty(value="commit")
    private final ParentedCommitDescriptor parentedCommit;

    public UserResolvedRepositoryLogEntry(RepositoryLogEntry entry, ParentedCommitDescriptor parentedCommitDescriptor, @Nullable User resolvedAuthor) {
        super(entry.getRevision(), parentedCommitDescriptor.getCommit(), entry.getMessage(), entry.getAuthor(), entry.getEmail(), entry.getNumAddedFiles(), entry.getNumChangedFiles(), entry.getNumDeletedFiles(), entry.getConnectorIdentifier(), entry.getCommitTypes(), entry.getUploadTimestamp());
        this.parentedCommit = parentedCommitDescriptor;
        this.resolvedAuthor = resolvedAuthor;
    }

    @JsonCreator
    public UserResolvedRepositoryLogEntry(@JsonProperty(value="resolvedAuthor") @Nullable User resolvedAuthor, @JsonProperty(value="revision") String revision, @JsonProperty(value="commit") ParentedCommitDescriptor commit, @JsonProperty(value="message") String message, @JsonProperty(value="author") String author, @JsonProperty(value="repositoryIdentifier") String connectorIdentifier, @JsonProperty(value="commitTypes") Set<ECommitType> commitTypes, @JsonProperty(value="uploadTimestamp") @Nullable Long uploadTimestamp) {
        super(revision, commit.getCommit(), message, author, null, 0, 0, 0, connectorIdentifier, commitTypes, uploadTimestamp);
        this.parentedCommit = commit;
        this.resolvedAuthor = resolvedAuthor;
    }

    public @Nullable User getResolvedAuthor() {
        return this.resolvedAuthor;
    }

    public ParentedCommitDescriptor getParentedCommit() {
        return this.parentedCommit;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof UserResolvedRepositoryLogEntry)) {
            return false;
        }
        UserResolvedRepositoryLogEntry that = (UserResolvedRepositoryLogEntry)((Object)obj);
        if (!super.equals(obj)) {
            return false;
        }
        return Objects.equals(this.resolvedAuthor, that.resolvedAuthor) && Objects.equals(this.parentedCommit, that.parentedCommit);
    }

    public int hashCode() {
        return Objects.hash(super.hashCode(), this.resolvedAuthor, this.parentedCommit);
    }

    protected boolean canEqual(Object other) {
        return other instanceof UserResolvedRepositoryLogEntry;
    }

    public String toString() {
        return super.toString() + " resolved Author: " + String.valueOf(this.resolvedAuthor) + " parented Commit: " + String.valueOf(this.parentedCommit);
    }
}

