/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.webhook.github.event_handler;

import com.teamscale.core.analysis.configuration.ProjectConfigurationException;
import com.teamscale.core.index.IndexLayer;
import com.teamscale.index.repository.RepositoryUpdateUtils;
import com.teamscale.index.repository.git.common.PlatformRepositoryIdentifier;
import com.teamscale.index.repository.git.github.GitHubCheckRunCleanupOption;
import com.teamscale.index.repository.git.github.GitHubCrossRepositoryMergeRequestHandler;
import com.teamscale.index.repository.git.github.GitHubPendingCheckRunReporter;
import com.teamscale.index.repository.git.github.data.GitHubPullRequest;
import com.teamscale.index.repository.git.in_progress_reporting.AnalysisInProgressReporter;
import com.teamscale.service.webhook.github.data.PullRequestEventPayload;
import com.teamscale.service.webhook.github.event_handler.GitHubWebhookEventHandlerBase;
import com.teamscale.service.webhook.github.event_handler.IMergeRequestUpdateTriggerSchedulingHelper;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.commons.util.JsonSerializationException;
import org.conqat.engine.commons.util.JsonUtils;
import org.conqat.engine.core.configuration.EFeatureToggle;
import org.conqat.engine.index.shared.MergeRequestIdentifier;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.intellij.lang.annotations.Language;
import org.jetbrains.annotations.TestOnly;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

class GitHubPullRequestEventHandler
extends GitHubWebhookEventHandlerBase {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final String EDITED_PULL_REQUEST_ACTION = "edited";
    private static final String SYNCHRONIZE_PULL_REQUEST_ACTION = "synchronize";
    private static final String CLOSED_PULL_REQUEST_ACTION = "closed";
    private static final String OPENED_PULL_REQUEST_ACTION = "opened";
    private static final String REOPENED_PULL_REQUEST_ACTION = "reopened";
    private static final Set<String> RELEVANT_PULL_REQUEST_ACTIONS = CollectionUtils.asHashSet((Object[])new String[]{"synchronize", "edited", "opened", "reopened", "closed"});
    private final IMergeRequestUpdateTriggerSchedulingHelper schedulingHelper;
    private @Nullable GitHubPendingCheckRunReporter pendingCheckRunReporter;

    @TestOnly
    GitHubPullRequestEventHandler(IndexLayer indexLayer, IMergeRequestUpdateTriggerSchedulingHelper schedulingHelper, @NonNull GitHubPendingCheckRunReporter pendingCheckRunReporter) {
        this(indexLayer, schedulingHelper);
        this.pendingCheckRunReporter = pendingCheckRunReporter;
    }

    GitHubPullRequestEventHandler(IndexLayer indexLayer, IMergeRequestUpdateTriggerSchedulingHelper schedulingHelper) {
        super(indexLayer);
        this.schedulingHelper = schedulingHelper;
    }

    @Override
    public void handle(@Language(value="JSON") String eventPayload) throws StorageException, JsonSerializationException {
        PullRequestEventPayload pullRequestPayload = (PullRequestEventPayload)JsonUtils.deserializeFromJsonWithNullCheck((String)eventPayload, PullRequestEventPayload.class);
        String action = pullRequestPayload.action();
        String cloneUrl = pullRequestPayload.repository().cloneUrl();
        if (action.equals(SYNCHRONIZE_PULL_REQUEST_ACTION) && GitHubCrossRepositoryMergeRequestHandler.isCrossRepoMergeRequest((GitHubPullRequest)pullRequestPayload.pullRequest())) {
            RepositoryUpdateUtils.extractAndScheduleAffectedTriggers((String)cloneUrl, (IndexLayer)this.indexLayer, null);
        }
        String repositoryName = pullRequestPayload.repository().fullName();
        long pullRequestNumber = pullRequestPayload.number();
        String pullRequestWithRepo = repositoryName + "/" + pullRequestNumber;
        this.schedulingHelper.addPullRequestToWebhookPayloadIndex(cloneUrl, repositoryName, pullRequestNumber, pullRequestPayload.pullRequest());
        if (!RELEVANT_PULL_REQUEST_ACTIONS.contains(action)) {
            LOGGER.debug("Not scheduling merge request update triggers for pull request '{}' because action '{}' is not relevant.", (Object)pullRequestWithRepo, (Object)action);
            return;
        }
        this.schedulingHelper.scheduleMergeRequestUpdateTriggersForPullRequest(cloneUrl, repositoryName, pullRequestNumber);
        if (!action.equals(OPENED_PULL_REQUEST_ACTION) && !action.equals(SYNCHRONIZE_PULL_REQUEST_ACTION)) {
            GitHubPullRequestEventHandler.logMessageRegardingInProgressCheckRun("Not sending in-progress check run for pull request '{}' because action '{}' indicates that the pull request might not need new annotations.", pullRequestWithRepo, action);
            return;
        }
        GitHubPullRequestEventHandler.logMessageRegardingInProgressCheckRun("Sending in-progress check run for pull request '{}' and action '{}'.", pullRequestWithRepo, action);
        this.postCheckRunInProgress(pullRequestPayload.number(), pullRequestPayload.pullRequest().head().sha(), PlatformRepositoryIdentifier.fromRepositoryPath((String)repositoryName));
    }

    private static void logMessageRegardingInProgressCheckRun(String messageTemplate, String pullRequestWithRepo, String action) {
        if (EFeatureToggle.ENABLE_MERGE_REQUEST_ANALYSIS_IN_PROGRESS_NOTIFICATION.isEnabled()) {
            LOGGER.debug(messageTemplate, (Object)pullRequestWithRepo, (Object)action);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void postCheckRunInProgress(long pullRequestNumber, String headRevision, PlatformRepositoryIdentifier repositoryIdentifier) {
        try {
            this.getPendingCheckRunReporter(repositoryIdentifier).reportAnalysisInProgress(headRevision, new MergeRequestIdentifier(repositoryIdentifier.asRepositoryPath(), pullRequestNumber));
        }
        catch (AnalysisInProgressReporter.ConnectorNotAvailableException e) {
            LOGGER.atDebug().withThrowable((Throwable)e).log("Skipping \"In Progress\" check run for merge request {} in repository {}, because no matching connector is configured.", (Object)pullRequestNumber, (Object)repositoryIdentifier.asRepositoryPath());
        }
        catch (Exception e) {
            LOGGER.atError().withThrowable((Throwable)e).log("Failed to post \"In Progress\" check run for merge request {} in repository {}.", (Object)pullRequestNumber, (Object)repositoryIdentifier.asRepositoryPath());
        }
        finally {
            try {
                GitHubCheckRunCleanupOption.enable((IndexLayer)this.indexLayer);
            }
            catch (Exception e) {
                LOGGER.atWarn().withThrowable((Throwable)e).log("Failed to enable GitHub check run cleanup option.");
            }
        }
    }

    private GitHubPendingCheckRunReporter getPendingCheckRunReporter(PlatformRepositoryIdentifier repositoryIdentifier) throws StorageException, ProjectConfigurationException {
        if (this.pendingCheckRunReporter == null) {
            this.pendingCheckRunReporter = new GitHubPendingCheckRunReporter(this.indexLayer, repositoryIdentifier);
        }
        return this.pendingCheckRunReporter;
    }
}

