/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.server.rule;

import java.util.Collection;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.sonar.api.server.rule.StringPatternValidator;

public class RuleTagFormat {
    private static final String VALID_CHARACTERS_REGEX = "^[a-z0-9\\+#\\-\\.]+$";
    private static final StringPatternValidator STRING_VALIDATOR = new StringPatternValidator("Rule tags", "^[a-z0-9\\+#\\-\\.]+$");

    private RuleTagFormat() {
    }

    public static boolean isValid(String tag) {
        return STRING_VALIDATOR.isValid(tag);
    }

    public static String validate(String tag) {
        return STRING_VALIDATOR.validate(tag);
    }

    public static Set<String> validate(Collection<String> tags) {
        Set<String> sanitizedTags = tags.stream().filter(Objects::nonNull).filter(entry -> !entry.isEmpty()).map(entry -> entry.toLowerCase(Locale.ENGLISH)).collect(Collectors.toSet());
        STRING_VALIDATOR.validate(sanitizedTags);
        return sanitizedTags;
    }
}

