/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.sonarlint.core.analysis.api;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.sonarsource.sonarlint.core.analysis.api.ClientInputFile;
import org.sonarsource.sonarlint.core.analysis.api.Flow;
import org.sonarsource.sonarlint.core.analysis.api.IssueLocation;
import org.sonarsource.sonarlint.core.analysis.api.QuickFix;
import org.sonarsource.sonarlint.core.analysis.api.WithTextRange;
import org.sonarsource.sonarlint.core.analysis.sonarapi.ActiveRuleAdapter;
import org.sonarsource.sonarlint.core.commons.ImpactSeverity;
import org.sonarsource.sonarlint.core.commons.SoftwareQuality;
import org.sonarsource.sonarlint.core.commons.TextRange;

public class Issue
implements IssueLocation {
    private final String ruleKey;
    private final String primaryMessage;
    private final ClientInputFile clientInputFile;
    private final List<Flow> flows;
    private final List<QuickFix> quickFixes;
    private final Optional<String> ruleDescriptionContextKey;
    private final TextRange textRange;
    private final Map<SoftwareQuality, ImpactSeverity> overriddenImpacts;

    public Issue(ActiveRuleAdapter activeRule, @Nullable String primaryMessage, Map<SoftwareQuality, ImpactSeverity> overriddenImpacts, @Nullable org.sonar.api.batch.fs.TextRange textRange, @Nullable ClientInputFile clientInputFile, List<Flow> flows, List<QuickFix> quickFixes, Optional<String> ruleDescriptionContextKey) {
        this(activeRule.ruleKey().toString(), primaryMessage, overriddenImpacts, Optional.ofNullable(textRange).map(WithTextRange::convert).orElse(null), clientInputFile, flows, quickFixes, ruleDescriptionContextKey);
    }

    public Issue(String ruleKey, @Nullable String primaryMessage, Map<SoftwareQuality, ImpactSeverity> overriddenImpacts, @Nullable TextRange textRange, @Nullable ClientInputFile clientInputFile, List<Flow> flows, List<QuickFix> quickFixes, Optional<String> ruleDescriptionContextKey) {
        this.overriddenImpacts = overriddenImpacts;
        this.textRange = textRange;
        this.ruleKey = ruleKey;
        this.primaryMessage = primaryMessage;
        this.clientInputFile = clientInputFile;
        this.flows = flows;
        this.quickFixes = quickFixes;
        this.ruleDescriptionContextKey = ruleDescriptionContextKey;
    }

    public String getRuleKey() {
        return this.ruleKey;
    }

    @Override
    public String getMessage() {
        return this.primaryMessage;
    }

    @Override
    @CheckForNull
    public ClientInputFile getInputFile() {
        return this.clientInputFile;
    }

    public List<Flow> flows() {
        return this.flows;
    }

    public List<QuickFix> quickFixes() {
        return this.quickFixes;
    }

    @Override
    @CheckForNull
    public TextRange getTextRange() {
        return this.textRange;
    }

    public Map<SoftwareQuality, ImpactSeverity> getOverriddenImpacts() {
        return this.overriddenImpacts;
    }

    public Optional<String> getRuleDescriptionContextKey() {
        return this.ruleDescriptionContextKey;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        sb.append("rule=").append(this.ruleKey);
        if (this.textRange != null) {
            int startLine = this.textRange.getStartLine();
            sb.append(", line=").append(startLine);
        }
        if (this.clientInputFile != null) {
            sb.append(", file=").append(this.clientInputFile.uri());
        }
        sb.append("]");
        return sb.toString();
    }
}

