/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.sonarlint.core.analysis.command;

import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.sonarsource.sonarlint.core.analysis.api.AnalysisConfiguration;
import org.sonarsource.sonarlint.core.analysis.api.AnalysisResults;
import org.sonarsource.sonarlint.core.analysis.api.Issue;
import org.sonarsource.sonarlint.core.analysis.command.Command;
import org.sonarsource.sonarlint.core.analysis.container.global.ModuleRegistry;
import org.sonarsource.sonarlint.core.analysis.container.module.ModuleContainer;
import org.sonarsource.sonarlint.core.commons.log.ClientLogOutput;
import org.sonarsource.sonarlint.core.commons.log.SonarLintLogger;
import org.sonarsource.sonarlint.core.commons.progress.ProgressMonitor;

public class AnalyzeCommand
implements Command<AnalysisResults> {
    @Nullable
    private final Object moduleKey;
    private final AnalysisConfiguration configuration;
    private final Consumer<Issue> issueListener;
    private final ClientLogOutput logOutput;

    public AnalyzeCommand(@Nullable Object moduleKey, AnalysisConfiguration configuration, Consumer<Issue> issueListener, @Nullable ClientLogOutput logOutput) {
        this.moduleKey = moduleKey;
        this.configuration = configuration;
        this.issueListener = issueListener;
        this.logOutput = logOutput;
    }

    @Override
    public AnalysisResults execute(ModuleRegistry moduleRegistry, ProgressMonitor progressMonitor) {
        ModuleContainer moduleContainer;
        if (this.logOutput != null) {
            SonarLintLogger.setTarget(this.logOutput);
        }
        ModuleContainer moduleContainer2 = moduleContainer = this.moduleKey != null ? moduleRegistry.getContainerFor(this.moduleKey) : null;
        if (moduleContainer == null) {
            moduleContainer = moduleRegistry.createTransientContainer(this.configuration.inputFiles());
        }
        Throwable originalException = null;
        try {
            AnalysisResults analysisResults = moduleContainer.analyze(this.configuration, this.issueListener, progressMonitor);
            return analysisResults;
        }
        catch (Throwable e) {
            originalException = e;
            throw e;
        }
        finally {
            try {
                if (moduleContainer.isTransient()) {
                    moduleContainer.stopComponents();
                }
            }
            catch (Exception e) {
                if (originalException != null) {
                    e.addSuppressed(originalException);
                }
                throw e;
            }
        }
    }
}

