/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.sonarlint.core.analysis.container.analysis.issue.ignore.scanner;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import javax.annotation.CheckForNull;
import org.sonarsource.sonarlint.core.analysis.container.analysis.filesystem.FileMetadata;
import org.sonarsource.sonarlint.core.analysis.container.analysis.filesystem.SonarLintInputFile;
import org.sonarsource.sonarlint.core.analysis.container.analysis.issue.ignore.IgnoreIssuesFilter;
import org.sonarsource.sonarlint.core.analysis.container.analysis.issue.ignore.pattern.BlockIssuePattern;
import org.sonarsource.sonarlint.core.analysis.container.analysis.issue.ignore.pattern.IssueExclusionPatternInitializer;
import org.sonarsource.sonarlint.core.analysis.container.analysis.issue.ignore.pattern.IssuePattern;
import org.sonarsource.sonarlint.core.analysis.container.analysis.issue.ignore.scanner.IssueExclusionsRegexpScanner;
import org.sonarsource.sonarlint.shaded.org.apache.commons.lang3.StringUtils;

public class IssueExclusionsLoader {
    private final List<Pattern> allFilePatterns;
    private final List<DoubleRegexpMatcher> blockMatchers;
    private final IgnoreIssuesFilter ignoreIssuesFilter;
    private final IssueExclusionPatternInitializer patternsInitializer;
    private final boolean enableCharHandler;

    public IssueExclusionsLoader(IssueExclusionPatternInitializer patternsInitializer, IgnoreIssuesFilter ignoreIssuesFilter) {
        this.patternsInitializer = patternsInitializer;
        this.ignoreIssuesFilter = ignoreIssuesFilter;
        this.allFilePatterns = new ArrayList<Pattern>();
        this.blockMatchers = new ArrayList<DoubleRegexpMatcher>();
        for (String string : patternsInitializer.getAllFilePatterns()) {
            this.allFilePatterns.add(Pattern.compile(string));
        }
        for (BlockIssuePattern blockIssuePattern : patternsInitializer.getBlockPatterns()) {
            this.blockMatchers.add(new DoubleRegexpMatcher(Pattern.compile(blockIssuePattern.getBeginBlockRegexp()), Pattern.compile(blockIssuePattern.getEndBlockRegexp())));
        }
        this.enableCharHandler = !this.allFilePatterns.isEmpty() || !this.blockMatchers.isEmpty();
    }

    public void addMulticriteriaPatterns(SonarLintInputFile inputFile) {
        for (IssuePattern pattern : this.patternsInitializer.getMulticriteriaPatterns()) {
            if (!pattern.matchFile(inputFile.relativePath())) continue;
            this.ignoreIssuesFilter.addRuleExclusionPatternForComponent(inputFile, pattern.getRulePattern());
        }
    }

    @CheckForNull
    public FileMetadata.CharHandler createCharHandlerFor(SonarLintInputFile inputFile) {
        if (this.enableCharHandler) {
            return new IssueExclusionsRegexpScanner(inputFile, this.allFilePatterns, this.blockMatchers);
        }
        return null;
    }

    public String toString() {
        return "Issues Exclusions - Source Scanner";
    }

    public static class DoubleRegexpMatcher {
        private final Pattern firstPattern;
        private final Pattern secondPattern;

        DoubleRegexpMatcher(Pattern firstPattern, Pattern secondPattern) {
            this.firstPattern = firstPattern;
            this.secondPattern = secondPattern;
        }

        boolean matchesFirstPattern(String line) {
            return this.firstPattern.matcher(line).find();
        }

        boolean matchesSecondPattern(String line) {
            return this.hasSecondPattern() && this.secondPattern.matcher(line).find();
        }

        boolean hasSecondPattern() {
            return StringUtils.isNotEmpty(this.secondPattern.toString());
        }
    }
}

