/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.sonarlint.core.analysis.container.analysis.sensor;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.sonar.api.batch.fs.InputComponent;
import org.sonar.api.batch.fs.TextRange;
import org.sonar.api.batch.rule.ActiveRules;
import org.sonar.api.batch.sensor.code.NewSignificantCode;
import org.sonar.api.batch.sensor.coverage.NewCoverage;
import org.sonar.api.batch.sensor.cpd.NewCpdTokens;
import org.sonar.api.batch.sensor.error.AnalysisError;
import org.sonar.api.batch.sensor.highlighting.NewHighlighting;
import org.sonar.api.batch.sensor.internal.SensorStorage;
import org.sonar.api.batch.sensor.issue.ExternalIssue;
import org.sonar.api.batch.sensor.issue.Issue;
import org.sonar.api.batch.sensor.issue.IssueLocation;
import org.sonar.api.batch.sensor.issue.fix.QuickFix;
import org.sonar.api.batch.sensor.measure.Measure;
import org.sonar.api.batch.sensor.rule.AdHocRule;
import org.sonar.api.batch.sensor.symbol.NewSymbolTable;
import org.sonar.api.issue.impact.Severity;
import org.sonar.api.issue.impact.SoftwareQuality;
import org.sonarsource.sonarlint.core.analysis.api.AnalysisResults;
import org.sonarsource.sonarlint.core.analysis.api.ClientInputFile;
import org.sonarsource.sonarlint.core.analysis.api.ClientInputFileEdit;
import org.sonarsource.sonarlint.core.analysis.api.Flow;
import org.sonarsource.sonarlint.core.analysis.api.Issue;
import org.sonarsource.sonarlint.core.analysis.api.TextEdit;
import org.sonarsource.sonarlint.core.analysis.container.analysis.IssueListenerHolder;
import org.sonarsource.sonarlint.core.analysis.container.analysis.filesystem.SonarLintInputFile;
import org.sonarsource.sonarlint.core.analysis.container.analysis.issue.IssueFilters;
import org.sonarsource.sonarlint.core.analysis.container.analysis.issue.TextRangeUtils;
import org.sonarsource.sonarlint.core.analysis.sonarapi.ActiveRuleAdapter;
import org.sonarsource.sonarlint.core.analysis.sonarapi.DefaultSonarLintIssue;
import org.sonarsource.sonarlint.core.commons.ImpactSeverity;
import org.sonarsource.sonarlint.shaded.org.apache.commons.lang3.StringUtils;

public class SonarLintSensorStorage
implements SensorStorage {
    private final ActiveRules activeRules;
    private final IssueFilters filters;
    private final IssueListenerHolder issueListener;
    private final AnalysisResults analysisResult;

    public SonarLintSensorStorage(ActiveRules activeRules, IssueFilters filters, IssueListenerHolder issueListener, AnalysisResults analysisResult) {
        this.activeRules = activeRules;
        this.filters = filters;
        this.issueListener = issueListener;
        this.analysisResult = analysisResult;
    }

    @Override
    public void store(Measure newMeasure) {
    }

    @Override
    public void store(org.sonar.api.batch.sensor.issue.Issue issue) {
        if (!(issue instanceof DefaultSonarLintIssue)) {
            throw new IllegalArgumentException("Trying to store a non-SonarLint issue?");
        }
        DefaultSonarLintIssue sonarLintIssue = (DefaultSonarLintIssue)issue;
        InputComponent inputComponent = sonarLintIssue.primaryLocation().inputComponent();
        ActiveRuleAdapter activeRule = (ActiveRuleAdapter)this.activeRules.find(sonarLintIssue.ruleKey());
        if (activeRule == null || SonarLintSensorStorage.noSonar(inputComponent, sonarLintIssue)) {
            return;
        }
        String primaryMessage = sonarLintIssue.primaryLocation().message();
        List<Flow> flows = SonarLintSensorStorage.mapFlows(sonarLintIssue.flows());
        List<org.sonarsource.sonarlint.core.analysis.api.QuickFix> quickFixes = SonarLintSensorStorage.transform(sonarLintIssue.quickFixes());
        Map<org.sonarsource.sonarlint.core.commons.SoftwareQuality, ImpactSeverity> overriddenImpacts = SonarLintSensorStorage.transform(sonarLintIssue.overridenImpacts());
        Issue newIssue = new Issue(activeRule, primaryMessage, overriddenImpacts, issue.primaryLocation().textRange(), inputComponent.isFile() ? ((SonarLintInputFile)inputComponent).getClientInputFile() : null, flows, quickFixes, sonarLintIssue.ruleDescriptionContextKey());
        if (this.filters.accept(inputComponent, newIssue)) {
            this.issueListener.handle(newIssue);
        }
    }

    private static List<org.sonarsource.sonarlint.core.analysis.api.QuickFix> transform(List<QuickFix> quickFixes) {
        return quickFixes.stream().map(SonarLintSensorStorage::transform).collect(Collectors.toList());
    }

    private static Map<org.sonarsource.sonarlint.core.commons.SoftwareQuality, ImpactSeverity> transform(Map<SoftwareQuality, Severity> overriddenImpacts) {
        return overriddenImpacts.entrySet().stream().map(e -> Map.entry(org.sonarsource.sonarlint.core.commons.SoftwareQuality.valueOf(((SoftwareQuality)((Object)((Object)e.getKey()))).name()), ImpactSeverity.valueOf(((Severity)((Object)((Object)e.getValue()))).name()))).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    private static org.sonarsource.sonarlint.core.analysis.api.QuickFix transform(QuickFix qf) {
        return new org.sonarsource.sonarlint.core.analysis.api.QuickFix(qf.inputFileEdits().stream().map(edit -> new ClientInputFileEdit(((SonarLintInputFile)edit.target()).getClientInputFile(), edit.textEdits().stream().map(textEdit -> new TextEdit(TextRangeUtils.convert(textEdit.range()), textEdit.newText())).collect(Collectors.toList()))).collect(Collectors.toList()), qf.message());
    }

    private static boolean noSonar(InputComponent inputComponent, org.sonar.api.batch.sensor.issue.Issue issue) {
        TextRange textRange = issue.primaryLocation().textRange();
        return inputComponent.isFile() && textRange != null && ((SonarLintInputFile)inputComponent).hasNoSonarAt(textRange.start().line()) && !StringUtils.containsIgnoreCase(issue.ruleKey().rule(), "nosonar");
    }

    private static List<Flow> mapFlows(List<Issue.Flow> flows) {
        return flows.stream().map(f -> new Flow(new ArrayList<IssueLocation>(f.locations()))).filter(f -> !f.locations().isEmpty()).collect(Collectors.toList());
    }

    @Override
    public void store(NewHighlighting highlighting) {
    }

    @Override
    public void store(NewCoverage defaultCoverage) {
    }

    @Override
    public void store(NewCpdTokens defaultCpdTokens) {
    }

    @Override
    public void store(NewSymbolTable symbolTable) {
    }

    @Override
    public void store(AnalysisError analysisError) {
        ClientInputFile clientInputFile = ((SonarLintInputFile)analysisError.inputFile()).getClientInputFile();
        this.analysisResult.addFailedAnalysisFile(clientInputFile);
    }

    @Override
    public void storeProperty(String key, String value) {
    }

    @Override
    public void store(ExternalIssue issue) {
    }

    @Override
    public void store(NewSignificantCode significantCode) {
    }

    @Override
    public void store(AdHocRule adHocRule) {
    }
}

