/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.sonarlint.core.analysis.sonarapi;

import java.util.Objects;
import javax.annotation.Nullable;
import org.sonar.api.batch.sensor.internal.SensorStorage;
import org.sonar.api.utils.Preconditions;
import org.sonarsource.sonarlint.shaded.org.apache.commons.lang3.builder.ToStringBuilder;
import org.sonarsource.sonarlint.shaded.org.apache.commons.lang3.builder.ToStringStyle;

abstract class DefaultStorable {
    protected final SensorStorage storage;
    private boolean saved = false;

    protected DefaultStorable(@Nullable SensorStorage storage) {
        this.storage = storage;
    }

    public final void save() {
        Objects.requireNonNull(this.storage, "No persister on this object");
        Preconditions.checkState(!this.saved, "This object was already saved");
        this.doSave();
        this.saved = true;
    }

    protected abstract void doSave();

    public String toString() {
        return ToStringBuilder.reflectionToString(this, ToStringStyle.SHORT_PREFIX_STYLE);
    }
}

