/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.sonarlint.core.client.api.standalone;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.annotation.concurrent.Immutable;
import org.sonarsource.sonarlint.core.client.api.common.AbstractAnalysisConfiguration;
import org.sonarsource.sonarlint.core.commons.RuleKey;

@Immutable
public class StandaloneAnalysisConfiguration
extends AbstractAnalysisConfiguration {
    private final Collection<RuleKey> excludedRules;
    private final Collection<RuleKey> includedRules;
    private final Map<RuleKey, Map<String, String>> ruleParameters;
    private final String toString;

    private StandaloneAnalysisConfiguration(Builder builder) {
        super(builder);
        this.excludedRules = builder.excludedRules;
        this.includedRules = builder.includedRules;
        this.ruleParameters = builder.ruleParameters;
        this.toString = this.generateToString();
    }

    public static Builder builder() {
        return new Builder();
    }

    public Collection<RuleKey> excludedRules() {
        return this.excludedRules;
    }

    public Collection<RuleKey> includedRules() {
        return this.includedRules;
    }

    public Map<RuleKey, Map<String, String>> ruleParameters() {
        return this.ruleParameters;
    }

    public String toString() {
        return this.toString;
    }

    private String generateToString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[\n");
        this.generateToStringCommon(sb);
        sb.append("  excludedRules: ").append(this.excludedRules).append("\n");
        sb.append("  includedRules: ").append(this.includedRules).append("\n");
        sb.append("  ruleParameters: ").append(this.ruleParameters).append("\n");
        this.generateToStringInputFiles(sb);
        sb.append("]\n");
        return sb.toString();
    }

    public static final class Builder
    extends AbstractAnalysisConfiguration.AbstractBuilder<Builder> {
        private final Collection<RuleKey> excludedRules = new ArrayList<RuleKey>();
        private final Collection<RuleKey> includedRules = new ArrayList<RuleKey>();
        private final Map<RuleKey, Map<String, String>> ruleParameters = new LinkedHashMap<RuleKey, Map<String, String>>();

        private Builder() {
        }

        public Builder addExcludedRules(RuleKey ... excludedRules) {
            Collections.addAll(this.excludedRules, excludedRules);
            return this;
        }

        public Builder addExcludedRules(Collection<? extends RuleKey> excludedRules) {
            this.excludedRules.addAll(excludedRules);
            return this;
        }

        public Builder addExcludedRule(RuleKey excludedRule) {
            this.excludedRules.add(excludedRule);
            return this;
        }

        public Builder addIncludedRules(RuleKey ... includedRules) {
            Collections.addAll(this.includedRules, includedRules);
            return this;
        }

        public Builder addIncludedRules(Collection<? extends RuleKey> includedRules) {
            this.includedRules.addAll(includedRules);
            return this;
        }

        public Builder addIncludedRule(RuleKey includedRule) {
            this.includedRules.add(includedRule);
            return this;
        }

        public Builder addRuleParameter(RuleKey rule, String parameterKey, String parameterValue) {
            this.ruleParameters.computeIfAbsent(rule, k -> new LinkedHashMap()).put(parameterKey, parameterValue);
            return this;
        }

        public Builder addRuleParameters(RuleKey rule, Map<String, String> parameters) {
            parameters.forEach((k, v) -> this.addRuleParameter(rule, (String)k, (String)v));
            return this;
        }

        public Builder addRuleParameters(Map<RuleKey, Map<String, String>> parameters) {
            parameters.forEach(this::addRuleParameters);
            return this;
        }

        public StandaloneAnalysisConfiguration build() {
            return new StandaloneAnalysisConfiguration(this);
        }
    }
}

