/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.sonarlint.core.embedded.server;

import java.io.IOException;
import java.util.concurrent.CompletableFuture;
import java.util.function.Predicate;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.ClassicHttpResponse;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.HttpException;
import org.apache.hc.core5.http.Method;
import org.apache.hc.core5.http.ParseException;
import org.apache.hc.core5.http.io.HttpRequestHandler;
import org.apache.hc.core5.http.io.entity.EntityUtils;
import org.apache.hc.core5.http.io.entity.StringEntity;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.sonarsource.sonarlint.core.clientapi.backend.connection.auth.HelpGenerateUserTokenResponse;
import org.sonarsource.sonarlint.core.commons.log.SonarLintLogger;
import org.sonarsource.sonarlint.core.embedded.server.AwaitingUserTokenFutureRepository;
import org.sonarsource.sonarlint.shaded.com.google.gson.Gson;

@Named
@Singleton
public class GeneratedUserTokenHandler
implements HttpRequestHandler {
    private static final SonarLintLogger LOG = SonarLintLogger.get();
    private final AwaitingUserTokenFutureRepository awaitingUserTokenFutureRepository;

    public GeneratedUserTokenHandler(AwaitingUserTokenFutureRepository awaitingUserTokenFutureRepository) {
        this.awaitingUserTokenFutureRepository = awaitingUserTokenFutureRepository;
    }

    public void handle(ClassicHttpRequest request, ClassicHttpResponse response, HttpContext context) throws HttpException, IOException {
        String origin;
        if (!Method.POST.isSame(request.getMethod())) {
            response.setCode(400);
            return;
        }
        String token = GeneratedUserTokenHandler.extractAndValidateToken(request);
        if (token == null) {
            response.setCode(400);
            return;
        }
        Header originHeader = request.getHeader("Origin");
        String string = origin = originHeader != null ? originHeader.getValue() : null;
        if (origin == null) {
            response.setCode(400);
            return;
        }
        this.awaitingUserTokenFutureRepository.consumeFutureResponse(origin).filter(Predicate.not(CompletableFuture::isCancelled)).ifPresentOrElse(pendingFuture -> {
            pendingFuture.complete(new HelpGenerateUserTokenResponse(token));
            response.setCode(200);
            response.setEntity((HttpEntity)new StringEntity("OK"));
        }, () -> response.setCode(403));
    }

    private static String extractAndValidateToken(ClassicHttpRequest request) throws IOException, ParseException {
        String requestEntityString = EntityUtils.toString((HttpEntity)request.getEntity(), (String)"UTF-8");
        String token = null;
        try {
            token = new Gson().fromJson((String)requestEntityString, TokenPayload.class).token;
        }
        catch (Exception e) {
            LOG.error("Could not deserialize user token", e);
        }
        return token;
    }

    private static class TokenPayload {
        private String token;

        private TokenPayload() {
        }
    }
}

