/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.sonarlint.core.http;

import java.net.URISyntaxException;
import java.nio.CharBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Objects;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.apache.hc.client5.http.async.methods.AbstractCharResponseConsumer;
import org.apache.hc.client5.http.async.methods.SimpleHttpRequest;
import org.apache.hc.client5.http.async.methods.SimpleHttpResponse;
import org.apache.hc.client5.http.async.methods.SimpleRequestBuilder;
import org.apache.hc.client5.http.config.RequestConfig;
import org.apache.hc.client5.http.impl.async.CloseableHttpAsyncClient;
import org.apache.hc.core5.concurrent.FutureCallback;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.HttpRequest;
import org.apache.hc.core5.http.HttpResponse;
import org.apache.hc.core5.http.nio.AsyncRequestProducer;
import org.apache.hc.core5.http.nio.AsyncResponseConsumer;
import org.apache.hc.core5.http.nio.support.BasicRequestProducer;
import org.apache.hc.core5.util.Timeout;
import org.sonarsource.sonarlint.core.commons.log.SonarLintLogger;
import org.sonarsource.sonarlint.core.http.ApacheHttpResponse;
import org.sonarsource.sonarlint.core.http.HttpClient;
import org.sonarsource.sonarlint.core.http.HttpConnectionListener;

class ApacheHttpClientAdapter
implements HttpClient {
    private static final SonarLintLogger LOG = SonarLintLogger.get();
    private static final Timeout STREAM_CONNECTION_REQUEST_TIMEOUT = Timeout.ofSeconds((long)10L);
    private static final Timeout STREAM_CONNECTION_TIMEOUT = Timeout.ofMinutes((long)1L);
    private final CloseableHttpAsyncClient apacheClient;
    @Nullable
    private final String usernameOrToken;
    @Nullable
    private final String password;
    private boolean connected = false;

    ApacheHttpClientAdapter(CloseableHttpAsyncClient apacheClient, @Nullable String usernameOrToken, @Nullable String password) {
        this.apacheClient = apacheClient;
        this.usernameOrToken = usernameOrToken;
        this.password = password;
    }

    @Override
    public HttpClient.Response post(String url, String contentType, String bodyContent) {
        return ApacheHttpClientAdapter.waitFor(this.postAsync(url, contentType, bodyContent));
    }

    @Override
    public CompletableFuture<HttpClient.Response> postAsync(String url, String contentType, String body) {
        SimpleHttpRequest request = SimpleRequestBuilder.post((String)url).setBody(body, ContentType.parse((CharSequence)contentType)).build();
        return this.executeAsync(request);
    }

    @Override
    public HttpClient.Response get(String url) {
        return ApacheHttpClientAdapter.waitFor(this.getAsync(url));
    }

    @Override
    public CompletableFuture<HttpClient.Response> getAsync(String url) {
        return this.executeAsync(SimpleRequestBuilder.get((String)url).build());
    }

    @Override
    public HttpClient.Response delete(String url, String contentType, String bodyContent) {
        SimpleHttpRequest httpRequest = SimpleRequestBuilder.delete((String)url).setBody(bodyContent, ContentType.parse((CharSequence)contentType)).build();
        return ApacheHttpClientAdapter.waitFor(this.executeAsync(httpRequest));
    }

    private static HttpClient.Response waitFor(CompletableFuture<HttpClient.Response> f) {
        return f.join();
    }

    @Override
    public HttpClient.AsyncRequest getEventStream(String url, final HttpConnectionListener connectionListener, final Consumer<String> messageConsumer) {
        SimpleHttpRequest request = SimpleRequestBuilder.get((String)url).build();
        request.setConfig(RequestConfig.custom().setConnectionRequestTimeout(STREAM_CONNECTION_REQUEST_TIMEOUT).setConnectTimeout(STREAM_CONNECTION_TIMEOUT).setResponseTimeout(Timeout.ZERO_MILLISECONDS).build());
        if (this.usernameOrToken != null) {
            request.setHeader("Authorization", (Object)ApacheHttpClientAdapter.basic(this.usernameOrToken, Objects.requireNonNullElse(this.password, "")));
        }
        request.setHeader("Accept", (Object)"text/event-stream");
        this.connected = false;
        final AtomicBoolean cancelled = new AtomicBoolean();
        Future httpFuture = this.apacheClient.execute((AsyncRequestProducer)new BasicRequestProducer((HttpRequest)request, null), (AsyncResponseConsumer)new AbstractCharResponseConsumer<Object>(){

            public void releaseResources() {
            }

            protected int capacityIncrement() {
                return Integer.MAX_VALUE;
            }

            protected void data(CharBuffer src, boolean endOfStream) {
                if (cancelled.get()) {
                    throw new CancellationException();
                }
                if (ApacheHttpClientAdapter.this.connected) {
                    messageConsumer.accept(src.toString());
                }
            }

            protected void start(HttpResponse httpResponse, ContentType contentType) {
                if (httpResponse.getCode() < 200 || httpResponse.getCode() >= 300) {
                    connectionListener.onError(httpResponse.getCode());
                } else {
                    ApacheHttpClientAdapter.this.connected = true;
                    connectionListener.onConnected();
                }
            }

            protected Object buildResult() {
                return null;
            }

            public void failed(Exception cause) {
                if (cause instanceof CancellationException) {
                    return;
                }
                LOG.error("Stream failed", cause);
            }
        }, (FutureCallback)new FutureCallback<Object>(){

            public void completed(Object result) {
                if (ApacheHttpClientAdapter.this.connected) {
                    connectionListener.onClosed();
                }
            }

            public void failed(Exception ex) {
                if (ApacheHttpClientAdapter.this.connected) {
                    connectionListener.onClosed();
                } else {
                    connectionListener.onError(null);
                }
            }

            public void cancelled() {
                cancelled.set(true);
                LOG.debug("Stream has been cancelled");
            }
        });
        return new HttpAsyncRequest(httpFuture);
    }

    private CompletableFuture<HttpClient.Response> executeAsync(SimpleHttpRequest httpRequest) {
        try {
            if (this.usernameOrToken != null) {
                httpRequest.setHeader("Authorization", (Object)ApacheHttpClientAdapter.basic(this.usernameOrToken, Objects.requireNonNullElse(this.password, "")));
            }
            return new CompletableFutureWrappingFuture(httpRequest);
        }
        catch (Exception e) {
            throw new IllegalStateException("Unable to execute request: " + e.getMessage(), e);
        }
    }

    private static String basic(String username, String password) {
        String usernameAndPassword = String.format("%s:%s", username, password);
        String encoded = Base64.getEncoder().encodeToString(usernameAndPassword.getBytes(StandardCharsets.UTF_8));
        return String.format("Basic %s", encoded);
    }

    public static class HttpAsyncRequest
    implements HttpClient.AsyncRequest {
        private final Future<?> response;

        private HttpAsyncRequest(Future<?> response) {
            this.response = response;
        }

        @Override
        public void cancel() {
            this.response.cancel(true);
        }
    }

    private class CompletableFutureWrappingFuture
    extends CompletableFuture<HttpClient.Response> {
        private final Future<SimpleHttpResponse> wrapped;

        private CompletableFutureWrappingFuture(final SimpleHttpRequest httpRequest) {
            this.wrapped = ApacheHttpClientAdapter.this.apacheClient.execute(httpRequest, (FutureCallback)new FutureCallback<SimpleHttpResponse>(){

                public void completed(SimpleHttpResponse result) {
                    try {
                        String uri = httpRequest.getUri().toString();
                        CompletableFutureWrappingFuture.this.completeAsync(() -> new ApacheHttpResponse(uri, result));
                    }
                    catch (URISyntaxException e) {
                        CompletableFutureWrappingFuture.this.completeAsync(() -> new ApacheHttpResponse(httpRequest.getRequestUri(), result));
                    }
                }

                public void failed(Exception ex) {
                    LOG.debug("Request failed", (Object)ex);
                    CompletableFutureWrappingFuture.this.completeExceptionally(ex);
                }

                public void cancelled() {
                    LOG.debug("Request cancelled");
                    CompletableFutureWrappingFuture.this.cancel();
                }
            });
        }

        private void cancel() {
            super.cancel(true);
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            return this.wrapped.cancel(mayInterruptIfRunning);
        }
    }
}

