/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.sonarlint.core.http;

import java.util.Optional;
import java.util.concurrent.TimeUnit;
import javax.inject.Named;
import javax.inject.Singleton;
import org.eclipse.lsp4j.jsonrpc.messages.Either;
import org.sonarsource.sonarlint.core.clientapi.SonarLintClient;
import org.sonarsource.sonarlint.core.clientapi.client.connection.GetCredentialsParams;
import org.sonarsource.sonarlint.core.clientapi.client.connection.GetCredentialsResponse;
import org.sonarsource.sonarlint.core.clientapi.common.TokenDto;
import org.sonarsource.sonarlint.core.clientapi.common.UsernamePasswordDto;
import org.sonarsource.sonarlint.core.commons.log.SonarLintLogger;
import org.sonarsource.sonarlint.core.http.HttpClient;
import org.sonarsource.sonarlint.core.http.HttpClientProvider;
import org.sonarsource.sonarlint.core.http.WebSocketClient;

@Named
@Singleton
public class ConnectionAwareHttpClientProvider {
    private final SonarLintLogger logger = SonarLintLogger.get();
    private final SonarLintClient client;
    private final HttpClientProvider httpClientProvider;

    public ConnectionAwareHttpClientProvider(SonarLintClient client, HttpClientProvider httpClientProvider) {
        this.client = client;
        this.httpClientProvider = httpClientProvider;
    }

    public HttpClient getHttpClient() {
        return this.httpClientProvider.getHttpClient();
    }

    public HttpClient getHttpClient(String connectionId) {
        Optional<Either<TokenDto, UsernamePasswordDto>> credentials = this.queryClientForConnectionCredentials(connectionId);
        if (credentials.isEmpty()) {
            return this.httpClientProvider.getHttpClient();
        }
        return credentials.get().map(tokenDto -> this.httpClientProvider.getHttpClientWithPreemptiveAuth(tokenDto.getToken(), null), userPass -> this.httpClientProvider.getHttpClientWithPreemptiveAuth(userPass.getUsername(), userPass.getPassword()));
    }

    public WebSocketClient getWebSocketClient(String connectionId) {
        Optional<Either<TokenDto, UsernamePasswordDto>> credentials = this.queryClientForConnectionCredentials(connectionId);
        if (credentials.isEmpty()) {
            throw new IllegalStateException("No credentials for connection " + connectionId);
        }
        if (credentials.get().isRight()) {
            throw new IllegalStateException("Expected token for connection " + connectionId);
        }
        return new WebSocketClient(credentials.get().getLeft().getToken());
    }

    private Optional<Either<TokenDto, UsernamePasswordDto>> queryClientForConnectionCredentials(String connectionId) {
        try {
            GetCredentialsResponse response = this.client.getCredentials(new GetCredentialsParams(connectionId)).get(1L, TimeUnit.MINUTES);
            Either<TokenDto, UsernamePasswordDto> credentials = response.getCredentials();
            if (credentials == null) {
                this.logger.debug("No credentials for connection {}", (Object)connectionId);
                return Optional.empty();
            }
            return Optional.of(credentials);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            this.logger.debug("Interrupted!", (Object)e);
        }
        catch (Exception e) {
            this.logger.error("Error getting credentials for connection {}", (Object)connectionId, (Object)e);
        }
        return Optional.empty();
    }
}

