/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.sonarlint.core.issue;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonarsource.sonarlint.core.ServerApiProvider;
import org.sonarsource.sonarlint.core.clientapi.backend.issue.AddIssueCommentParams;
import org.sonarsource.sonarlint.core.clientapi.backend.issue.ChangeIssueStatusParams;
import org.sonarsource.sonarlint.core.clientapi.backend.issue.CheckAnticipatedStatusChangeSupportedParams;
import org.sonarsource.sonarlint.core.clientapi.backend.issue.CheckAnticipatedStatusChangeSupportedResponse;
import org.sonarsource.sonarlint.core.clientapi.backend.issue.CheckStatusChangePermittedParams;
import org.sonarsource.sonarlint.core.clientapi.backend.issue.CheckStatusChangePermittedResponse;
import org.sonarsource.sonarlint.core.clientapi.backend.issue.IssueService;
import org.sonarsource.sonarlint.core.clientapi.backend.issue.ReopenAllIssuesForFileParams;
import org.sonarsource.sonarlint.core.clientapi.backend.issue.ReopenIssueParams;
import org.sonarsource.sonarlint.core.clientapi.backend.issue.ReopenIssueResponse;
import org.sonarsource.sonarlint.core.clientapi.backend.issue.ResolutionStatus;
import org.sonarsource.sonarlint.core.commons.Binding;
import org.sonarsource.sonarlint.core.commons.IssueStatus;
import org.sonarsource.sonarlint.core.commons.LocalOnlyIssue;
import org.sonarsource.sonarlint.core.commons.LocalOnlyIssueResolution;
import org.sonarsource.sonarlint.core.commons.Transition;
import org.sonarsource.sonarlint.core.commons.Version;
import org.sonarsource.sonarlint.core.issue.AddIssueCommentException;
import org.sonarsource.sonarlint.core.issue.IssueStatusChangeException;
import org.sonarsource.sonarlint.core.local.only.LocalOnlyIssueStorageService;
import org.sonarsource.sonarlint.core.local.only.XodusLocalOnlyIssueStore;
import org.sonarsource.sonarlint.core.repository.config.ConfigurationRepository;
import org.sonarsource.sonarlint.core.serverapi.ServerApi;
import org.sonarsource.sonarlint.core.serverapi.proto.sonarqube.ws.Issues;
import org.sonarsource.sonarlint.core.serverconnection.ServerInfoSynchronizer;
import org.sonarsource.sonarlint.core.serverconnection.StoredServerInfo;
import org.sonarsource.sonarlint.core.serverconnection.storage.ProjectServerIssueStore;
import org.sonarsource.sonarlint.core.storage.StorageService;
import org.sonarsource.sonarlint.core.telemetry.TelemetryServiceImpl;
import org.sonarsource.sonarlint.core.tracking.LocalOnlyIssueRepository;

@Named
@Singleton
public class IssueServiceImpl
implements IssueService {
    private static final String STATUS_CHANGE_PERMISSION_MISSING_REASON = "Marking an issue as resolved requires the 'Administer Issues' permission";
    private static final String UNSUPPORTED_SQ_VERSION_REASON = "Marking a local-only issue as resolved requires SonarQube 10.2+";
    private static final Version SQ_ANTICIPATED_TRANSITIONS_MIN_VERSION = Version.create("10.2");
    private static final Version SQ_ACCEPTED_TRANSITION_MIN_VERSION = Version.create("10.4");
    private static final List<ResolutionStatus> NEW_RESOLUTION_STATUSES = List.of(ResolutionStatus.ACCEPT, ResolutionStatus.FALSE_POSITIVE);
    private static final List<ResolutionStatus> OLD_RESOLUTION_STATUSES = List.of(ResolutionStatus.WONT_FIX, ResolutionStatus.FALSE_POSITIVE);
    private static final Map<ResolutionStatus, Transition> transitionByResolutionStatus = Map.of(ResolutionStatus.ACCEPT, Transition.ACCEPT, ResolutionStatus.WONT_FIX, Transition.WONT_FIX, ResolutionStatus.FALSE_POSITIVE, Transition.FALSE_POSITIVE);
    private final ConfigurationRepository configurationRepository;
    private final ServerApiProvider serverApiProvider;
    private final StorageService storageService;
    private final LocalOnlyIssueStorageService localOnlyIssueStorageService;
    private final LocalOnlyIssueRepository localOnlyIssueRepository;
    private final TelemetryServiceImpl telemetryService;

    public IssueServiceImpl(ConfigurationRepository configurationRepository, ServerApiProvider serverApiProvider, StorageService storageService, LocalOnlyIssueStorageService localOnlyIssueStorageService, TelemetryServiceImpl telemetryService, LocalOnlyIssueRepository localOnlyIssueRepository) {
        this.configurationRepository = configurationRepository;
        this.serverApiProvider = serverApiProvider;
        this.storageService = storageService;
        this.localOnlyIssueStorageService = localOnlyIssueStorageService;
        this.localOnlyIssueRepository = localOnlyIssueRepository;
        this.telemetryService = telemetryService;
    }

    @Override
    public CompletableFuture<Void> changeStatus(ChangeIssueStatusParams params) {
        String configurationScopeId = params.getConfigurationScopeId();
        Optional<Binding> optionalBinding = this.configurationRepository.getEffectiveBinding(configurationScopeId);
        return optionalBinding.flatMap(effectiveBinding -> this.serverApiProvider.getServerApi(effectiveBinding.getConnectionId())).map(connection -> {
            String issueKey;
            Transition reviewStatus = transitionByResolutionStatus.get((Object)params.getNewStatus());
            Binding binding = (Binding)optionalBinding.get();
            ProjectServerIssueStore projectServerIssueStore = this.storageService.binding(binding).findings();
            boolean isServerIssue = projectServerIssueStore.containsIssue(issueKey = params.getIssueKey(), params.isTaintIssue());
            if (isServerIssue) {
                return ((CompletableFuture)connection.issue().changeStatusAsync(issueKey, reviewStatus).thenAccept(nothing -> projectServerIssueStore.updateIssueResolutionStatus(issueKey, params.isTaintIssue(), true).ifPresent(issue -> this.telemetryService.issueStatusChanged(issue.getRuleKey())))).exceptionally(throwable -> {
                    throw new IssueStatusChangeException((Throwable)throwable);
                });
            }
            return IssueServiceImpl.asUUID(issueKey).flatMap(this.localOnlyIssueRepository::findByKey).map(issue -> {
                IssueStatus coreStatus = IssueStatus.valueOf(params.getNewStatus().name());
                issue.resolve(coreStatus);
                XodusLocalOnlyIssueStore localOnlyIssueStore = this.localOnlyIssueStorageService.get();
                return connection.issue().anticipatedTransitions(binding.getSonarProjectKey(), IssueServiceImpl.concat(localOnlyIssueStore.loadAll(configurationScopeId), issue)).thenAccept(nothing -> {
                    localOnlyIssueStore.storeLocalOnlyIssue(params.getConfigurationScopeId(), (LocalOnlyIssue)issue);
                    this.telemetryService.issueStatusChanged(issue.getRuleKey());
                });
            }).orElseThrow(() -> new IssueStatusChangeException("Issue key " + issueKey + " was not found"));
        }).orElseGet(() -> CompletableFuture.completedFuture(null));
    }

    private static List<LocalOnlyIssue> concat(List<LocalOnlyIssue> issues, LocalOnlyIssue issue) {
        return Stream.concat(issues.stream(), Stream.of(issue)).collect(Collectors.toList());
    }

    private static List<LocalOnlyIssue> subtract(List<LocalOnlyIssue> allIssues, List<LocalOnlyIssue> issueToSubtract) {
        return allIssues.stream().filter(it -> issueToSubtract.stream().noneMatch(issue -> issue.getId().equals(it.getId()))).collect(Collectors.toList());
    }

    private boolean checkAnticipatedStatusChangeSupported(ServerApi api, String connectionId) {
        return !api.isSonarCloud() && this.storageService.connection(connectionId).serverInfo().read().map(version -> version.getVersion().satisfiesMinRequirement(SQ_ANTICIPATED_TRANSITIONS_MIN_VERSION)).orElse(false) != false;
    }

    @Override
    public CompletableFuture<CheckAnticipatedStatusChangeSupportedResponse> checkAnticipatedStatusChangeSupported(CheckAnticipatedStatusChangeSupportedParams params) {
        String configScopeId = params.getConfigScopeId();
        Optional<Binding> bindingOpt = this.configurationRepository.getEffectiveBinding(configScopeId);
        if (bindingOpt.isEmpty()) {
            return CompletableFuture.failedFuture(new IllegalArgumentException("Binding for configuration scope ID '" + configScopeId + "' does not exist"));
        }
        Binding binding = bindingOpt.get();
        String connectionId = binding.getConnectionId();
        Optional<ServerApi> serverApiOpt = this.serverApiProvider.getServerApi(connectionId);
        if (serverApiOpt.isEmpty()) {
            return CompletableFuture.failedFuture(new IllegalArgumentException("Connection with ID '" + connectionId + "' does not exist"));
        }
        ServerApi serverApi = serverApiOpt.get();
        return CompletableFuture.completedFuture(new CheckAnticipatedStatusChangeSupportedResponse(this.checkAnticipatedStatusChangeSupported(serverApi, connectionId)));
    }

    @Override
    public CompletableFuture<CheckStatusChangePermittedResponse> checkStatusChangePermitted(CheckStatusChangePermittedParams params) {
        String connectionId = params.getConnectionId();
        Optional<ServerApi> serverApiOpt = this.serverApiProvider.getServerApi(connectionId);
        if (serverApiOpt.isEmpty()) {
            return CompletableFuture.failedFuture(new IllegalArgumentException("Connection with ID '" + connectionId + "' does not exist"));
        }
        String issueKey = params.getIssueKey();
        ServerApi serverApi = serverApiOpt.get();
        return IssueServiceImpl.asUUID(issueKey).flatMap(this.localOnlyIssueRepository::findByKey).map(r -> {
            List<ResolutionStatus> statuses = List.of();
            if (this.checkAnticipatedStatusChangeSupported(serverApi, connectionId)) {
                boolean is104orNewer = !serverApi.isSonarCloud() && this.is104orNewer(connectionId, serverApi);
                statuses = is104orNewer ? NEW_RESOLUTION_STATUSES : OLD_RESOLUTION_STATUSES;
            }
            return CompletableFuture.completedFuture(IssueServiceImpl.toResponse(statuses, UNSUPPORTED_SQ_VERSION_REASON));
        }).orElseGet(() -> serverApi.issue().searchByKey(params.getIssueKey()).thenApply(issue -> IssueServiceImpl.toResponse(IssueServiceImpl.getAdministerIssueTransitions(issue), STATUS_CHANGE_PERMISSION_MISSING_REASON)));
    }

    private boolean is104orNewer(String connectionId, ServerApi serverApi) {
        ServerInfoSynchronizer serverVersionSynchronizer = new ServerInfoSynchronizer(this.storageService.connection(connectionId));
        StoredServerInfo serverVersion = serverVersionSynchronizer.readOrSynchronizeServerInfo(serverApi);
        return serverVersion.getVersion().compareToIgnoreQualifier(SQ_ACCEPTED_TRANSITION_MIN_VERSION) >= 0;
    }

    private static CheckStatusChangePermittedResponse toResponse(List<ResolutionStatus> statuses, String reason) {
        boolean permitted = !statuses.isEmpty();
        return new CheckStatusChangePermittedResponse(permitted, permitted ? null : reason, statuses);
    }

    private static List<ResolutionStatus> getAdministerIssueTransitions(Issues.Issue issue) {
        HashSet possibleTransitions = new HashSet(issue.getTransitions().getTransitionsList());
        if (possibleTransitions.containsAll(IssueServiceImpl.toTransitionStatus(NEW_RESOLUTION_STATUSES))) {
            return NEW_RESOLUTION_STATUSES;
        }
        return possibleTransitions.containsAll(IssueServiceImpl.toTransitionStatus(OLD_RESOLUTION_STATUSES)) ? OLD_RESOLUTION_STATUSES : List.of();
    }

    private static Set<String> toTransitionStatus(List<ResolutionStatus> resolutions) {
        return resolutions.stream().map(resolution -> transitionByResolutionStatus.get(resolution).getStatus()).collect(Collectors.toSet());
    }

    @Override
    public CompletableFuture<Void> addComment(AddIssueCommentParams params) {
        String configurationScopeId = params.getConfigurationScopeId();
        String issueKey = params.getIssueKey();
        return IssueServiceImpl.asUUID(issueKey).flatMap(issueId -> this.setCommentOnLocalOnlyIssue(configurationScopeId, (UUID)issueId, params.getText())).orElseGet(() -> this.addCommentOnServerIssue(configurationScopeId, issueKey, params.getText()));
    }

    @Override
    public CompletableFuture<ReopenIssueResponse> reopenIssue(ReopenIssueParams params) {
        String configurationScopeId = params.getConfigurationScopeId();
        Optional<Binding> optionalBinding = this.configurationRepository.getEffectiveBinding(configurationScopeId);
        return optionalBinding.flatMap(effectiveBinding -> this.serverApiProvider.getServerApi(effectiveBinding.getConnectionId())).map(connection -> {
            String issueId;
            Binding binding = (Binding)optionalBinding.get();
            ProjectServerIssueStore projectServerIssueStore = this.storageService.binding(binding).findings();
            boolean isServerIssue = projectServerIssueStore.containsIssue(issueId = params.getIssueId(), params.isTaintIssue());
            if (isServerIssue) {
                return this.reopenServerIssue((ServerApi)connection, issueId, projectServerIssueStore, params.isTaintIssue());
            }
            return this.reopenLocalIssue(issueId, configurationScopeId);
        }).orElseGet(() -> CompletableFuture.completedFuture(new ReopenIssueResponse(false)));
    }

    @Override
    public CompletableFuture<ReopenIssueResponse> reopenAllIssuesForFile(ReopenAllIssuesForFileParams params) {
        String configurationScopeId = params.getConfigurationScopeId();
        String filePath = params.getRelativePath();
        XodusLocalOnlyIssueStore localOnlyIssueStore = this.localOnlyIssueStorageService.get();
        return ((CompletableFuture)this.removeAllIssuesForFile(localOnlyIssueStore, configurationScopeId, filePath).thenApply(v -> this.localOnlyIssueStorageService.get().removeAllIssuesForFile(configurationScopeId, filePath))).thenApply(ReopenIssueResponse::new);
    }

    private CompletableFuture<Void> removeAllIssuesForFile(XodusLocalOnlyIssueStore localOnlyIssueStore, String configurationScopeId, String filePath) {
        List<LocalOnlyIssue> allIssues = localOnlyIssueStore.loadAll(configurationScopeId);
        List<LocalOnlyIssue> issuesForFile = localOnlyIssueStore.loadForFile(configurationScopeId, filePath);
        List<LocalOnlyIssue> issuesToSync = IssueServiceImpl.subtract(allIssues, issuesForFile);
        Optional<Binding> optionalBinding = this.configurationRepository.getEffectiveBinding(configurationScopeId);
        return optionalBinding.flatMap(effectiveBinding -> this.serverApiProvider.getServerApi(effectiveBinding.getConnectionId())).map(connection -> connection.issue().anticipatedTransitions(((Binding)optionalBinding.get()).getSonarProjectKey(), issuesToSync)).orElseGet(() -> CompletableFuture.completedFuture(null));
    }

    private CompletableFuture<Void> removeIssueOnServer(XodusLocalOnlyIssueStore localOnlyIssueStore, String configurationScopeId, UUID issueId) {
        List<LocalOnlyIssue> allIssues = localOnlyIssueStore.loadAll(configurationScopeId);
        List issuesToSync = allIssues.stream().filter(it -> !it.getId().equals(issueId)).collect(Collectors.toList());
        Optional<Binding> optionalBinding = this.configurationRepository.getEffectiveBinding(configurationScopeId);
        return optionalBinding.flatMap(effectiveBinding -> this.serverApiProvider.getServerApi(effectiveBinding.getConnectionId())).map(connection -> connection.issue().anticipatedTransitions(((Binding)optionalBinding.get()).getSonarProjectKey(), issuesToSync)).orElseGet(() -> CompletableFuture.completedFuture(null));
    }

    private Optional<CompletableFuture<Void>> setCommentOnLocalOnlyIssue(String configurationScopeId, UUID issueId, String comment) {
        XodusLocalOnlyIssueStore localOnlyIssueStore = this.localOnlyIssueStorageService.get();
        return localOnlyIssueStore.find(issueId).flatMap(commentedIssue -> {
            LocalOnlyIssueResolution resolution = commentedIssue.getResolution();
            if (resolution != null) {
                resolution.setComment(comment);
                List<LocalOnlyIssue> issuesToSync = localOnlyIssueStore.loadAll(configurationScopeId);
                issuesToSync.replaceAll(issue -> issue.getId().equals(issueId) ? commentedIssue : issue);
                Optional<Binding> optionalBinding = this.configurationRepository.getEffectiveBinding(configurationScopeId);
                return optionalBinding.flatMap(effectiveBinding -> this.serverApiProvider.getServerApi(effectiveBinding.getConnectionId())).map(connection -> connection.issue().anticipatedTransitions(((Binding)optionalBinding.get()).getSonarProjectKey(), issuesToSync)).map(future -> future.thenAccept(nothing -> localOnlyIssueStore.storeLocalOnlyIssue(configurationScopeId, (LocalOnlyIssue)commentedIssue)));
            }
            return Optional.empty();
        });
    }

    private CompletableFuture<Void> addCommentOnServerIssue(String configurationScopeId, String issueKey, String comment) {
        Optional<Binding> optionalBinding = this.configurationRepository.getEffectiveBinding(configurationScopeId);
        return optionalBinding.flatMap(effectiveBinding -> this.serverApiProvider.getServerApi(effectiveBinding.getConnectionId())).map(connection -> connection.issue().addComment(issueKey, comment).exceptionally(throwable -> {
            throw new AddIssueCommentException((Throwable)throwable);
        })).orElseGet(() -> CompletableFuture.completedFuture(null));
    }

    private CompletableFuture<ReopenIssueResponse> reopenServerIssue(ServerApi connection, String issueId, ProjectServerIssueStore projectServerIssueStore, boolean isTaintIssue) {
        return ((CompletableFuture)((CompletableFuture)connection.issue().changeStatusAsync(issueId, Transition.REOPEN).thenAccept(nothing -> projectServerIssueStore.updateIssueResolutionStatus(issueId, isTaintIssue, false).ifPresent(issue -> this.telemetryService.issueStatusChanged(issue.getRuleKey())))).thenApply(nothing -> new ReopenIssueResponse(true))).exceptionally(throwable -> {
            throw new IssueStatusChangeException((Throwable)throwable);
        });
    }

    private CompletableFuture<ReopenIssueResponse> reopenLocalIssue(String issueId, String configurationScopeId) {
        Optional<UUID> issueUuidOptional = IssueServiceImpl.asUUID(issueId);
        if (issueUuidOptional.isEmpty()) {
            return CompletableFuture.completedFuture(new ReopenIssueResponse(false));
        }
        UUID issueUuid = issueUuidOptional.get();
        XodusLocalOnlyIssueStore localOnlyIssueStore = this.localOnlyIssueStorageService.get();
        return ((CompletableFuture)this.removeIssueOnServer(localOnlyIssueStore, configurationScopeId, issueUuid).thenApply(v -> this.localOnlyIssueStorageService.get().removeIssue(issueUuid))).thenApply(ReopenIssueResponse::new);
    }

    private static Optional<UUID> asUUID(String key) {
        try {
            return Optional.of(UUID.fromString(key));
        }
        catch (Exception e) {
            return Optional.empty();
        }
    }
}

