/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.sonarlint.core.plugin;

import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import javax.annotation.CheckForNull;
import javax.annotation.PreDestroy;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonarsource.sonarlint.core.commons.IOExceptionUtils;
import org.sonarsource.sonarlint.core.plugin.commons.LoadedPlugins;

@Named
@Singleton
public class PluginsRepository {
    private LoadedPlugins loadedEmbeddedPlugins;
    private final Map<String, LoadedPlugins> loadedPluginsByConnectionId = new HashMap<String, LoadedPlugins>();

    public void setLoadedEmbeddedPlugins(LoadedPlugins loadedEmbeddedPlugins) {
        this.loadedEmbeddedPlugins = loadedEmbeddedPlugins;
    }

    @CheckForNull
    public LoadedPlugins getLoadedEmbeddedPlugins() {
        return this.loadedEmbeddedPlugins;
    }

    @CheckForNull
    public LoadedPlugins getLoadedPlugins(String connectionId) {
        return this.loadedPluginsByConnectionId.get(connectionId);
    }

    public void setLoadedPlugins(String connectionId, LoadedPlugins loadedPlugins) {
        this.loadedPluginsByConnectionId.put(connectionId, loadedPlugins);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PreDestroy
    public void unloadAllPlugins() throws IOException {
        LinkedList<IOException> exceptions = new LinkedList<IOException>();
        if (this.loadedEmbeddedPlugins != null) {
            IOExceptionUtils.tryAndCollectIOException(this.loadedEmbeddedPlugins::close, exceptions);
            this.loadedEmbeddedPlugins = null;
        }
        Map<String, LoadedPlugins> map = this.loadedPluginsByConnectionId;
        synchronized (map) {
            this.loadedPluginsByConnectionId.values().forEach(l -> IOExceptionUtils.tryAndCollectIOException(l::close, exceptions));
            this.loadedPluginsByConnectionId.clear();
        }
        IOExceptionUtils.throwFirstWithOtherSuppressed(exceptions);
    }

    public void unload(String connectionId) {
        LoadedPlugins loadedPlugins = this.loadedPluginsByConnectionId.remove(connectionId);
        if (loadedPlugins != null) {
            try {
                loadedPlugins.close();
            }
            catch (IOException e) {
                throw new IllegalStateException("Unable to unload plugins", e);
            }
        }
    }
}

