/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.sonarlint.core.plugin.commons.container;

import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import java.util.regex.Pattern;
import org.sonarsource.sonarlint.core.commons.log.SonarLintLogger;

class ComponentKeys {
    private static final Pattern IDENTITY_HASH_PATTERN = Pattern.compile(".+@[a-f0-9]+");
    private final Set<Class<?>> objectsWithoutToString = new HashSet();

    ComponentKeys() {
    }

    Object of(Object component) {
        return this.of(component, SonarLintLogger.get());
    }

    Object of(Object component, SonarLintLogger log) {
        if (component instanceof Class) {
            return component;
        }
        return this.ofInstance(component, log);
    }

    public String ofInstance(Object component) {
        return this.ofInstance(component, SonarLintLogger.get());
    }

    public String ofClass(Class<?> clazz) {
        return clazz.getClassLoader() + "-" + clazz.getCanonicalName();
    }

    String ofInstance(Object component, SonarLintLogger log) {
        Object key = component.toString();
        if (IDENTITY_HASH_PATTERN.matcher((CharSequence)key).matches()) {
            if (!this.objectsWithoutToString.add(component.getClass())) {
                log.warn(String.format("Bad component key: %s. Please implement toString() method on class %s", key, component.getClass().getName()));
            }
            key = (String)key + UUID.randomUUID().toString();
        }
        return this.ofClass(component.getClass()) + "-" + (String)key;
    }
}

